/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.cassandra.mapping;

import com.datastax.driver.core.DataType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import org.grails.datastore.mapping.cassandra.config.CassandraMappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.validation.Errors;

public class BasicCassandraMappingContext
extends org.springframework.data.cassandra.mapping.BasicCassandraMappingContext {
    CassandraMappingContext gormCassandraMappingContext;

    public BasicCassandraMappingContext(CassandraMappingContext gormCassandraMappingContext) {
        this.gormCassandraMappingContext = gormCassandraMappingContext;
    }

    protected CassandraPersistentEntity<?> addPersistentEntity(TypeInformation<?> typeInformation) {
        if (!typeInformation.getType().isInterface()) {
            return (CassandraPersistentEntity)super.addPersistentEntity(typeInformation);
        }
        return null;
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        Class<?> rawType;
        PersistentEntity gormEntity = this.gormCassandraMappingContext.getPersistentEntity(owner.getName());
        CassandraPersistentProperty property = super.createPersistentProperty(field, descriptor, owner, simpleTypeHolder);
        BasicCassandraPersistentProperty transientProperty = new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

            public boolean isTransient() {
                return true;
            }
        };
        if (field == null && !property.usePropertyAccess()) {
            return transientProperty;
        }
        if (field != null && Modifier.isTransient(field.getModifiers())) {
            return transientProperty;
        }
        if (field != null && "errors".equals(field.getName())) {
            return transientProperty;
        }
        if (field != null && field.getType().equals(Errors.class)) {
            return transientProperty;
        }
        Class<Object> clazz = field != null ? field.getType() : (rawType = descriptor != null ? descriptor.getPropertyType() : null);
        if (rawType == null) {
            return transientProperty;
        }
        if (rawType.isEnum()) {
            return new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

                public DataType getDataType() {
                    return CassandraSimpleTypeHolder.getDataTypeFor(String.class);
                }

                public Class<?> getType() {
                    return String.class;
                }

                public boolean usePropertyAccess() {
                    return true;
                }
            };
        }
        if (URL.class.isAssignableFrom(rawType) || TimeZone.class.isAssignableFrom(rawType) || Locale.class.isAssignableFrom(rawType) || Currency.class.isAssignableFrom(rawType) || Calendar.class.isAssignableFrom(rawType)) {
            return new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

                public DataType getDataType() {
                    return CassandraSimpleTypeHolder.getDataTypeFor(String.class);
                }

                public Class<?> getType() {
                    return String.class;
                }

                public boolean isEntity() {
                    return false;
                }

                public boolean usePropertyAccess() {
                    return true;
                }
            };
        }
        if (field != null && "version".equals(field.getName()) && !gormEntity.isVersioned()) {
            return transientProperty;
        }
        if (!property.isTransient() && (property.isMap() || property.isCollectionLike())) {
            try {
                property.getDataType();
            }
            catch (InvalidDataAccessApiUsageException e) {
                return transientProperty;
            }
        }
        return property;
    }
}

