/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler;

import com.datastax.driver.core.DataType;
import grails.artefact.Artefact;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsDomainClassInjector;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Token;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.datastore.mapping.model.MappingFactory;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.data.annotation.Transient;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.mapping.Column;
import org.springframework.data.cassandra.mapping.Indexed;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.util.ClassUtils;

@AstTransformer
public class GormToCassandraTransform
implements GrailsDomainClassInjector,
GrailsArtefactClassInjector {
    private static final String MAPPED_WITH = "cassandra";

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (GrailsASTUtils.isDomainClass((ClassNode)classNode, (SourceUnit)source) && this.shouldInjectClass(classNode)) {
            if (!classNode.getAnnotations(new ClassNode(Artefact.class)).isEmpty()) {
                return;
            }
            this.performInjectionOnAnnotatedClass(source, classNode);
        }
    }

    public void performInjectionOnAnnotatedEntity(ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(null, classNode);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        block4: {
            try {
                boolean isHibernateInstalled = ClassUtils.isPresent((String)"org.grails.orm.hibernate.AbstractHibernateDatastore", (ClassLoader)this.getClass().getClassLoader());
                boolean cassandraEntity = false;
                String mappedWith = null;
                PropertyNode mappingNode = classNode.getProperty("mapWith");
                if (mappingNode != null && mappingNode.isStatic() && mappingNode.getField() != null) {
                    Expression expression = mappingNode.getField().getInitialExpression();
                    String string = mappedWith = expression.getText() != null ? expression.getText().toLowerCase() : null;
                }
                if (MAPPED_WITH.equals(mappedWith) || !isHibernateInstalled) {
                    cassandraEntity = true;
                }
                GormToCassandraTransform.transformEntity(classNode, cassandraEntity);
            }
            catch (Exception e) {
                if (source == null) break block4;
                String message = "Error occured transfoming GORM entity into Cassandra entity: " + ExceptionUtils.getStackTrace((Throwable)e).replaceAll("(\\" + System.getProperty("line.separator") + ")", " ");
                Token token = Token.newString((String)classNode.getText(), (int)classNode.getLineNumber(), (int)classNode.getColumnNumber());
                LocatedMessage locatedMessage = new LocatedMessage(message, (CSTNode)token, source);
                source.getErrorCollector().addFatalError((Message)locatedMessage);
            }
        }
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    public String[] getArtefactTypes() {
        return new String[]{"Domain"};
    }

    protected boolean shouldInjectClass(ClassNode classNode) {
        return !this.isEnum(classNode);
    }

    public static void transformEntity(ClassNode classNode, boolean cassandraEntity) {
        PropertyNode mappingNode = classNode.getProperty("mapping");
        HashMap propertyMappings = new HashMap();
        if (mappingNode != null && mappingNode.isStatic()) {
            GormToCassandraTransform.populateConfigurationMapFromClosureExpression(classNode, mappingNode, propertyMappings);
        }
        GormToCassandraTransform.injectVersionPropertyIfNecessary(classNode, propertyMappings);
        String primaryKeyPropertyName = "id";
        for (Map.Entry mappingEntry : propertyMappings.entrySet()) {
            String propertyName = (String)mappingEntry.getKey();
            Map propertyConfig = (Map)mappingEntry.getValue();
            String columnName = null;
            Integer ordinal = null;
            PrimaryKeyType primaryKeyType = PrimaryKeyType.PARTITIONED;
            boolean annotatePrimaryKey = false;
            if (propertyConfig.containsKey("name") && propertyName.equals("id")) {
                annotatePrimaryKey = true;
                primaryKeyPropertyName = propertyName = propertyConfig.get("name").toString();
            }
            if (propertyConfig.containsKey("column")) {
                columnName = (String)propertyConfig.get("column");
            }
            if (propertyConfig.containsKey("primaryKey")) {
                annotatePrimaryKey = true;
                Map primaryKeyConfig = (Map)propertyConfig.get("primaryKey");
                if (primaryKeyConfig.containsKey("ordinal")) {
                    ordinal = NumberUtils.toInt((String)("" + primaryKeyConfig.get("ordinal")));
                }
                if (primaryKeyConfig.containsKey("type")) {
                    primaryKeyType = (PrimaryKeyType)EnumUtils.getEnum(PrimaryKeyType.class, (String)primaryKeyConfig.get("type").toString().toUpperCase());
                }
            }
            if (propertyConfig.containsKey("type")) {
                String type = propertyConfig.get("type").toString();
                AnnotationNode typeAnnotationNode = null;
                if ("timeuuid".equals(type)) {
                    typeAnnotationNode = GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.TIMEUUID);
                } else if ("ascii".equals(type)) {
                    typeAnnotationNode = GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.ASCII);
                } else if ("varchar".equals(type)) {
                    typeAnnotationNode = GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.VARCHAR);
                } else if ("counter".equals(type)) {
                    typeAnnotationNode = GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.COUNTER);
                }
                if (typeAnnotationNode != null) {
                    GormToCassandraTransform.annotateProperty(classNode, propertyName, typeAnnotationNode);
                }
            }
            if (propertyConfig.containsKey("index") && BooleanUtils.toBoolean((String)propertyConfig.get("index").toString())) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, Indexed.class);
            }
            if (annotatePrimaryKey) {
                AnnotationNode primaryKeyAnnotation = new AnnotationNode(new ClassNode(PrimaryKeyColumn.class));
                if (columnName != null) {
                    primaryKeyAnnotation.addMember("name", (Expression)new ConstantExpression((Object)columnName));
                }
                if (ordinal != null) {
                    primaryKeyAnnotation.addMember("ordinal", (Expression)new ConstantExpression((Object)ordinal));
                }
                if (primaryKeyType != null) {
                    primaryKeyAnnotation.addMember("type", (Expression)new PropertyExpression((Expression)new ClassExpression(new ClassNode(PrimaryKeyType.class)), (Expression)new ConstantExpression((Object)primaryKeyType)));
                }
                GormToCassandraTransform.annotateProperty(classNode, propertyName, primaryKeyAnnotation);
                continue;
            }
            if (columnName == null) continue;
            GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createColumnAnnotationNode(columnName));
        }
        GormToCassandraTransform.injectIdPropertyIfNecessary(classNode, primaryKeyPropertyName, cassandraEntity);
        GormToCassandraTransform.typeAnnotateProperties(classNode);
        GormToCassandraTransform.annotateIfNecessary(classNode, Table.class);
    }

    private static void populateConfigurationMapFromClosureExpression(ClassNode classNode, PropertyNode mappingNode, Map propertyMappings) {
        ClosureExpression ce = (ClosureExpression)mappingNode.getInitialExpression();
        Statement code = ce.getCode();
        if (!(code instanceof BlockStatement)) {
            return;
        }
        List statements = ((BlockStatement)code).getStatements();
        for (Statement statement : statements) {
            ExpressionStatement es;
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = (es = (ExpressionStatement)statement).getExpression()) instanceof MethodCallExpression)) continue;
            MethodCallExpression mce = (MethodCallExpression)expression;
            String methodName = mce.getMethodAsString();
            HashMap<String, Object> propertyMapping = new HashMap<String, Object>();
            propertyMappings.put(methodName, propertyMapping);
            Expression arguments = mce.getArguments();
            if (arguments instanceof ArgumentListExpression) {
                Expression expr;
                List expressions;
                ArgumentListExpression ale;
                if (methodName.equals("table")) {
                    ale = (ArgumentListExpression)arguments;
                    expressions = ale.getExpressions();
                    if (expressions.isEmpty()) continue;
                    String tableName = ((Expression)expressions.get(0)).getText();
                    AnnotationNode tableAnnotation = new AnnotationNode(new ClassNode(Table.class));
                    tableAnnotation.addMember("value", (Expression)new ConstantExpression((Object)tableName));
                    classNode.addAnnotation(tableAnnotation);
                    continue;
                }
                if (!methodName.equals("version") || (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).isEmpty() || !((expr = (Expression)expressions.get(0)) instanceof ConstantExpression)) continue;
                Object value = ((ConstantExpression)expr).getValue();
                if (value instanceof Boolean) {
                    propertyMapping.put("enabled", value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                propertyMapping.put("column", value);
                continue;
            }
            if (!(arguments instanceof TupleExpression)) continue;
            List tupleExpressions = ((TupleExpression)arguments).getExpressions();
            for (Expression te : tupleExpressions) {
                if (!(te instanceof NamedArgumentListExpression)) continue;
                NamedArgumentListExpression nale = (NamedArgumentListExpression)te;
                for (MapEntryExpression mee : nale.getMapEntryExpressions()) {
                    String settingName = mee.getKeyExpression().getText();
                    Expression valueExpression = mee.getValueExpression();
                    if (valueExpression instanceof ConstantExpression) {
                        if (valueExpression instanceof BooleanExpression) {
                            propertyMapping.put(settingName, Boolean.valueOf(valueExpression.getText()));
                            continue;
                        }
                        propertyMapping.put(settingName, valueExpression.getText());
                        continue;
                    }
                    if (!(valueExpression instanceof MapExpression)) continue;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    propertyMapping.put(settingName, map);
                    for (MapEntryExpression mee2 : ((MapExpression)valueExpression).getMapEntryExpressions()) {
                        map.put(mee2.getKeyExpression().getText(), mee2.getValueExpression().getText());
                    }
                }
            }
        }
    }

    private static void injectIdPropertyIfNecessary(ClassNode classNode, String primaryKeyPropertyName, boolean cassandraEntity) {
        String type;
        PropertyNode primaryKeyProperty;
        boolean hasId = GrailsASTUtils.hasOrInheritsProperty((ClassNode)classNode, (String)primaryKeyPropertyName);
        ClassNode parent = GrailsASTUtils.getFurthestUnresolvedParent((ClassNode)classNode);
        if (!hasId) {
            parent.addProperty(primaryKeyPropertyName, 1, new ClassNode(UUID.class), null, null, null);
        }
        if ((primaryKeyProperty = parent.getProperty(primaryKeyPropertyName)) != null) {
            if (cassandraEntity) {
                ClassNode originalType = primaryKeyProperty.getType();
                type = originalType.getName();
                if (primaryKeyPropertyName.equals("id") && ("long".equals(type) || "java.lang.Long".equals(type))) {
                    MethodNode setter;
                    primaryKeyProperty.setType(new ClassNode(UUID.class));
                    MethodNode getter = classNode.getMethod(GrailsClassUtils.getGetterName((String)primaryKeyPropertyName), new Parameter[0]);
                    if (getter != null) {
                        getter.setReturnType(new ClassNode(UUID.class));
                    }
                    if ((setter = classNode.getMethod(GrailsClassUtils.getSetterName((String)primaryKeyPropertyName), new Parameter[]{new Parameter(originalType, null)})) != null) {
                        setter.setParameters(new Parameter[]{new Parameter(new ClassNode(UUID.class), setter.getParameters()[0].getName())});
                    }
                }
            }
            AnnotationNode primaryKeyAnnotation = new AnnotationNode(new ClassNode(PrimaryKeyColumn.class));
            primaryKeyAnnotation.addMember("type", (Expression)new PropertyExpression((Expression)new ClassExpression(new ClassNode(PrimaryKeyType.class)), (Expression)new ConstantExpression((Object)PrimaryKeyType.PARTITIONED)));
            GormToCassandraTransform.annotateProperty(parent, primaryKeyProperty.getName(), primaryKeyAnnotation);
        }
        if (!primaryKeyPropertyName.equals("id")) {
            PropertyNode idProperty = classNode.getProperty("id");
            if (idProperty == null) {
                FieldNode idField = new FieldNode("id", 130, new ClassNode(Long.class), parent.redirect(), (Expression)new ConstantExpression(null));
                idProperty = new PropertyNode(idField, 130, null, null);
                parent.addProperty(idProperty);
            }
            if (idProperty != null && ("long".equals(type = idProperty.getType().getName()) || "java.lang.Long".equals(type))) {
                idProperty.getField().setModifiers(130);
                GormToCassandraTransform.annotateProperty(classNode, "id", GormToCassandraTransform.createTransientAnnotationNode());
            }
        }
    }

    private static void injectVersionPropertyIfNecessary(ClassNode classNode, Map<String, Map<String, ?>> propertyMappings) {
        Map<String, ?> versionSettings;
        Object object;
        PropertyNode versionProperty;
        boolean hasVersion = GrailsASTUtils.hasOrInheritsProperty((ClassNode)classNode, (String)"version");
        ClassNode parent = GrailsASTUtils.getFurthestUnresolvedParent((ClassNode)classNode);
        if (!hasVersion) {
            parent.addProperty("version", 1, new ClassNode(Long.class), null, null, null);
        }
        if ((versionProperty = classNode.getProperty("version")) != null && propertyMappings.containsKey("version") && (object = (versionSettings = propertyMappings.get("version")).get("enabled")) instanceof Boolean && !((Boolean)object).booleanValue()) {
            versionProperty.getField().setModifiers(130);
            GormToCassandraTransform.annotateField(versionProperty.getField(), GormToCassandraTransform.createTransientAnnotationNode());
        }
    }

    private static void typeAnnotateProperties(ClassNode classNode) {
        PropertyNode transientsMapping = classNode.getProperty("transients");
        ArrayList<String> transientPropertyNameList = new ArrayList<String>();
        GormToCassandraTransform.populateConstantList(transientPropertyNameList, transientsMapping);
        GormToCassandraTransform.annotateAllProperties(classNode, transientPropertyNameList, GormToCassandraTransform.createTransientAnnotationNode());
        List properties = classNode.getProperties();
        for (PropertyNode propertyNode : properties) {
            String propertyName;
            if (!propertyNode.isPublic() || propertyNode.isStatic() || transientPropertyNameList.contains(propertyName = propertyNode.getName())) continue;
            String typeName = propertyNode.getType().getName();
            if ((propertyNode.getModifiers() & 0x80) != 0) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTransientAnnotationNode());
                continue;
            }
            if (typeName.equals(UUID.class.getName())) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.UUID));
                continue;
            }
            if (typeName.equals(String.class.getName())) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.TEXT));
                continue;
            }
            if (typeName.equals(Long.TYPE.getName()) || typeName.equals(Long.class.getName())) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.BIGINT));
                continue;
            }
            if (typeName.equals(Byte.TYPE.getName()) || typeName.equals(Byte.class.getName()) || typeName.equals(Short.TYPE.getName()) || typeName.equals(Short.class.getName())) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTypeAnnotationNode(DataType.Name.INT));
                continue;
            }
            if (propertyNode.getType().isEnum()) continue;
            if (Object.class.getName().equals(typeName)) {
                GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTransientAnnotationNode());
                continue;
            }
            if (MappingFactory.isSimpleType((String)typeName) || GormToCassandraTransform.isCollectionOrMap(propertyNode)) continue;
            GormToCassandraTransform.annotateProperty(classNode, propertyName, GormToCassandraTransform.createTransientAnnotationNode());
        }
    }

    private static AnnotationNode createTypeAnnotationNode(DataType.Name type) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(CassandraType.class));
        annotationNode.addMember("type", (Expression)new PropertyExpression((Expression)new ClassExpression(new ClassNode(DataType.Name.class)), (Expression)new ConstantExpression((Object)type.name().toUpperCase())));
        return annotationNode;
    }

    private static AnnotationNode createColumnAnnotationNode(String columnName) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(Column.class));
        annotationNode.addMember("value", (Expression)new ConstantExpression((Object)columnName));
        return annotationNode;
    }

    private static AnnotationNode createTransientAnnotationNode() {
        return new AnnotationNode(new ClassNode(Transient.class));
    }

    private static Map<String, String> lookupStringToStringMap(ClassNode classNode, String mapName) {
        PropertyNode mapProperty = classNode.getProperty(mapName);
        if (mapProperty == null) {
            return Collections.emptyMap();
        }
        Expression initialExpression = mapProperty.getInitialExpression();
        if (!(initialExpression instanceof MapExpression)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> stringToClassNodeMap = new HashMap<String, String>();
        MapExpression mapExpr = (MapExpression)initialExpression;
        List mapEntryExpressions = mapExpr.getMapEntryExpressions();
        for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
            Expression keyExpression = mapEntryExpression.getKeyExpression();
            if (!(keyExpression instanceof ConstantExpression)) continue;
            ConstantExpression ce = (ConstantExpression)keyExpression;
            String propertyName = ce.getValue().toString();
            Expression valueExpression = mapEntryExpression.getValueExpression();
            if (!(valueExpression instanceof ConstantExpression)) continue;
            stringToClassNodeMap.put(propertyName, ((ConstantExpression)valueExpression).getValue().toString());
        }
        return stringToClassNodeMap;
    }

    private static Map<String, ClassNode> lookupStringToClassNodeMap(ClassNode classNode, String mapName) {
        if (classNode == null) {
            return Collections.emptyMap();
        }
        PropertyNode mapProperty = classNode.getProperty(mapName);
        if (mapProperty == null) {
            return Collections.emptyMap();
        }
        Expression initialExpression = mapProperty.getInitialExpression();
        if (!(initialExpression instanceof MapExpression)) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassNode> stringToClassNodeMap = new HashMap<String, ClassNode>();
        MapExpression mapExpr = (MapExpression)initialExpression;
        List mapEntryExpressions = mapExpr.getMapEntryExpressions();
        for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
            Expression keyExpression = mapEntryExpression.getKeyExpression();
            if (!(keyExpression instanceof ConstantExpression)) continue;
            ConstantExpression ce = (ConstantExpression)keyExpression;
            String propertyName = ce.getValue().toString();
            Expression valueExpression = mapEntryExpression.getValueExpression();
            if (!(valueExpression instanceof ClassExpression)) continue;
            ClassExpression clsExpr = (ClassExpression)valueExpression;
            stringToClassNodeMap.put(propertyName, clsExpr.getType());
        }
        return stringToClassNodeMap;
    }

    private static void annotateIfNecessary(ClassNode classNode, Class<?> annotationClass) {
        ClassNode annotationClassNode = new ClassNode(annotationClass);
        List annotations = classNode.getAnnotations(annotationClassNode);
        if (annotations == null || annotations.isEmpty()) {
            classNode.addAnnotation(new AnnotationNode(annotationClassNode));
        }
    }

    private static void annotateAllProperties(ClassNode classNode, List<String> propertyNames, Class<?> annotation) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(annotation));
        GormToCassandraTransform.annotateAllProperties(classNode, propertyNames, annotationNode);
    }

    private static void annotateAllProperties(ClassNode classNode, Collection<String> propertyNames, AnnotationNode annotationNode) {
        for (String propertyName : propertyNames) {
            GormToCassandraTransform.annotateProperty(classNode, propertyName, annotationNode);
        }
    }

    private static void annotateProperty(ClassNode classNode, String propertyName, Class<?> annotation) {
        GormToCassandraTransform.annotateProperty(classNode, propertyName, new AnnotationNode(new ClassNode(annotation)));
    }

    private static void annotateProperty(ClassNode classNode, String propertyName, AnnotationNode annotationNode) {
        PropertyNode prop = classNode.getProperty(propertyName);
        if (prop == null) {
            return;
        }
        GormToCassandraTransform.annotateField(prop.getField(), annotationNode);
    }

    private static void annotateField(FieldNode fieldNode, AnnotationNode annotationNode) {
        if (fieldNode == null) {
            return;
        }
        List annotations = fieldNode.getAnnotations(annotationNode.getClassNode());
        if (annotations == null || annotations.isEmpty()) {
            fieldNode.addAnnotation(annotationNode);
        }
    }

    private static void populateConstantList(List<String> theList, PropertyNode theProperty) {
        if (theProperty == null) {
            return;
        }
        Expression initialExpression = theProperty.getInitialExpression();
        if (initialExpression instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)initialExpression;
            List entries = listExpression.getExpressions();
            for (Expression expression : entries) {
                if (!(expression instanceof ConstantExpression)) continue;
                GormToCassandraTransform.addConstantExpressionToList(theList, expression);
            }
        } else if (initialExpression instanceof ConstantExpression) {
            GormToCassandraTransform.addConstantExpressionToList(theList, initialExpression);
        }
    }

    private static void addConstantExpressionToList(List<String> theList, Expression expression) {
        Object val = ((ConstantExpression)expression).getValue();
        if (val != null) {
            theList.add(val.toString());
        }
    }

    private static boolean isCollectionOrMap(PropertyNode propertyNode) {
        Set interfaces = propertyNode.getType().getAllInterfaces();
        for (ClassNode inter : interfaces) {
            String name = inter.getName();
            if (!"java.util.Collection".equals(name) && !"java.util.Map".equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnum(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
            if (!parent.getName().equals("java.lang.Enum")) continue;
            return true;
        }
        return false;
    }
}

