/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.artefact.Enhanced;
import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.persistence.Entity;
import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.transform.CompileStatic;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.sc.StaticCompileTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.grails.io.support.FileSystemResource;
import org.springframework.util.StringUtils;

public class GrailsASTUtils {
    public static final String DOMAIN_DIR = "domain";
    public static final String GRAILS_APP_DIR = "grails-app";
    public static final String METHOD_MISSING_METHOD_NAME = "methodMissing";
    public static final String STATIC_METHOD_MISSING_METHOD_NAME = "$static_methodMissing";
    public static final Token EQUALS_OPERATOR = Token.newSymbol((String)"==", (int)0, (int)0);
    public static final Token LOGICAL_AND_OPERATOR = Token.newSymbol((String)"&&", (int)0, (int)0);
    public static final Token NOT_EQUALS_OPERATOR = Token.newSymbol((String)"!=", (int)0, (int)0);
    public static final String OBJECT_CLASS = "java.lang.Object";
    private static final ClassNode ENHANCED_CLASS_NODE = new ClassNode(Enhanced.class);
    public static final ClassNode MISSING_METHOD_EXCEPTION = new ClassNode(MissingMethodException.class);
    public static final ConstantExpression NULL_EXPRESSION = new ConstantExpression(null);
    public static final Token ASSIGNMENT_OPERATOR = Token.newSymbol((int)1100, (int)0, (int)0);
    public static final ClassNode OBJECT_CLASS_NODE = new ClassNode(Object.class).getPlainNodeReference();
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.VOID_TYPE;
    public static final ClassNode INTEGER_CLASS_NODE = new ClassNode(Integer.class).getPlainNodeReference();
    private static final ClassNode COMPILESTATIC_CLASS_NODE = ClassHelper.make(CompileStatic.class);
    private static final ClassNode TYPECHECKINGMODE_CLASS_NODE = ClassHelper.make(TypeCheckingMode.class);
    public static final Parameter[] ZERO_PARAMETERS = new Parameter[0];
    public static final ArgumentListExpression ZERO_ARGUMENTS = new ArgumentListExpression();
    private static final Map<String, ClassNode> emptyGenericsPlaceHoldersMap = Collections.emptyMap();

    public static void warning(SourceUnit sourceUnit, ASTNode node, String warningMessage) {
        String sample = sourceUnit.getSample(node.getLineNumber(), node.getColumnNumber(), new Janitor());
        System.err.println("WARNING: " + warningMessage + "\n\n" + sample);
    }

    public static void error(SourceUnit sourceUnit, ASTNode astNode, String message) {
        GrailsASTUtils.error(sourceUnit, astNode, message, true);
    }

    public static void error(SourceUnit sourceUnit, ASTNode astNode, String message, boolean fatal) {
        SyntaxException syntaxException = new SyntaxException(message, astNode.getLineNumber(), astNode.getColumnNumber());
        SyntaxErrorMessage syntaxErrorMessage = new SyntaxErrorMessage(syntaxException, sourceUnit);
        sourceUnit.getErrorCollector().addError((Message)syntaxErrorMessage, fatal);
    }

    public static boolean hasProperty(ClassNode classNode, String propertyName) {
        if (classNode == null || !StringUtils.hasText((String)propertyName)) {
            return false;
        }
        MethodNode method = classNode.getMethod(GrailsNameUtils.getGetterName((String)propertyName), Parameter.EMPTY_ARRAY);
        if (method != null) {
            return true;
        }
        if (classNode.getField(propertyName) != null && !classNode.getMethods(GrailsNameUtils.getSetterName((String)propertyName)).isEmpty()) {
            return true;
        }
        for (PropertyNode pn : classNode.getProperties()) {
            if (!pn.getName().equals(propertyName) || pn.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInheritsProperty(ClassNode classNode, String propertyName) {
        if (GrailsASTUtils.hasProperty(classNode, propertyName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals(OBJECT_CLASS); parent = parent.getSuperClass()) {
            if (!GrailsASTUtils.hasProperty(parent, propertyName)) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsZeroArgMethod(ClassNode classNode, String methodName) {
        MethodNode method = classNode.getDeclaredMethod(methodName, Parameter.EMPTY_ARRAY);
        return method != null && (method.isPublic() || method.isProtected()) && !method.isAbstract();
    }

    public static boolean implementsOrInheritsZeroArgMethod(ClassNode classNode, String methodName, List ignoreClasses) {
        if (GrailsASTUtils.implementsZeroArgMethod(classNode, methodName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals(OBJECT_CLASS); parent = parent.getSuperClass()) {
            if (ignoreClasses.contains(parent) || !GrailsASTUtils.implementsZeroArgMethod(parent, methodName)) continue;
            return true;
        }
        return false;
    }

    public static String getFullName(ClassNode classNode) {
        return classNode.getName();
    }

    public static ClassNode getFurthestParent(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals(OBJECT_CLASS); parent = parent.getSuperClass()) {
            classNode = parent;
        }
        return classNode;
    }

    public static ClassNode getFurthestUnresolvedParent(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals(OBJECT_CLASS) && !parent.isResolved(); parent = parent.getSuperClass()) {
            classNode = parent;
        }
        return classNode;
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, null, true);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, markerAnnotation, true);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, boolean thisAsFirstArgument) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, null, thisAsFirstArgument);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, boolean thisAsFirstArgument) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, markerAnnotation, thisAsFirstArgument, null, false);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, boolean thisAsFirstArgument, Map<String, ClassNode> genericsPlaceholders) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, markerAnnotation, thisAsFirstArgument, genericsPlaceholders, false);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, boolean thisAsFirstArgument, Map<String, ClassNode> genericsPlaceholders, boolean noNullCheck) {
        String propertyName;
        Parameter[] parameterTypes = thisAsFirstArgument ? GrailsASTUtils.getRemainingParameterTypes(declaredMethod.getParameters()) : declaredMethod.getParameters();
        String methodName = declaredMethod.getName();
        if (classNode.hasDeclaredMethod(methodName, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders))) {
            return null;
        }
        ClassNode returnType = declaredMethod.getReturnType();
        String string = propertyName = !returnType.isPrimaryClassNode() ? GrailsNameUtils.getPropertyForGetter((String)methodName, (Class)returnType.getTypeClass()) : GrailsNameUtils.getPropertyForGetter((String)methodName);
        if (propertyName != null && parameterTypes.length == 0 && classNode.hasProperty(propertyName)) {
            return null;
        }
        propertyName = GrailsNameUtils.getPropertyForSetter((String)methodName);
        if (propertyName != null && parameterTypes.length == 1 && classNode.hasProperty(propertyName)) {
            return null;
        }
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = GrailsASTUtils.createArgumentListFromParameters(parameterTypes, thisAsFirstArgument, genericsPlaceholders);
        returnType = GrailsASTUtils.replaceGenericsPlaceholders(returnType, genericsPlaceholders);
        MethodCallExpression methodCallExpression = new MethodCallExpression(delegate, methodName, (Expression)arguments);
        methodCallExpression.setMethodTarget(declaredMethod);
        if (!noNullCheck) {
            ThrowStatement missingMethodException = GrailsASTUtils.createMissingMethodThrowable(classNode, declaredMethod);
            VariableExpression apiVar = GrailsASTUtils.addApiVariableDeclaration(delegate, declaredMethod, methodBody);
            IfStatement ifStatement = GrailsASTUtils.createIfElseStatementForApiMethodCall(methodCallExpression, apiVar, missingMethodException);
            methodBody.addStatement((Statement)ifStatement);
        } else {
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)methodCallExpression));
        }
        MethodNode methodNode = new MethodNode(methodName, 1, returnType, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders), GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)methodBody);
        GrailsASTUtils.copyAnnotations((AnnotatedNode)declaredMethod, (AnnotatedNode)methodNode);
        if (GrailsASTUtils.shouldAddMarkerAnnotation(markerAnnotation, methodNode)) {
            methodNode.addAnnotation(markerAnnotation);
        }
        classNode.addMethod(methodNode);
        AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)methodNode);
        return methodNode;
    }

    private static boolean shouldAddMarkerAnnotation(AnnotationNode markerAnnotation, MethodNode methodNode) {
        return markerAnnotation != null && methodNode.getAnnotations(markerAnnotation.getClassNode()).isEmpty();
    }

    private static IfStatement createIfElseStatementForApiMethodCall(MethodCallExpression methodCallExpression, VariableExpression apiVar, ThrowStatement missingMethodException) {
        BlockStatement ifBlock = new BlockStatement();
        ifBlock.addStatement((Statement)missingMethodException);
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement((Statement)new ExpressionStatement((Expression)methodCallExpression));
        return new IfStatement(new BooleanExpression((Expression)new BinaryExpression((Expression)apiVar, EQUALS_OPERATOR, (Expression)NULL_EXPRESSION)), (Statement)ifBlock, (Statement)elseBlock);
    }

    private static VariableExpression addApiVariableDeclaration(Expression delegate, MethodNode declaredMethod, BlockStatement methodBody) {
        VariableExpression apiVar = new VariableExpression("$api_" + declaredMethod.getName(), delegate.getType());
        DeclarationExpression de = new DeclarationExpression(apiVar, ASSIGNMENT_OPERATOR, delegate);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)de));
        return apiVar;
    }

    private static ThrowStatement createMissingMethodThrowable(ClassNode classNode, MethodNode declaredMethodNode) {
        ArgumentListExpression exceptionArgs = new ArgumentListExpression();
        exceptionArgs.addExpression((Expression)new ConstantExpression((Object)declaredMethodNode.getName()));
        exceptionArgs.addExpression((Expression)new ClassExpression(classNode));
        return new ThrowStatement((Expression)new ConstructorCallExpression(MISSING_METHOD_EXCEPTION, (Expression)exceptionArgs));
    }

    public static ArgumentListExpression createArgumentListFromParameters(Parameter[] parameterTypes, boolean thisAsFirstArgument, Map<String, ClassNode> genericsPlaceholders) {
        ArgumentListExpression arguments = new ArgumentListExpression();
        if (thisAsFirstArgument) {
            arguments.addExpression((Expression)new VariableExpression("this"));
        }
        for (Parameter parameterType : parameterTypes) {
            arguments.addExpression((Expression)new VariableExpression(parameterType.getName(), GrailsASTUtils.replaceGenericsPlaceholders(parameterType.getType(), genericsPlaceholders)));
        }
        return arguments;
    }

    public static Parameter[] getRemainingParameterTypes(Parameter[] parameters) {
        if (parameters.length == 0) {
            return GrailsArtefactClassInjector.ZERO_PARAMETERS;
        }
        Parameter[] newParameters = new Parameter[parameters.length - 1];
        System.arraycopy(parameters, 1, newParameters, 0, parameters.length - 1);
        return newParameters;
    }

    public static MethodNode addDelegateStaticMethod(ClassNode classNode, MethodNode delegateMethod) {
        ClassExpression classExpression = new ClassExpression(delegateMethod.getDeclaringClass());
        return GrailsASTUtils.addDelegateStaticMethod((Expression)classExpression, classNode, delegateMethod);
    }

    public static MethodNode addDelegateStaticMethod(Expression expression, ClassNode classNode, MethodNode delegateMethod) {
        return GrailsASTUtils.addDelegateStaticMethod(expression, classNode, delegateMethod, null, null, true);
    }

    public static MethodNode addDelegateStaticMethod(Expression delegate, ClassNode classNode, MethodNode delegateMethod, AnnotationNode markerAnnotation, Map<String, ClassNode> genericsPlaceholders, boolean noNullCheck) {
        Parameter[] parameterTypes = delegateMethod.getParameters();
        String declaredMethodName = delegateMethod.getName();
        if (METHOD_MISSING_METHOD_NAME.equals(declaredMethodName)) {
            declaredMethodName = STATIC_METHOD_MISSING_METHOD_NAME;
        }
        if (classNode.hasDeclaredMethod(declaredMethodName, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders))) {
            return null;
        }
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = GrailsASTUtils.createArgumentListFromParameters(parameterTypes, false, genericsPlaceholders);
        MethodCallExpression methodCallExpression = new MethodCallExpression(delegate, delegateMethod.getName(), (Expression)arguments);
        methodCallExpression.setMethodTarget(delegateMethod);
        if (!noNullCheck && !(delegate instanceof ClassExpression)) {
            ThrowStatement missingMethodException = GrailsASTUtils.createMissingMethodThrowable(classNode, delegateMethod);
            VariableExpression apiVar = GrailsASTUtils.addApiVariableDeclaration(delegate, delegateMethod, methodBody);
            IfStatement ifStatement = GrailsASTUtils.createIfElseStatementForApiMethodCall(methodCallExpression, apiVar, missingMethodException);
            methodBody.addStatement((Statement)ifStatement);
        } else {
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)methodCallExpression));
        }
        ClassNode returnType = GrailsASTUtils.replaceGenericsPlaceholders(delegateMethod.getReturnType(), genericsPlaceholders);
        MethodNode methodNode = new MethodNode(declaredMethodName, 9, returnType, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders), GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)methodBody);
        GrailsASTUtils.copyAnnotations((AnnotatedNode)delegateMethod, (AnnotatedNode)methodNode);
        if (GrailsASTUtils.shouldAddMarkerAnnotation(markerAnnotation, methodNode)) {
            methodNode.addAnnotation(markerAnnotation);
        }
        classNode.addMethod(methodNode);
        return (MethodNode)AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)methodNode);
    }

    public static ConstructorNode addDelegateConstructor(ClassNode classNode, MethodNode constructorMethod, Map<String, ClassNode> genericsPlaceholders) {
        BlockStatement constructorBody = new BlockStatement();
        Parameter[] constructorParams = GrailsASTUtils.getRemainingParameterTypes(constructorMethod.getParameters());
        ArgumentListExpression arguments = GrailsASTUtils.createArgumentListFromParameters(constructorParams, true, genericsPlaceholders);
        MethodCallExpression constructCallExpression = new MethodCallExpression((Expression)new ClassExpression(constructorMethod.getDeclaringClass()), "initialize", (Expression)arguments);
        constructCallExpression.setMethodTarget(constructorMethod);
        ExpressionStatement constructorInitExpression = new ExpressionStatement((Expression)constructCallExpression);
        if (constructorParams.length > 0) {
            constructorBody.addStatement((Statement)new ExpressionStatement((Expression)new ConstructorCallExpression(ClassNode.THIS, (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
        }
        constructorBody.addStatement((Statement)constructorInitExpression);
        if (constructorParams.length == 0) {
            ConstructorNode constructorNode = GrailsASTUtils.getDefaultConstructor(classNode);
            if (constructorNode != null) {
                List annotations = constructorNode.getAnnotations(new ClassNode(GrailsDelegatingConstructor.class));
                if (annotations.size() == 0) {
                    Statement existingBodyCode = constructorNode.getCode();
                    if (existingBodyCode instanceof BlockStatement) {
                        ((BlockStatement)existingBodyCode).addStatement((Statement)constructorInitExpression);
                    } else {
                        constructorNode.setCode((Statement)constructorBody);
                    }
                }
            } else {
                constructorNode = new ConstructorNode(1, (Statement)constructorBody);
                classNode.addConstructor(constructorNode);
                AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)constructorNode);
            }
            constructorNode.addAnnotation(new AnnotationNode(new ClassNode(GrailsDelegatingConstructor.class)));
            return constructorNode;
        }
        ConstructorNode cn = GrailsASTUtils.findConstructor(classNode, constructorParams);
        if (cn == null) {
            cn = new ConstructorNode(1, GrailsASTUtils.copyParameters(constructorParams, genericsPlaceholders), null, (Statement)constructorBody);
            classNode.addConstructor(cn);
            AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)cn);
        } else {
            List annotations = cn.getAnnotations(new ClassNode(GrailsDelegatingConstructor.class));
            if (annotations.size() == 0) {
                Statement code = cn.getCode();
                constructorBody.addStatement(code);
                cn.setCode((Statement)constructorBody);
            }
        }
        ConstructorNode defaultConstructor = GrailsASTUtils.getDefaultConstructor(classNode);
        if (defaultConstructor == null) {
            ConstructorNode constructorNode = new ConstructorNode(1, (Statement)new BlockStatement());
            classNode.addConstructor(constructorNode);
            AnnotatedNodeUtils.markAsGenerated((ClassNode)classNode, (AnnotatedNode)constructorNode);
        }
        cn.addAnnotation(new AnnotationNode(new ClassNode(GrailsDelegatingConstructor.class)));
        return cn;
    }

    public static ConstructorNode findConstructor(ClassNode classNode, Parameter[] constructorParams) {
        List declaredConstructors = classNode.getDeclaredConstructors();
        for (ConstructorNode declaredConstructor : declaredConstructors) {
            if (!GrailsASTUtils.parametersEqual(constructorParams, declaredConstructor.getParameters())) continue;
            return declaredConstructor;
        }
        return null;
    }

    public static boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getType().equals((Object)b[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static ConstructorNode getDefaultConstructor(ClassNode classNode) {
        for (ConstructorNode cons : classNode.getDeclaredConstructors()) {
            if (cons.getParameters().length != 0) continue;
            return cons;
        }
        return null;
    }

    public static Parameter[] copyParameters(Parameter[] parameterTypes) {
        return GrailsASTUtils.copyParameters(parameterTypes, null);
    }

    public static Parameter[] copyParameters(Parameter[] parameterTypes, Map<String, ClassNode> genericsPlaceholders) {
        Parameter[] newParameterTypes = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameterType = parameterTypes[i];
            Parameter newParameter = new Parameter(GrailsASTUtils.replaceGenericsPlaceholders(parameterType.getType(), genericsPlaceholders), parameterType.getName(), parameterType.getInitialExpression());
            GrailsASTUtils.copyAnnotations((AnnotatedNode)parameterType, (AnnotatedNode)newParameter);
            newParameterTypes[i] = newParameter;
        }
        return newParameterTypes;
    }

    public static ClassNode nonGeneric(ClassNode type) {
        return GrailsASTUtils.replaceGenericsPlaceholders(type, emptyGenericsPlaceHoldersMap);
    }

    public static ClassNode nonGeneric(ClassNode type, ClassNode wildcardReplacement) {
        return GrailsASTUtils.replaceGenericsPlaceholders(type, emptyGenericsPlaceHoldersMap, wildcardReplacement);
    }

    public static ClassNode replaceGenericsPlaceholders(ClassNode type, Map<String, ClassNode> genericsPlaceholders) {
        return GrailsASTUtils.replaceGenericsPlaceholders(type, genericsPlaceholders, null);
    }

    public static ClassNode replaceGenericsPlaceholders(ClassNode type, Map<String, ClassNode> genericsPlaceholders, ClassNode defaultPlaceholder) {
        GenericsType[] parameterized;
        if (type.isArray()) {
            return GrailsASTUtils.replaceGenericsPlaceholders(type.getComponentType(), genericsPlaceholders).makeArray();
        }
        if (!type.isUsingGenerics() && !type.isRedirectNode()) {
            return type.getPlainNodeReference();
        }
        if (type.isGenericsPlaceHolder() && genericsPlaceholders != null) {
            ClassNode placeHolderType = genericsPlaceholders.containsKey(type.getUnresolvedName()) ? genericsPlaceholders.get(type.getUnresolvedName()) : defaultPlaceholder;
            if (placeHolderType != null) {
                return placeHolderType.getPlainNodeReference();
            }
            return ClassHelper.make(Object.class).getPlainNodeReference();
        }
        ClassNode nonGen = type.getPlainNodeReference();
        if (OBJECT_CLASS.equals(type.getName())) {
            nonGen.setGenericsPlaceHolder(false);
            nonGen.setGenericsTypes(null);
            nonGen.setUsingGenerics(false);
        } else if (type.isUsingGenerics() && (parameterized = type.getGenericsTypes()) != null && parameterized.length > 0) {
            GenericsType[] copiedGenericsTypes = new GenericsType[parameterized.length];
            for (int i = 0; i < parameterized.length; ++i) {
                ClassNode placeHolderType;
                GenericsType parameterizedType = parameterized[i];
                GenericsType copiedGenericsType = null;
                copiedGenericsType = parameterizedType.isPlaceholder() && genericsPlaceholders != null ? ((placeHolderType = genericsPlaceholders.get(parameterizedType.getName())) != null ? new GenericsType(placeHolderType.getPlainNodeReference()) : new GenericsType(ClassHelper.make(Object.class).getPlainNodeReference())) : new GenericsType(GrailsASTUtils.replaceGenericsPlaceholders(parameterizedType.getType(), genericsPlaceholders));
                copiedGenericsTypes[i] = copiedGenericsType;
            }
            nonGen.setGenericsTypes(copiedGenericsTypes);
        }
        return nonGen;
    }

    public static boolean isCandidateInstanceMethod(ClassNode classNode, MethodNode declaredMethod) {
        Parameter[] parameterTypes = declaredMethod.getParameters();
        return GrailsASTUtils.isCandidateMethod(declaredMethod) && parameterTypes != null && parameterTypes.length > 0 && GrailsASTUtils.isAssignableFrom(parameterTypes[0].getType(), classNode);
    }

    public static boolean isAssignableFrom(ClassNode superClass, ClassNode childClass) {
        for (ClassNode currentSuper = childClass; currentSuper != null; currentSuper = currentSuper.getSuperClass()) {
            if (!currentSuper.equals((Object)superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclassOfOrImplementsInterface(ClassNode childClass, ClassNode superClass) {
        String superClassName = superClass.getName();
        return GrailsASTUtils.isSubclassOfOrImplementsInterface(childClass, superClassName);
    }

    public static boolean isSubclassOfOrImplementsInterface(ClassNode childClass, String superClassName) {
        return GrailsASTUtils.isSubclassOf(childClass, superClassName) || GrailsASTUtils.implementsInterface(childClass, superClassName);
    }

    private static boolean implementsInterface(ClassNode classNode, String interfaceName) {
        for (ClassNode currentClassNode = classNode; currentClassNode != null && !currentClassNode.getName().equals(OBJECT_CLASS); currentClassNode = currentClassNode.getSuperClass()) {
            ClassNode[] interfaces = currentClassNode.getInterfaces();
            if (!GrailsASTUtils.implementsInterfaceInternal(interfaces, interfaceName)) continue;
            return true;
        }
        return false;
    }

    private static boolean implementsInterfaceInternal(ClassNode[] interfaces, String interfaceName) {
        for (ClassNode anInterface : interfaces) {
            if (anInterface.getName().equals(interfaceName)) {
                return true;
            }
            ClassNode[] childInterfaces = anInterface.getInterfaces();
            if (childInterfaces == null || childInterfaces.length <= 0) continue;
            return GrailsASTUtils.implementsInterfaceInternal(childInterfaces, interfaceName);
        }
        return false;
    }

    public static boolean isCandidateMethod(MethodNode declaredMethod) {
        return !declaredMethod.isSynthetic() && !declaredMethod.getName().contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !Modifier.isAbstract(declaredMethod.getModifiers());
    }

    public static boolean isConstructorMethod(MethodNode declaredMethod) {
        return declaredMethod.isStatic() && declaredMethod.isPublic() && declaredMethod.getName().equals("initialize") && declaredMethod.getParameters().length >= 1 && declaredMethod.getParameters()[0].getType().equals((Object)AbstractGrailsArtefactTransformer.OBJECT_CLASS);
    }

    public static boolean isDomainClass(ClassNode classNode, SourceUnit sourceNode) {
        String grailsAppDirToLookFor;
        String sourcePath;
        int indexOfGrailsAppDir;
        boolean isDomainClass = GrailsASTUtils.hasAnyAnnotations(classNode, Entity.class, jakarta.persistence.Entity.class);
        if (!isDomainClass && sourceNode != null && (indexOfGrailsAppDir = (sourcePath = sourceNode.getName()).lastIndexOf(grailsAppDirToLookFor = File.separator + GRAILS_APP_DIR + File.separator)) >= 0) {
            String pathToGrailsAppDir = sourcePath.substring(0, indexOfGrailsAppDir + grailsAppDirToLookFor.length());
            String pathToDomainDir = pathToGrailsAppDir + DOMAIN_DIR + File.separator;
            String className = classNode.getName();
            String relativePathToDomainSourceFile = className.replace('.', File.separatorChar) + ".groovy";
            String pathToDomainSourceFile = pathToDomainDir + relativePathToDomainSourceFile;
            isDomainClass = new File(pathToDomainSourceFile).exists();
        }
        return isDomainClass;
    }

    public static void addDelegateInstanceMethods(ClassNode classNode, ClassNode delegateNode, Expression delegateInstance) {
        GrailsASTUtils.addDelegateInstanceMethods(classNode, delegateNode, delegateInstance, null);
    }

    public static void addDelegateInstanceMethods(ClassNode classNode, ClassNode delegateNode, Expression delegateInstance, Map<String, ClassNode> genericsPlaceholders) {
        GrailsASTUtils.addDelegateInstanceMethods(classNode, classNode, delegateNode, delegateInstance, genericsPlaceholders, false, false);
    }

    public static void addDelegateInstanceMethods(ClassNode supportedSuperType, ClassNode classNode, ClassNode delegateNode, Expression delegateInstance) {
        GrailsASTUtils.addDelegateInstanceMethods(supportedSuperType, classNode, delegateNode, delegateInstance, null, false, false);
    }

    public static void addDelegateInstanceMethods(ClassNode supportedSuperType, ClassNode classNode, ClassNode delegateNode, Expression delegateInstance, Map<String, ClassNode> genericsPlaceholders, boolean noNullCheck, boolean addCompileStatic) {
        while (!delegateNode.equals((Object)AbstractGrailsArtefactTransformer.OBJECT_CLASS)) {
            List declaredMethods = delegateNode.getMethods();
            for (MethodNode declaredMethod : declaredMethods) {
                if (GrailsASTUtils.isConstructorMethod(declaredMethod)) {
                    GrailsASTUtils.addDelegateConstructor(classNode, declaredMethod, genericsPlaceholders);
                    continue;
                }
                if (!GrailsASTUtils.isCandidateInstanceMethod(supportedSuperType, declaredMethod)) continue;
                MethodNode methodNode = GrailsASTUtils.addDelegateInstanceMethod(classNode, delegateInstance, declaredMethod, null, true, genericsPlaceholders, noNullCheck);
                if (!addCompileStatic) continue;
                GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)methodNode);
            }
            delegateNode = delegateNode.getSuperClass();
        }
    }

    public static FieldNode addFieldIfNonExistent(ClassNode classNode, ClassNode fieldType, String fieldName) {
        if (classNode != null && classNode.getField(fieldName) == null) {
            return classNode.addField(fieldName, 2, fieldType, (Expression)new ConstructorCallExpression(fieldType, (Expression)new ArgumentListExpression()));
        }
        return null;
    }

    public static void addExpressionToAnnotationMember(AnnotationNode annotationNode, String memberName, Expression expression) {
        Expression exclude = annotationNode.getMember(memberName);
        if (exclude instanceof ListExpression) {
            ((ListExpression)exclude).addExpression(expression);
        } else if (exclude != null) {
            ListExpression list = new ListExpression();
            list.addExpression(exclude);
            list.addExpression(expression);
            annotationNode.setMember(memberName, (Expression)list);
        } else {
            annotationNode.setMember(memberName, expression);
        }
    }

    public static void addAnnotationIfNecessary(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        GrailsASTUtils.addAnnotationOrGetExisting(classNode, annotationClass);
    }

    public static AnnotationNode addAnnotationOrGetExisting(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return GrailsASTUtils.addAnnotationOrGetExisting(classNode, annotationClass, Collections.emptyMap());
    }

    public static AnnotationNode addAnnotationOrGetExisting(ClassNode classNode, Class<? extends Annotation> annotationClass, Map<String, Object> members) {
        ClassNode annotationClassNode = ClassHelper.make(annotationClass);
        return GrailsASTUtils.addAnnotationOrGetExisting(classNode, annotationClassNode, members);
    }

    public static AnnotationNode addAnnotationOrGetExisting(ClassNode classNode, ClassNode annotationClassNode) {
        return GrailsASTUtils.addAnnotationOrGetExisting(classNode, annotationClassNode, Collections.emptyMap());
    }

    public static AnnotationNode addAnnotationOrGetExisting(ClassNode classNode, ClassNode annotationClassNode, Map<String, Object> members) {
        List annotations = classNode.getAnnotations();
        AnnotationNode annotationToAdd = new AnnotationNode(annotationClassNode);
        if (annotations.isEmpty()) {
            classNode.addAnnotation(annotationToAdd);
        } else {
            AnnotationNode existing = GrailsASTUtils.findAnnotation(annotationClassNode, annotations);
            if (existing != null) {
                annotationToAdd = existing;
            } else {
                classNode.addAnnotation(annotationToAdd);
            }
        }
        if (members != null && !members.isEmpty()) {
            Iterator<Map.Entry<String, Object>> iterator = members.entrySet().iterator();
            while (iterator.hasNext()) {
                Object value;
                Map.Entry<String, Object> memberEntry;
                annotationToAdd.setMember(memberEntry.getKey(), (Expression)((value = (memberEntry = iterator.next()).getValue()) instanceof Expression ? (Expression)value : new ConstantExpression(value)));
            }
        }
        return annotationToAdd;
    }

    public static AnnotationNode addEnhancedAnnotation(ClassNode classNode, String ... enhancedFor) {
        AnnotationNode enhancedAnnotationNode;
        List annotations = classNode.getAnnotations(ENHANCED_CLASS_NODE);
        if (annotations.isEmpty()) {
            enhancedAnnotationNode = new AnnotationNode(ENHANCED_CLASS_NODE);
            String grailsVersion = GrailsASTUtils.getGrailsVersion();
            if (grailsVersion == null) {
                grailsVersion = System.getProperty("grails.version");
            }
            if (grailsVersion != null) {
                enhancedAnnotationNode.setMember("version", (Expression)new ConstantExpression((Object)grailsVersion));
            }
            classNode.addAnnotation(enhancedAnnotationNode);
        } else {
            enhancedAnnotationNode = (AnnotationNode)annotations.get(0);
        }
        if (enhancedFor != null && enhancedFor.length > 0) {
            ListExpression enhancedForArray = (ListExpression)enhancedAnnotationNode.getMember("enhancedFor");
            if (enhancedForArray == null) {
                enhancedForArray = new ListExpression();
                enhancedAnnotationNode.setMember("enhancedFor", (Expression)enhancedForArray);
            }
            List featureNameExpressions = enhancedForArray.getExpressions();
            for (String feature : enhancedFor) {
                boolean exists = false;
                for (Expression expression : featureNameExpressions) {
                    if (!(expression instanceof ConstantExpression) || !feature.equals(((ConstantExpression)expression).getValue())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                featureNameExpressions.add(new ConstantExpression((Object)feature));
            }
        }
        return enhancedAnnotationNode;
    }

    private static String getGrailsVersion() {
        return GrailsASTUtils.class.getPackage().getImplementationVersion();
    }

    public static AnnotationNode findAnnotation(ClassNode annotationClassNode, List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            if (!annotation.getClassNode().equals((Object)annotationClassNode)) continue;
            return annotation;
        }
        return null;
    }

    public static AnnotationNode findAnnotation(ClassNode classNode, Class<?> type) {
        List annotations = classNode.getAnnotations();
        return annotations == null ? null : GrailsASTUtils.findAnnotation(new ClassNode(type), annotations);
    }

    public static boolean hasAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return !classNode.getAnnotations(new ClassNode(annotationClass)).isEmpty();
    }

    public static boolean hasAnnotation(MethodNode methodNode, Class<? extends Annotation> annotationClass) {
        return !methodNode.getAnnotations(new ClassNode(annotationClass)).isEmpty();
    }

    public static boolean hasAnyAnnotations(ClassNode classNode, Class<? extends Annotation> ... annotationsToLookFor) {
        for (Class<? extends Annotation> annotationClass : annotationsToLookFor) {
            if (!GrailsASTUtils.hasAnnotation(classNode, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean removeAnnotation(MethodNode methodNode, Class<? extends Annotation> annotationClass) {
        List annotations = methodNode.getAnnotations(new ClassNode(annotationClass));
        if (annotations.size() > 0) {
            methodNode.getAnnotations().removeAll(annotations);
            return true;
        }
        return false;
    }

    public static void addMethodIfNotPresent(ClassNode controllerClassNode, MethodNode methodNode) {
        MethodNode existing = controllerClassNode.getMethod(methodNode.getName(), methodNode.getParameters());
        if (existing == null) {
            controllerClassNode.addMethod(methodNode);
            AnnotatedNodeUtils.markAsGenerated((ClassNode)controllerClassNode, (AnnotatedNode)methodNode);
        }
    }

    public static ExpressionStatement createPrintlnStatement(String message) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "println", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)message))));
    }

    public static ExpressionStatement createPrintlnStatement(String message, String variable) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "println", (Expression)new ArgumentListExpression((Expression)new BinaryExpression((Expression)new ConstantExpression((Object)message), Token.newSymbol((int)200, (int)0, (int)0), (Expression)new VariableExpression(variable)))));
    }

    public static void wrapMethodBodyInTryCatchDebugStatements(MethodNode methodNode) {
        BlockStatement code = (BlockStatement)methodNode.getCode();
        BlockStatement newCode = new BlockStatement();
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)code, (Statement)new BlockStatement());
        newCode.addStatement((Statement)tryCatchStatement);
        methodNode.setCode((Statement)newCode);
        BlockStatement catchBlock = new BlockStatement();
        ArgumentListExpression logArguments = new ArgumentListExpression();
        logArguments.addExpression((Expression)new BinaryExpression((Expression)new ConstantExpression((Object)"Error initializing class: "), Token.newSymbol((int)200, (int)0, (int)0), (Expression)new VariableExpression("e")));
        logArguments.addExpression((Expression)new VariableExpression("e"));
        catchBlock.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("log"), "error", (Expression)logArguments)));
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), "e"), (Statement)catchBlock));
    }

    public static Map<String, Map<String, Expression>> getConstraintMetadata(ClosureExpression closureExpression) {
        ArrayList<MethodCallExpression> methodExpressions = new ArrayList<MethodCallExpression>();
        LinkedHashMap<String, Map<String, Expression>> results = new LinkedHashMap<String, Map<String, Expression>>();
        Statement closureCode = closureExpression.getCode();
        if (closureCode instanceof BlockStatement) {
            List closureStatements = ((BlockStatement)closureCode).getStatements();
            for (Statement closureStatement : closureStatements) {
                ReturnStatement returnStatement;
                Expression expression;
                if (closureStatement instanceof ExpressionStatement) {
                    Expression expression2 = ((ExpressionStatement)closureStatement).getExpression();
                    if (expression2 instanceof MethodCallExpression) {
                        methodExpressions.add((MethodCallExpression)expression2);
                    }
                } else if (closureStatement instanceof ReturnStatement && (expression = (returnStatement = (ReturnStatement)closureStatement).getExpression()) instanceof MethodCallExpression) {
                    methodExpressions.add((MethodCallExpression)expression);
                }
                for (MethodCallExpression methodCallExpression : methodExpressions) {
                    List methodCallArgumentExpressions;
                    Expression methodCallArguments;
                    Expression objectExpression = methodCallExpression.getObjectExpression();
                    if (!(objectExpression instanceof VariableExpression) || !"this".equals(((VariableExpression)objectExpression).getName()) || !((methodCallArguments = methodCallExpression.getArguments()) instanceof TupleExpression) || (methodCallArgumentExpressions = ((TupleExpression)methodCallArguments).getExpressions()) == null || methodCallArgumentExpressions.size() != 1 || !(methodCallArgumentExpressions.get(0) instanceof NamedArgumentListExpression)) continue;
                    LinkedHashMap<String, Expression> constraintNameToExpression = new LinkedHashMap<String, Expression>();
                    List mapEntryExpressions = ((NamedArgumentListExpression)methodCallArgumentExpressions.get(0)).getMapEntryExpressions();
                    for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                        Object value;
                        Expression keyExpression = mapEntryExpression.getKeyExpression();
                        if (!(keyExpression instanceof ConstantExpression) || !((value = ((ConstantExpression)keyExpression).getValue()) instanceof String)) continue;
                        constraintNameToExpression.put((String)value, mapEntryExpression.getValueExpression());
                    }
                    results.put(methodCallExpression.getMethodAsString(), constraintNameToExpression);
                }
            }
        }
        return results;
    }

    public static Map<String, ClassNode> getAssocationMap(ClassNode classNode, String associationType) {
        Expression e;
        PropertyNode property = classNode.getProperty(associationType);
        HashMap<String, ClassNode> associationMap = new HashMap<String, ClassNode>();
        if (property != null && property.isStatic() && (e = property.getInitialExpression()) instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            for (MapEntryExpression mee : me.getMapEntryExpressions()) {
                String key = mee.getKeyExpression().getText();
                Expression valueExpression = mee.getValueExpression();
                if (!(valueExpression instanceof ClassExpression)) continue;
                associationMap.put(key, valueExpression.getType());
            }
        }
        return associationMap;
    }

    public static Map<String, ClassNode> getAllAssociationMap(ClassNode classNode) {
        HashMap<String, ClassNode> associationMap = new HashMap<String, ClassNode>();
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "hasMany"));
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "hasOne"));
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "belongsTo"));
        return associationMap;
    }

    public static ClassNode findInterface(ClassNode classNode, ClassNode interfaceNode) {
        while (!classNode.equals((Object)OBJECT_CLASS_NODE)) {
            Set interfaces = classNode.getAllInterfaces();
            for (ClassNode anInterface : interfaces) {
                if (!anInterface.equals((Object)interfaceNode)) continue;
                return anInterface;
            }
            classNode = classNode.getSuperClass();
        }
        return null;
    }

    public static boolean hasZeroArgsConstructor(ClassNode implementationNode) {
        List constructors = implementationNode.getDeclaredConstructors();
        if (constructors.isEmpty()) {
            return true;
        }
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isInnerClassNode(ClassNode classNode) {
        return classNode instanceof InnerClassNode || classNode.getName().contains("$");
    }

    public static boolean isSubclassOf(ClassNode classNode, String parentClassName) {
        for (ClassNode currentSuper = classNode.getSuperClass(); currentSuper != null && !currentSuper.getName().equals(OBJECT_CLASS); currentSuper = currentSuper.getSuperClass()) {
            if (!currentSuper.getName().equals(parentClassName)) continue;
            return true;
        }
        return false;
    }

    public static AnnotatedNode addCompileStaticAnnotation(AnnotatedNode annotatedNode) {
        return GrailsASTUtils.addCompileStaticAnnotation(annotatedNode, false);
    }

    public static AnnotatedNode addCompileStaticAnnotation(AnnotatedNode annotatedNode, boolean skip) {
        if (annotatedNode != null) {
            AnnotationNode an = new AnnotationNode(COMPILESTATIC_CLASS_NODE);
            if (skip) {
                an.addMember("value", (Expression)new PropertyExpression((Expression)new ClassExpression(TYPECHECKINGMODE_CLASS_NODE), "SKIP"));
            }
            annotatedNode.addAnnotation(an);
            if (!skip) {
                annotatedNode.getDeclaringClass().addTransform(StaticCompileTransformation.class, (ASTNode)an);
            }
        }
        return annotatedNode;
    }

    public static MethodCallExpression applyDefaultMethodTarget(MethodCallExpression methodCallExpression, ClassNode targetClassNode) {
        return GrailsASTUtils.applyMethodTarget(methodCallExpression, targetClassNode, (ClassNode[])null);
    }

    public static MethodCallExpression applyDefaultMethodTarget(MethodCallExpression methodCallExpression, Class<?> targetClass) {
        return GrailsASTUtils.applyDefaultMethodTarget(methodCallExpression, ClassHelper.make(targetClass).getPlainNodeReference());
    }

    public static MethodCallExpression applyMethodTarget(MethodCallExpression methodCallExpression, ClassNode targetClassNode, ClassNode ... targetParameterTypes) {
        String methodName = methodCallExpression.getMethodAsString();
        if (methodName == null) {
            return methodCallExpression;
        }
        int argumentCount = methodCallExpression.getArguments() != null ? ((TupleExpression)methodCallExpression.getArguments()).getExpressions().size() : 0;
        String methodFoundInClass = null;
        for (MethodNode method : targetClassNode.getMethods(methodName)) {
            int methodParameterCount = method.getParameters() != null ? method.getParameters().length : 0;
            if (methodParameterCount != argumentCount || targetParameterTypes != null && !GrailsASTUtils.parameterTypesMatch(method.getParameters(), targetParameterTypes)) continue;
            String methodFromClass = method.getDeclaringClass().getName();
            if (methodFoundInClass == null) {
                methodCallExpression.setMethodTarget(method);
                methodFoundInClass = methodFromClass;
                continue;
            }
            if (!methodFromClass.equals(methodFoundInClass)) continue;
            throw new RuntimeException("Multiple methods with same name '" + methodName + "' and argument count (" + argumentCount + ") in " + targetClassNode.getName() + ". Cannot apply default method target.");
        }
        return methodCallExpression;
    }

    public static MethodCallExpression applyMethodTarget(MethodCallExpression methodCallExpression, Class<?> targetClass, Class<?> ... targetParameterClassTypes) {
        return GrailsASTUtils.applyMethodTarget(methodCallExpression, ClassHelper.make(targetClass).getPlainNodeReference(), GrailsASTUtils.convertTargetParameterTypes(targetParameterClassTypes));
    }

    public static MethodCallExpression applyMethodTarget(MethodCallExpression methodCallExpression, ClassNode targetClassNode, Class<?> ... targetParameterClassTypes) {
        return GrailsASTUtils.applyMethodTarget(methodCallExpression, targetClassNode, GrailsASTUtils.convertTargetParameterTypes(targetParameterClassTypes));
    }

    private static ClassNode[] convertTargetParameterTypes(Class<?>[] targetParameterClassTypes) {
        ClassNode[] targetParameterTypes = null;
        if (targetParameterClassTypes != null) {
            targetParameterTypes = new ClassNode[targetParameterClassTypes.length];
            for (int i = 0; i < targetParameterClassTypes.length; ++i) {
                targetParameterTypes[i] = targetParameterClassTypes[i] != null ? ClassHelper.make(targetParameterClassTypes[i]).getPlainNodeReference() : null;
            }
        }
        return targetParameterTypes;
    }

    private static boolean parameterTypesMatch(Parameter[] parameters, ClassNode[] targetParameterTypes) {
        if (targetParameterTypes == null || targetParameterTypes.length == 0) {
            return true;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (targetParameterTypes.length <= i || targetParameterTypes[i] == null || parameters[i].getType().getName().equals(targetParameterTypes[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static MethodCallExpression buildGetPropertyExpression(Expression objectExpression, String propertyName, ClassNode targetClassNode) {
        return GrailsASTUtils.buildGetPropertyExpression(objectExpression, propertyName, targetClassNode, false);
    }

    public static MethodCallExpression buildGetPropertyExpression(Expression objectExpression, String propertyName, ClassNode targetClassNode, boolean useBooleanGetter) {
        String methodName = (useBooleanGetter ? "is" : "get") + MetaClassHelper.capitalize((String)propertyName);
        MethodCallExpression methodCallExpression = new MethodCallExpression(objectExpression, methodName, MethodCallExpression.NO_ARGUMENTS);
        MethodNode getterMethod = targetClassNode.getGetterMethod(methodName);
        if (getterMethod != null) {
            methodCallExpression.setMethodTarget(getterMethod);
        }
        return methodCallExpression;
    }

    public static MethodCallExpression buildSetPropertyExpression(Expression objectExpression, String propertyName, ClassNode targetClassNode, Expression valueExpression) {
        String methodName = "set" + MetaClassHelper.capitalize((String)propertyName);
        MethodCallExpression methodCallExpression = new MethodCallExpression(objectExpression, methodName, (Expression)new ArgumentListExpression(valueExpression));
        MethodNode setterMethod = targetClassNode.getSetterMethod(methodName);
        if (setterMethod != null) {
            methodCallExpression.setMethodTarget(setterMethod);
        }
        return methodCallExpression;
    }

    public static MethodCallExpression buildPutMapExpression(Expression objectExpression, String keyName, Expression valueExpression) {
        return GrailsASTUtils.applyDefaultMethodTarget(new MethodCallExpression(objectExpression, "put", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)keyName), valueExpression)), Map.class);
    }

    public static MethodCallExpression buildGetMapExpression(Expression objectExpression, String keyName) {
        return GrailsASTUtils.applyDefaultMethodTarget(new MethodCallExpression(objectExpression, "get", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)keyName))), Map.class);
    }

    public static Expression buildGetThisObjectExpression(boolean inClosureBlock) {
        if (!inClosureBlock) {
            return GrailsASTUtils.buildThisExpression();
        }
        return GrailsASTUtils.buildGetPropertyExpression(GrailsASTUtils.buildThisExpression(), "thisObject", ClassHelper.make(Closure.class).getPlainNodeReference());
    }

    public static Expression buildThisExpression() {
        return new VariableExpression("this");
    }

    public static MethodCallExpression noImplicitThis(MethodCallExpression methodCallExpression) {
        return GrailsASTUtils.applyImplicitThis(methodCallExpression, false);
    }

    public static MethodCallExpression applyImplicitThis(MethodCallExpression methodCallExpression, boolean useImplicitThis) {
        methodCallExpression.setImplicitThis(useImplicitThis);
        return methodCallExpression;
    }

    public static void copyAnnotations(AnnotatedNode from, AnnotatedNode to) {
        GrailsASTUtils.copyAnnotations(from, to, null, null);
    }

    public static void copyAnnotations(AnnotatedNode from, AnnotatedNode to, Set<String> included, Set<String> excluded) {
        List annotationsToCopy = from.getAnnotations();
        for (AnnotationNode node : annotationsToCopy) {
            String annotationClassName = node.getClassNode().getName();
            if (excluded != null && excluded.contains(annotationClassName) || included != null && !included.contains(annotationClassName)) continue;
            AnnotationNode copyOfAnnotationNode = GrailsASTUtils.cloneAnnotation(node);
            to.addAnnotation(copyOfAnnotationNode);
        }
    }

    public static AnnotationNode cloneAnnotation(AnnotationNode node) {
        AnnotationNode copyOfAnnotationNode = new AnnotationNode(node.getClassNode());
        Map members = node.getMembers();
        for (Map.Entry entry : members.entrySet()) {
            copyOfAnnotationNode.addMember((String)entry.getKey(), (Expression)entry.getValue());
        }
        return copyOfAnnotationNode;
    }

    public static void filterAnnotations(AnnotatedNode annotatedNode, Set<String> classNamesToRetain, Set<String> classNamesToRemove) {
        Iterator iterator = annotatedNode.getAnnotations().iterator();
        while (iterator.hasNext()) {
            AnnotationNode node = (AnnotationNode)iterator.next();
            String annotationClassName = node.getClassNode().getName();
            if (classNamesToRemove != null && !classNamesToRemove.contains(annotationClassName) || classNamesToRetain != null && classNamesToRetain.contains(annotationClassName)) continue;
            iterator.remove();
        }
    }

    public static void removeCompileStaticAnnotations(AnnotatedNode annotatedNode) {
        GrailsASTUtils.filterAnnotations(annotatedNode, null, new HashSet<String>(Arrays.asList(CompileStatic.class.getName(), TypeChecked.class.getName())));
    }

    public static void markApplied(ASTNode astNode, Class<?> transformationClass) {
        GrailsASTUtils.resolveRedirect(astNode).setNodeMetaData((Object)GrailsASTUtils.appliedTransformationKey(transformationClass), (Object)Boolean.TRUE);
    }

    private static ASTNode resolveRedirect(ASTNode astNode) {
        if (astNode instanceof ClassNode) {
            astNode = ((ClassNode)astNode).redirect();
        }
        return astNode;
    }

    private static String appliedTransformationKey(Class<?> transformationClass) {
        return "APPLIED_" + transformationClass.getName();
    }

    public static boolean isApplied(ASTNode astNode, Class<?> transformationClass) {
        return GrailsASTUtils.resolveRedirect(astNode).getNodeMetaData((Object)GrailsASTUtils.appliedTransformationKey(transformationClass)) == Boolean.TRUE;
    }

    public static void processVariableScopes(SourceUnit source, ClassNode classNode) {
        GrailsASTUtils.processVariableScopes(source, classNode, null);
    }

    public static void processVariableScopes(SourceUnit source, ClassNode classNode, MethodNode methodNode) {
        VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(source);
        if (methodNode == null) {
            scopeVisitor.visitClass(classNode);
        } else {
            scopeVisitor.prepareVisit(classNode);
            scopeVisitor.visitMethod(methodNode);
        }
    }

    public static boolean isGetterMethod(MethodNode md) {
        String methodName = md.getName();
        return (methodName.startsWith("get") && methodName.length() > 3 || methodName.startsWith("is") && methodName.length() > 2) && (md.getParameters() == null || md.getParameters().length == 0);
    }

    public static boolean isSetterMethod(MethodNode md) {
        String methodName = md.getName();
        return methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.substring(3).charAt(0)) && md.getParameters() != null && md.getParameters().length == 1;
    }

    public static boolean isSetterOrGetterMethod(MethodNode md) {
        return GrailsASTUtils.isGetterMethod(md) || GrailsASTUtils.isSetterMethod(md);
    }

    public static URL getSourceUrl(SourceUnit source) {
        URL url = null;
        String filename = source.getName();
        if (filename == null) {
            return null;
        }
        FileSystemResource resource = new FileSystemResource(filename);
        if (resource.exists()) {
            try {
                url = resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL getSourceUrl(ClassNode classNode) {
        return GrailsASTUtils.getSourceUrl(classNode.getModule().getContext());
    }

    public static boolean hasParameters(MethodNode methodNode) {
        return methodNode.getParameters().length > 0;
    }

    public static boolean isInheritedFromTrait(MethodNode methodNode) {
        return GrailsASTUtils.hasAnnotation(methodNode, Traits.TraitBridge.class);
    }

    @Target(value={ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface GrailsDelegatingConstructor {
    }
}

