/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.util;

import java.beans.PropertyDescriptor;
import org.grails.core.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class BeanCreationProfilingPostProcessor
implements InstantiationAwareBeanPostProcessor,
ApplicationListener<ContextRefreshedEvent> {
    private final StopWatch stopWatch = new StopWatch("Bean Creation StopWatch");
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.grails.startup");

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        this.stopWatch.start("Create Bean: " + beanName);
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.stopWatch.stop();
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.stopWatch.complete();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.stopWatch.prettyPrint());
        }
    }
}

