/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.Holders;
import groovy.lang.GroovyClassLoader;
import groovy.util.slurpersupport.GPathResult;
import java.io.InputStream;
import java.util.ArrayList;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class GrailsPluginManagerFactoryBean
implements FactoryBean<GrailsPluginManager>,
InitializingBean,
ApplicationContextAware {
    public static final String PLUGIN_LOADER_CLASS = "org.codehaus.groovy.grails.project.plugins.GrailsProjectPluginLoader";
    private GrailsApplication application;
    private GrailsPluginManager pluginManager;
    private Resource descriptor;
    private ApplicationContext applicationContext;

    public GrailsPluginManager getObject() {
        return this.pluginManager;
    }

    public Class<GrailsPluginManager> getObjectType() {
        return GrailsPluginManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.pluginManager = Holders.getPluginManager();
        if (this.pluginManager == null) {
            Assert.state((this.descriptor != null ? 1 : 0) != 0, (String)"Cannot create PluginManager, /WEB-INF/grails.xml not found!");
            if (!this.descriptor.exists()) {
                PluginManagerLoader pluginLoader = (PluginManagerLoader)this.application.getClassLoader().loadClass(PLUGIN_LOADER_CLASS).getConstructor(GrailsApplication.class).newInstance(this.application);
                this.pluginManager = pluginLoader.loadPlugins();
            } else {
                ClassLoader classLoader = this.application.getClassLoader();
                ArrayList classes = new ArrayList();
                InputStream inputStream = null;
                try {
                    inputStream = this.descriptor.getInputStream();
                    GPathResult root = IOUtils.createXmlSlurper().parse(inputStream);
                    GPathResult plugins = (GPathResult)root.getProperty("plugins");
                    GPathResult nodes = (GPathResult)plugins.getProperty("plugin");
                    int count = nodes.size();
                    for (int i = 0; i < count; ++i) {
                        GPathResult node = (GPathResult)nodes.getAt(i);
                        String pluginName = node.text();
                        Class<?> clazz = classLoader instanceof GroovyClassLoader ? classLoader.loadClass(pluginName) : Class.forName(pluginName, true, classLoader);
                        if (classes.contains(clazz)) continue;
                        classes.add(clazz);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                Class[] loadedPlugins = classes.toArray(new Class[classes.size()]);
                this.pluginManager = new DefaultGrailsPluginManager(loadedPlugins, this.application);
                this.pluginManager.setApplicationContext(this.applicationContext);
                Holders.setPluginManager(this.pluginManager);
                this.pluginManager.loadPlugins();
            }
        }
        this.pluginManager.setApplication(this.application);
        this.pluginManager.doArtefactConfiguration();
        this.application.initialise();
    }

    public void setGrailsDescriptor(Resource grailsDescriptor) {
        this.descriptor = grailsDescriptor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setApplication(GrailsApplication application) {
        this.application = application;
    }
}

