/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.AdaptingMetaClass;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import org.codehaus.groovy.grails.commons.metaclass.ConstructorInterceptor;
import org.codehaus.groovy.grails.commons.metaclass.Interceptor;
import org.codehaus.groovy.grails.commons.metaclass.InvocationCallback;
import org.codehaus.groovy.grails.commons.metaclass.PropertyAccessInterceptor;
import org.springframework.util.Assert;

public class ProxyMetaClass
extends MetaClassImpl
implements AdaptingMetaClass {
    protected MetaClass adaptee;
    protected Interceptor interceptor;

    public MetaClass getAdaptee() {
        return this.adaptee;
    }

    public void setAdaptee(MetaClass adaptee) {
        this.adaptee = adaptee;
    }

    public static ProxyMetaClass getInstance(Class<?> theClass) {
        MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();
        MetaClass meta = metaRegistry.getMetaClass(theClass);
        ProxyMetaClass pmc = new ProxyMetaClass(metaRegistry, theClass, meta);
        pmc.initialize();
        return pmc;
    }

    public ProxyMetaClass(MetaClassRegistry registry, Class<?> theClass, MetaClass adaptee) {
        super(registry, theClass);
        Assert.notNull((Object)adaptee, (String)"adaptee must not be null");
        this.adaptee = adaptee;
    }

    public void use(Closure closure) {
        this.registry.setMetaClass(this.theClass, (MetaClass)this);
        try {
            closure.call();
        }
        finally {
            this.registry.setMetaClass(this.theClass, this.adaptee);
        }
    }

    public void use(GroovyObject object, Closure closure) {
        object.setMetaClass((MetaClass)this);
        try {
            closure.call();
        }
        finally {
            object.setMetaClass(this.adaptee);
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Object invokeMethod(Class aClass, final Object object, final String methodName, final Object[] arguments, boolean b, boolean b1) {
        return this.doCall(object, methodName, arguments, new Callable(){

            @Override
            public Object call() {
                return ProxyMetaClass.this.adaptee.invokeMethod(object, methodName, arguments);
            }
        });
    }

    public Object invokeStaticMethod(final Object object, final String methodName, final Object[] arguments) {
        return this.doCall(object, methodName, arguments, new Callable(){

            @Override
            public Object call() {
                return ProxyMetaClass.this.adaptee.invokeStaticMethod(object, methodName, arguments);
            }
        });
    }

    public Object invokeConstructor(Object[] arguments) {
        if (null == this.interceptor) {
            return super.invokeConstructor(arguments);
        }
        if (this.interceptor instanceof ConstructorInterceptor) {
            ConstructorInterceptor ci = (ConstructorInterceptor)this.interceptor;
            InvocationCallback callback = new InvocationCallback();
            Object result = ci.beforeConstructor(arguments, callback);
            if (!callback.isInvoked()) {
                result = super.invokeConstructor(arguments);
            }
            result = ci.afterConstructor(arguments, result);
            return result;
        }
        return super.invokeConstructor(arguments);
    }

    private Object doCall(Object object, String methodName, Object[] arguments, Callable howToInvoke) {
        if (null == this.interceptor) {
            return howToInvoke.call();
        }
        InvocationCallback callback = new InvocationCallback();
        Object result = this.interceptor.beforeInvoke(object, methodName, arguments, callback);
        if (!callback.isInvoked()) {
            result = howToInvoke.call();
        }
        result = this.interceptor.afterInvoke(object, methodName, arguments, result);
        return result;
    }

    public Object getProperty(Class aClass, Object object, String property, boolean b, boolean b1) {
        if (null == this.interceptor) {
            return super.getProperty(aClass, object, property, b, b1);
        }
        if (this.interceptor instanceof PropertyAccessInterceptor) {
            PropertyAccessInterceptor pae = (PropertyAccessInterceptor)this.interceptor;
            InvocationCallback callback = new InvocationCallback();
            Object result = pae.beforeGet(object, property, callback);
            if (!callback.isInvoked()) {
                result = super.getProperty(aClass, object, property, b, b1);
            }
            return result;
        }
        return super.getProperty(aClass, object, property, b, b1);
    }

    public void setProperty(Class aClass, Object object, String property, Object newValue, boolean b, boolean b1) {
        if (null == this.interceptor) {
            super.setProperty(aClass, object, property, newValue, b, b1);
        }
        if (this.interceptor instanceof PropertyAccessInterceptor) {
            PropertyAccessInterceptor pae = (PropertyAccessInterceptor)this.interceptor;
            InvocationCallback callback = new InvocationCallback();
            pae.beforeSet(object, property, newValue, callback);
            if (!callback.isInvoked()) {
                super.setProperty(aClass, object, property, newValue, b, b1);
            }
        } else {
            super.setProperty(aClass, object, property, newValue, b, b1);
        }
    }

    private static interface Callable {
        public Object call();
    }
}

