/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.util.Environment;
import grails.util.GrailsUtil;
import groovy.lang.Closure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class OptimizedAutowireCapableBeanFactory
extends DefaultListableBeanFactory {
    public static boolean DISABLE_AUTOWIRE_BY_NAME_OPTIMIZATIONS = Boolean.getBoolean("grails.disable.optimization.autowirebyname");
    ConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> autowireableBeanPropsCacheForClass = new ConcurrentHashMap();
    private boolean reloadEnabled;

    public OptimizedAutowireCapableBeanFactory() {
        boolean bl = this.reloadEnabled = GrailsUtil.isDevelopmentEnv() || Environment.getCurrent().isReloadEnabled();
        if (this.reloadEnabled) {
            this.setInstantiationStrategy((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(){

                public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
                    if (beanDefinition.getMethodOverrides().isEmpty()) {
                        Constructor constructorToUse;
                        Class clazz = beanDefinition.getBeanClass();
                        if (clazz.isInterface()) {
                            throw new BeanInstantiationException(clazz, "Specified class is an interface");
                        }
                        try {
                            constructorToUse = clazz.getDeclaredConstructor(null);
                        }
                        catch (Exception ex) {
                            throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
                        }
                        return BeanUtils.instantiateClass(constructorToUse, (Object[])new Object[0]);
                    }
                    return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
                }
            });
        }
        this.setParameterNameDiscoverer((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
        this.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        this.ignoreDependencyType(Closure.class);
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return pd.getName().indexOf(36) > -1 || super.isExcludedFromDependencyCheck(pd);
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (Environment.isInitializing()) {
            return;
        }
        if (autowireMode == 1) {
            if (DISABLE_AUTOWIRE_BY_NAME_OPTIMIZATIONS || dependencyCheck || existingBean instanceof Aware) {
                super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
            } else {
                try {
                    this.populateBeanInAutowireByName(existingBean);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Bean couldn't be autowired using grails optimization: " + e.getMessage()));
                    this.logger.error((Object)"Retrying using spring autowire");
                    Class beanClass = ClassUtils.getUserClass(existingBean.getClass());
                    this.autowireableBeanPropsCacheForClass.remove(beanClass);
                    super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
                }
            }
        } else {
            super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
        }
    }

    protected void autowireByName(String beanName, AbstractBeanDefinition mbd, final BeanWrapper bw, MutablePropertyValues pvs) {
        if (!DISABLE_AUTOWIRE_BY_NAME_OPTIMIZATIONS && mbd.isPrototype()) {
            Map<String, PropertyDescriptor> autowireableBeanProps = this.resolveAutowireablePropertyDescriptorsForClass(bw.getWrappedClass(), new Callable<BeanWrapper>(){

                @Override
                public BeanWrapper call() throws Exception {
                    return bw;
                }
            });
            for (Map.Entry<String, PropertyDescriptor> entry : autowireableBeanProps.entrySet()) {
                PropertyDescriptor pd = entry.getValue();
                String propertyName = pd.getName();
                if (pvs.contains(propertyName)) continue;
                String otherBeanName = entry.getKey();
                Object otherBean = this.getBean(otherBeanName);
                pvs.add(propertyName, otherBean);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
            }
        } else {
            super.autowireByName(beanName, mbd, bw, pvs);
        }
    }

    protected void populateBeanInAutowireByName(Object existingBean) {
        Map<String, PropertyDescriptor> autowireableBeanProps = this.resolveAutowireablePropertyDescriptors(existingBean);
        this.autowireBeanInAutowireByName(existingBean, autowireableBeanProps);
    }

    protected void autowireBeanInAutowireByName(final Object existingBean, Map<String, PropertyDescriptor> autowireableBeanProps) {
        for (Map.Entry<String, PropertyDescriptor> entry : autowireableBeanProps.entrySet()) {
            PropertyDescriptor pd = entry.getValue();
            final Method writeMethod = pd.getWriteMethod();
            String beanName = entry.getKey();
            final Object value = this.getBean(beanName);
            try {
                if (System.getSecurityManager() != null) {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                writeMethod.invoke(existingBean, value);
                                return null;
                            }
                        }, this.getAccessControlContext());
                        continue;
                    }
                    catch (PrivilegedActionException ex) {
                        throw ex.getException();
                    }
                }
                writeMethod.invoke(existingBean, value);
            }
            catch (TypeMismatchException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(existingBean, beanName, null, value);
                if (ex.getTargetException() instanceof ClassCastException) {
                    throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
                }
                throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            }
            catch (Exception ex) {
                PropertyChangeEvent pce = new PropertyChangeEvent(existingBean, beanName, null, value);
                throw new MethodInvocationException(pce, (Throwable)ex);
            }
        }
    }

    protected Map<String, PropertyDescriptor> resolveAutowireablePropertyDescriptors(final Object existingBean) {
        return this.resolveAutowireablePropertyDescriptorsForClass(existingBean.getClass(), new Callable<BeanWrapper>(){

            @Override
            public BeanWrapper call() throws Exception {
                BeanWrapperImpl bw = new BeanWrapperImpl(false);
                Class userClass = ClassUtils.getUserClass(existingBean.getClass());
                if (userClass != existingBean.getClass()) {
                    bw.setWrappedInstance(BeanUtils.instantiate((Class)userClass));
                } else {
                    bw.setWrappedInstance(existingBean);
                }
                bw.setConversionService(OptimizedAutowireCapableBeanFactory.this.getConversionService());
                return bw;
            }
        });
    }

    protected Map<String, PropertyDescriptor> resolveAutowireablePropertyDescriptorsForClass(Class<?> beanClass, Callable<BeanWrapper> beanWrapperCallback) {
        HashMap<String, PropertyDescriptor> autowireableBeanProps = (HashMap<String, PropertyDescriptor>)this.autowireableBeanPropsCacheForClass.get(beanClass = ClassUtils.getUserClass(beanClass));
        if (autowireableBeanProps == null) {
            PropertyDescriptor[] pds;
            autowireableBeanProps = new HashMap<String, PropertyDescriptor>();
            BeanWrapper bw = null;
            try {
                bw = beanWrapperCallback.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (PropertyDescriptor pd : pds = bw.getPropertyDescriptors()) {
                if (!this.containsBean(pd.getName()) || pd.getWriteMethod() == null || this.isExcludedFromDependencyCheck(pd) || BeanUtils.isSimpleProperty(pd.getPropertyType())) continue;
                final Method writeMethod = pd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers()) && !writeMethod.isAccessible()) {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                writeMethod.setAccessible(true);
                                return null;
                            }
                        });
                    } else {
                        writeMethod.setAccessible(true);
                    }
                }
                autowireableBeanProps.put(pd.getName(), pd);
            }
            if (!this.reloadEnabled) {
                this.autowireableBeanPropsCacheForClass.put(beanClass, autowireableBeanProps);
            }
        }
        return autowireableBeanProps;
    }
}

