/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.spring.BeanBuilder;
import grails.util.CollectionUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;

public class RuntimeSpringConfigUtilities {
    private static final Log LOG = LogFactory.getLog(RuntimeSpringConfigUtilities.class);
    public static final String GRAILS_URL_MAPPINGS = "grailsUrlMappings";
    public static final String SPRING_RESOURCES_XML = "/WEB-INF/spring/resources.xml";
    public static final String SPRING_RESOURCES_GROOVY = "/WEB-INF/spring/resources.groovy";
    public static final String SPRING_RESOURCES_CLASS = "resources";
    private static final String DEVELOPMENT_SPRING_RESOURCES_XML = "file:./grails-app/conf/spring/resources.xml";
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application, GenericApplicationContext context) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application);
        if (context != null) {
            springGroovyResourcesBeanBuilder.registerBeans((BeanDefinitionRegistry)context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, GrailsApplication application) {
        if (springGroovyResourcesBeanBuilder == null) {
            try {
                Class groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName((String)SPRING_RESOURCES_CLASS, (ClassLoader)application.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (groovySpringResourcesClass != null) {
                    RuntimeSpringConfigUtilities.reloadSpringResourcesConfig(config, application, groovySpringResourcesClass);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from resources.groovy", (Throwable)ex);
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    public static BeanBuilder reloadSpringResourcesConfig(RuntimeSpringConfiguration config, GrailsApplication application, Class<?> groovySpringResourcesClass) throws InstantiationException, IllegalAccessException {
        springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, Thread.currentThread().getContextClassLoader());
        springGroovyResourcesBeanBuilder.setBinding(new Binding(CollectionUtils.newMap((Object[])new Object[]{"application", application, "grailsApplication", application})));
        Script script = (Script)groovySpringResourcesClass.newInstance();
        script.run();
        Object beans = script.getProperty("beans");
        springGroovyResourcesBeanBuilder.beans((Closure)beans);
        return springGroovyResourcesBeanBuilder;
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, GrailsApplication application, GenericApplicationContext context) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application);
        RuntimeSpringConfigUtilities.doLoadSpringGroovyResources(config, application, context);
    }

    public static void reset() {
        springGroovyResourcesBeanBuilder = null;
    }
}

