/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Environment;
import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.util.ConfigObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.BootstrapArtefactHandler;
import org.codehaus.groovy.grails.commons.CodecArtefactHandler;
import org.codehaus.groovy.grails.commons.ControllerArtefactHandler;
import org.codehaus.groovy.grails.commons.DefaultArtefactInfo;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.ServiceArtefactHandler;
import org.codehaus.groovy.grails.commons.TagLibArtefactHandler;
import org.codehaus.groovy.grails.commons.UrlMappingsArtefactHandler;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAwareBeanPostProcessor;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsConfigurationAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultGrailsApplication
extends GroovyObjectSupport
implements GrailsApplication,
BeanClassLoaderAware {
    protected static final Pattern GETCLASSESPROP_PATTERN = Pattern.compile("(\\w+)(Classes)");
    protected static final Pattern GETCLASSESMETH_PATTERN = Pattern.compile("(get)(\\w+)(Classes)");
    protected static final Pattern ISCLASS_PATTERN = Pattern.compile("(is)(\\w+)(Class)");
    protected static final Pattern GETCLASS_PATTERN = Pattern.compile("(get)(\\w+)Class");
    protected ClassLoader cl;
    protected Class<?>[] allClasses = new Class[0];
    protected static Log log = LogFactory.getLog(DefaultGrailsApplication.class);
    protected ApplicationContext parentContext;
    protected ApplicationContext mainContext;
    protected List<Class<?>> loadedClasses = new ArrayList();
    protected ArtefactHandler[] artefactHandlers;
    protected Map<String, ArtefactHandler> artefactHandlersByName = new HashMap<String, ArtefactHandler>();
    protected List<Class<?>> allArtefactClasses = new ArrayList();
    protected Map<String, ArtefactInfo> artefactInfo = new HashMap<String, ArtefactInfo>();
    protected Class<?>[] allArtefactClassesArray;
    protected Metadata applicationMeta = Metadata.getCurrent();
    protected org.springframework.core.io.Resource[] resources;
    protected boolean initialised = false;
    protected ConfigObject config;
    protected Map flatConfig = Collections.emptyMap();

    public DefaultGrailsApplication() {
        ConfigurationHelper.clearCachedConfig(this);
        this.cl = new GroovyClassLoader();
    }

    public DefaultGrailsApplication(Class<?>[] classes, ClassLoader classLoader) {
        ConfigurationHelper.clearCachedConfig(this);
        Assert.notNull(classes, (String)"Constructor argument 'classes' cannot be null");
        this.loadedClasses.addAll(Arrays.asList(classes));
        this.allClasses = classes;
        this.cl = classLoader;
    }

    public DefaultGrailsApplication(org.springframework.core.io.Resource[] resources) {
        this();
        for (org.springframework.core.io.Resource resource : resources) {
            Class<?> aClass;
            try {
                aClass = this.cl.loadClass(GrailsResourceUtils.getClassName((String)resource.getFile().getAbsolutePath()));
            }
            catch (ClassNotFoundException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            this.loadedClasses.add(aClass);
        }
    }

    public DefaultGrailsApplication(Resource[] resources) {
        this();
        for (Resource resource : resources) {
            Class<?> aClass;
            try {
                aClass = this.cl.loadClass(GrailsResourceUtils.getClassName((String)resource.getFile().getAbsolutePath()));
            }
            catch (ClassNotFoundException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            this.loadedClasses.add(aClass);
        }
    }

    protected void initArtefactHandlers() {
        UrlMappingsArtefactHandler urlMappingsArtefactHandler;
        CodecArtefactHandler codecArtefactHandler;
        BootstrapArtefactHandler bootstrapArtefactHandler;
        TagLibArtefactHandler tagLibArtefactHandler;
        ServiceArtefactHandler serviceArtefactHandler;
        ControllerArtefactHandler controllerArtefactHandler;
        AnnotationDomainClassArtefactHandler domainClassArtefactHandler = new AnnotationDomainClassArtefactHandler();
        if (!this.hasArtefactHandler(domainClassArtefactHandler.getType())) {
            this.registerArtefactHandler(domainClassArtefactHandler);
        }
        if (!this.hasArtefactHandler((controllerArtefactHandler = new ControllerArtefactHandler()).getType())) {
            this.registerArtefactHandler(controllerArtefactHandler);
        }
        if (!this.hasArtefactHandler((serviceArtefactHandler = new ServiceArtefactHandler()).getType())) {
            this.registerArtefactHandler(serviceArtefactHandler);
        }
        if (!this.hasArtefactHandler((tagLibArtefactHandler = new TagLibArtefactHandler()).getType())) {
            this.registerArtefactHandler(tagLibArtefactHandler);
        }
        if (!this.hasArtefactHandler((bootstrapArtefactHandler = new BootstrapArtefactHandler()).getType())) {
            this.registerArtefactHandler(bootstrapArtefactHandler);
        }
        if (!this.hasArtefactHandler((codecArtefactHandler = new CodecArtefactHandler()).getType())) {
            this.registerArtefactHandler(codecArtefactHandler);
        }
        if (!this.hasArtefactHandler((urlMappingsArtefactHandler = new UrlMappingsArtefactHandler()).getType())) {
            this.registerArtefactHandler(urlMappingsArtefactHandler);
        }
        this.updateArtefactHandlers();
    }

    private void updateArtefactHandlers() {
        this.artefactHandlers = this.artefactHandlersByName.values().toArray(new ArtefactHandler[this.artefactHandlersByName.size()]);
    }

    public Class<?>[] getAllArtefacts() {
        return this.allArtefactClassesArray;
    }

    protected Class<?>[] populateAllClasses() {
        this.allClasses = this.loadedClasses.toArray(new Class[this.loadedClasses.size()]);
        return this.allClasses;
    }

    protected void configureLoadedClasses(Class<?>[] classes) {
        this.initArtefactHandlers();
        this.artefactInfo.clear();
        this.allArtefactClasses.clear();
        this.allArtefactClassesArray = null;
        this.allClasses = classes;
        log.debug((Object)"Going to inspect artefact classes.");
        boolean warDeployed = Environment.isWarDeployed();
        block0: for (Class<?> theClass : classes) {
            log.debug((Object)("Inspecting [" + theClass.getName() + "]"));
            if (!warDeployed) {
                GroovySystem.getMetaClassRegistry().removeMetaClass(theClass);
            }
            if (this.allArtefactClasses.contains(theClass)) continue;
            for (ArtefactHandler artefactHandler : this.artefactHandlers) {
                if (!artefactHandler.isArtefact(theClass)) continue;
                log.debug((Object)("Adding artefact " + theClass + " of kind " + artefactHandler.getType()));
                GrailsClass gclass = this.addArtefact(artefactHandler.getType(), theClass);
                this.allArtefactClasses.add(theClass);
                DefaultArtefactInfo info = this.getArtefactInfo(artefactHandler.getType(), true);
                info.addGrailsClass(gclass);
                continue block0;
            }
        }
        this.refreshArtefactGrailsClassCaches();
        this.allArtefactClassesArray = this.allArtefactClasses.toArray(new Class[this.allArtefactClasses.size()]);
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            this.initializeArtefacts(artefactHandler);
        }
    }

    protected void refreshArtefactGrailsClassCaches() {
        for (ArtefactInfo o : this.artefactInfo.values()) {
            ((DefaultArtefactInfo)o).updateComplete();
        }
    }

    protected void addToLoaded(Class<?> clazz) {
        this.loadedClasses.add(clazz);
        this.populateAllClasses();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @Override
    public ConfigObject getConfig() {
        if (this.config == null) {
            this.setConfig(ConfigurationHelper.loadConfigFromClasspath(this));
        }
        return this.config;
    }

    public void setConfig(ConfigObject config) {
        this.config = config;
        this.flatConfig = config == null ? Collections.emptyMap() : config.flatten(new LinkedHashMap());
    }

    @Override
    public Map<String, Object> getFlatConfig() {
        return this.flatConfig;
    }

    protected int getArtefactCount(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? 0 : info.getClasses().length;
    }

    public Class<?>[] getAllClasses() {
        return this.allClasses;
    }

    @Override
    public ApplicationContext getMainContext() {
        return this.mainContext;
    }

    @Override
    public void setMainContext(ApplicationContext context) {
        this.mainContext = context;
        if (this.mainContext == null) {
            return;
        }
        if (!this.mainContext.containsBean("pluginManager")) {
            return;
        }
        if (this.mainContext instanceof ConfigurableApplicationContext && !((ConfigurableApplicationContext)this.mainContext).isActive()) {
            return;
        }
        ((GrailsPluginManager)this.mainContext.getBean("pluginManager", GrailsPluginManager.class)).setApplicationContext(context);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    @Override
    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public Class<?> getClassForName(String className) {
        if (!StringUtils.hasText((String)className)) {
            return null;
        }
        for (Class<?> c : this.allClasses) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void refreshConstraints() {
        GrailsClass[] domainClasses;
        DefaultArtefactInfo info = this.getArtefactInfo("Domain", true);
        for (GrailsClass domainClass : domainClasses = info.getGrailsClasses()) {
            ((GrailsDomainClass)domainClass).refreshConstraints();
        }
    }

    @Override
    public void refresh() {
        if (this.cl instanceof GroovyClassLoader) {
            this.configureLoadedClasses(((GroovyClassLoader)this.cl).getLoadedClasses());
        }
    }

    @Override
    public void rebuild() {
        this.initialised = false;
        this.loadedClasses.clear();
        this.initArtefactHandlers();
        if (!GrailsUtil.isDevelopmentEnv()) {
            throw new IllegalStateException("Cannot rebuild GrailsApplication when not in development mode!");
        }
        this.initialise();
    }

    @Override
    public org.springframework.core.io.Resource getResourceForClass(Class theClazz) {
        return null;
    }

    @Override
    public boolean isArtefact(Class theClazz) {
        String className = theClazz.getName();
        for (Class<?> artefactClass : this.allArtefactClasses) {
            if (!className.equals(artefactClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArtefactOfType(String artefactType, Class theClazz) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler == null) {
            throw new GrailsConfigurationException("Unable to locate arefact handler for specified type: " + artefactType);
        }
        return handler.isArtefact(theClazz);
    }

    @Override
    public boolean isArtefactOfType(String artefactType, String className) {
        return this.getArtefact(artefactType, className) != null;
    }

    @Override
    public GrailsClass getArtefact(String artefactType, String name) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClass(name);
    }

    @Override
    public ArtefactHandler getArtefactType(Class theClass) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(theClass)) continue;
            return artefactHandler;
        }
        return null;
    }

    protected GrailsClass getFirstArtefact(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClasses()[0];
    }

    @Override
    public GrailsClass[] getArtefacts(String artefactType) {
        return this.getArtefactInfo(artefactType, true).getGrailsClasses();
    }

    @Override
    public GrailsClass getArtefactForFeature(String artefactType, Object featureID) {
        return this.artefactHandlersByName.get(artefactType).getArtefactForFeature(featureID);
    }

    @Override
    public GrailsClass addArtefact(String artefactType, Class artefactClass) {
        return this.addArtefact(artefactType, artefactClass, false);
    }

    @Override
    public GrailsClass addArtefact(String artefactType, GrailsClass artefactGrailsClass) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefactGrailsClass(artefactGrailsClass)) {
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.initializeArtefacts(artefactType);
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactGrailsClass + "]. It is not a " + artefactType + "!");
    }

    @Override
    public void registerArtefactHandler(ArtefactHandler handler) {
        GrailsApplicationAwareBeanPostProcessor.processAwareInterfaces(this, handler);
        this.artefactHandlersByName.put(handler.getType(), handler);
        this.updateArtefactHandlers();
    }

    @Override
    public boolean hasArtefactHandler(String type) {
        return this.artefactHandlersByName.containsKey(type);
    }

    @Override
    public ArtefactHandler[] getArtefactHandlers() {
        return this.artefactHandlers;
    }

    @Override
    public ArtefactHandler getArtefactHandler(String type) {
        return this.artefactHandlersByName.get(type);
    }

    protected void initializeArtefacts(String artefactType) {
        this.initializeArtefacts(this.artefactHandlersByName.get(artefactType));
    }

    public void clear() {
        this.artefactHandlersByName.clear();
        this.updateArtefactHandlers();
        this.artefactInfo.clear();
        this.initialise();
    }

    protected void initializeArtefacts(ArtefactHandler handler) {
        if (handler == null) {
            return;
        }
        ArtefactInfo info = this.getArtefactInfo(handler.getType());
        if (info != null) {
            handler.initialize(info);
        }
    }

    protected DefaultArtefactInfo getArtefactInfo(String artefactType, boolean create) {
        DefaultArtefactInfo cache = (DefaultArtefactInfo)this.artefactInfo.get(artefactType);
        if (cache == null && create) {
            cache = new DefaultArtefactInfo();
            this.artefactInfo.put(artefactType, cache);
            cache.updateComplete();
        }
        return cache;
    }

    @Override
    public ArtefactInfo getArtefactInfo(String artefactType) {
        return this.getArtefactInfo(artefactType, false);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object[] argsv = (Object[])args;
        Matcher match = GETCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length > 0) {
                if (argsv[0] instanceof CharSequence) {
                    argsv[0] = argsv[0].toString();
                }
                if (argsv.length != 1 || !(argsv[0] instanceof String)) {
                    throw new IllegalArgumentException("Dynamic method get<Artefact>Class(artefactName) requires a single String parameter");
                }
                return this.getArtefact(match.group(2), argsv[0].toString());
            }
            return super.invokeMethod(methodName, args);
        }
        match = ISCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length != 1 || !(argsv[0] instanceof Class)) {
                throw new IllegalArgumentException("Dynamic method is<Artefact>Class(artefactClass) requires a single Class parameter");
            }
            return this.isArtefactOfType(match.group(2), (Class)argsv[0]);
        }
        match = GETCLASSESMETH_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            String artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(2));
            if (this.artefactHandlersByName.containsKey(artefactName)) {
                return this.getArtefacts(match.group(2));
            }
            throw new IllegalArgumentException("Dynamic method get<Artefact>Classes() called for unrecognized artefact: " + match.group(2));
        }
        return super.invokeMethod(methodName, args);
    }

    public Object getProperty(String propertyName) {
        String artefactName;
        Matcher match = GETCLASSESPROP_PATTERN.matcher(propertyName);
        match.find();
        if (match.matches() && this.artefactHandlersByName.containsKey(artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(1)))) {
            return this.getArtefacts(artefactName);
        }
        return super.getProperty(propertyName);
    }

    @Override
    public void initialise() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded classes: [" + this.loadedClasses + "]"));
        }
        Class<?>[] classes = this.populateAllClasses();
        this.configureLoadedClasses(classes);
        this.initialised = true;
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    @Override
    public Metadata getMetadata() {
        return this.applicationMeta;
    }

    @Override
    public GrailsClass getArtefactByLogicalPropertyName(String type, String logicalName) {
        ArtefactInfo info = this.getArtefactInfo(type);
        return info == null ? null : info.getGrailsClassByLogicalPropertyName(logicalName);
    }

    @Override
    public void addArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addArtefact(artefactHandler.getType(), artefact);
        }
    }

    @Override
    public boolean isWarDeployed() {
        return this.getMetadata().isWarDeployed();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
    }

    @Override
    public void addOverridableArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addOverridableArtefact(artefactHandler.getType(), artefact);
        }
    }

    @Override
    public void configChanged() {
        ArtefactHandler[] handlers;
        ConfigObject co = this.getConfig();
        this.flatConfig = co.flatten(new LinkedHashMap());
        for (ArtefactHandler handler : handlers = this.getArtefactHandlers()) {
            if (!(handler instanceof GrailsConfigurationAware)) continue;
            ((GrailsConfigurationAware)((Object)handler)).setConfiguration(co);
        }
    }

    public GrailsClass addOverridableArtefact(String artefactType, Class artefactClass) {
        return this.addArtefact(artefactType, artefactClass, true);
    }

    protected GrailsClass addArtefact(String artefactType, Class<?> artefactClass, boolean overrideable) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefact(artefactClass)) {
            GrailsClass artefactGrailsClass = handler.newArtefactClass(artefactClass);
            artefactGrailsClass.setGrailsApplication(this);
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            if (overrideable) {
                info.addOverridableGrailsClass(artefactGrailsClass);
            } else {
                info.addGrailsClass(artefactGrailsClass);
            }
            info.updateComplete();
            this.addToLoaded(artefactClass);
            if (this.isInitialised()) {
                this.initializeArtefacts(artefactType);
            }
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactClass + "]. It is not a " + artefactType + "!");
    }
}

