/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import org.apache.commons.validator.EmailValidator;
import org.codehaus.groovy.grails.commons.GrailsStringUtils;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

public class EmailConstraint
extends AbstractConstraint {
    private boolean email;

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    @Override
    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [email] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        this.email = (Boolean)constraintParameter;
        super.setParameter(constraintParameter);
    }

    @Override
    public String getName() {
        return "email";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (!this.email) {
            return;
        }
        EmailValidator emailValidator = EmailValidator.getInstance();
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
        String value = propertyValue.toString();
        if (GrailsStringUtils.isBlank(value)) {
            return;
        }
        if (!emailValidator.isValid(value)) {
            this.rejectValue(target, errors, "default.invalid.email.message", "email.invalid", args);
        }
    }
}

