/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.lifecycle;

import grails.util.Holders;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;

public class ShutdownOperations {
    private static final Log LOG = LogFactory.getLog(ShutdownOperations.class);
    private static final Collection<Runnable> shutdownOperations = new ConcurrentLinkedQueue<Runnable>();
    public static final Runnable DEFAULT_SHUTDOWN_OPERATION = new Runnable(){

        @Override
        public void run() {
            Holders.reset();
            ConfigurationHelper.clearCachedConfigs();
            ClassPropertyFetcher.clearClassPropertyFetcherCache();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOperations() {
        try {
            for (Runnable shutdownOperation : shutdownOperations) {
                try {
                    shutdownOperation.run();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error occurred running shutdown operation: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            shutdownOperations.clear();
            shutdownOperations.add(DEFAULT_SHUTDOWN_OPERATION);
        }
    }

    public static void addOperation(Runnable runnable) {
        shutdownOperations.add(runnable);
    }

    static {
        shutdownOperations.add(DEFAULT_SHUTDOWN_OPERATION);
    }
}

