/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.grails.plugins.support.WatchPattern;
import org.springframework.util.StringUtils;

public class WatchPatternParser {
    public static final String WILD_CARD = "*";

    public List<WatchPattern> getWatchPatterns(List<String> patterns) {
        ArrayList<WatchPattern> watchPatterns = new ArrayList<WatchPattern>();
        for (String pattern : patterns) {
            WatchPattern watchPattern = new WatchPattern();
            watchPattern.setPattern(pattern);
            if (pattern.startsWith("file:")) {
                pattern = pattern.substring(5);
            }
            if (pattern.contains(WILD_CARD)) {
                watchPattern.setDirectory(new File(pattern.substring(0, pattern.indexOf(WILD_CARD))));
                this.setExtension(pattern, watchPattern);
                watchPatterns.add(watchPattern);
                continue;
            }
            this.setExtension(pattern, watchPattern);
            watchPattern.setFile(new File(pattern));
            watchPatterns.add(watchPattern);
        }
        return watchPatterns;
    }

    private void setExtension(String pattern, WatchPattern watchPattern) {
        int i = pattern.lastIndexOf(42);
        if (i > -1) {
            String extension = pattern.substring(i + 1, pattern.length());
            if (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            watchPattern.setExtension(extension);
        } else {
            String ext = StringUtils.getFilenameExtension((String)pattern);
            if (ext != null) {
                watchPattern.setExtension(ext);
            }
        }
    }
}

