/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import org.codehaus.groovy.grails.support.encoding.CharArrayAccessible;
import org.codehaus.groovy.grails.support.encoding.CharSequences;

class SubCharSequence
implements CharSequence,
CharArrayAccessible {
    private final CharSequence str;
    private final int count;
    private final int start;

    SubCharSequence(CharSequence str, int start, int count) {
        if (start + count > str.length()) {
            throw new StringIndexOutOfBoundsException(start);
        }
        this.str = str;
        this.start = start;
        this.count = count;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index + this.start >= this.str.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.str.charAt(index + this.start);
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        if (start == 0 && end == this.count) {
            return this;
        }
        return new SubCharSequence(this.str, this.start + start, end - start);
    }

    @Override
    public String toString() {
        return this.str.subSequence(this.start, this.start + this.count).toString();
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.start + this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        CharSequences.getChars(this.str, this.start + srcBegin, this.start + srcEnd, dst, dstBegin);
    }
}

