/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.MissingPropertyException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.FunctionCallback;
import org.springframework.util.Assert;

public class GenericDynamicProperty
extends AbstractDynamicProperty {
    private Class<?> type;
    private boolean readOnly;
    private Map<String, Object> propertyToInstanceMap = new ConcurrentHashMap<String, Object>();
    private Object initialValue;
    private FunctionCallback initialValueGenerator;

    public GenericDynamicProperty(String propertyName, Class<?> type, Object initialValue, boolean readOnly) {
        super(propertyName);
        Assert.notNull(type, (String)"Constructor argument 'type' cannot be null");
        this.readOnly = readOnly;
        this.type = type;
        this.initialValue = initialValue;
    }

    public GenericDynamicProperty(String propertyName, Class<?> type, boolean readOnly) {
        this(propertyName, type, (Object)null, readOnly);
    }

    public GenericDynamicProperty(String propertyName, Class<?> type, FunctionCallback initialValueGenerator, boolean readOnly) {
        this(propertyName, type, readOnly);
        this.initialValueGenerator = initialValueGenerator;
    }

    @Override
    public Object get(Object object) {
        String propertyKey = System.identityHashCode(object) + this.getPropertyName();
        if (this.propertyToInstanceMap.containsKey(propertyKey)) {
            return this.propertyToInstanceMap.get(propertyKey);
        }
        if (this.initialValueGenerator != null) {
            Object value = this.initialValueGenerator.execute(object);
            this.propertyToInstanceMap.put(propertyKey, value);
            return value;
        }
        if (this.initialValue != null) {
            this.propertyToInstanceMap.put(propertyKey, this.initialValue);
            return this.initialValue;
        }
        return null;
    }

    @Override
    public void set(Object object, Object newValue) {
        if (this.readOnly) {
            throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass().getName() + "' is read-only!", object.getClass());
        }
        if (newValue == null) {
            this.propertyToInstanceMap.put(String.valueOf(System.identityHashCode(object)) + this.getPropertyName(), null);
        } else if (this.type.isInstance(newValue)) {
            this.propertyToInstanceMap.put(String.valueOf(System.identityHashCode(object)) + this.getPropertyName(), newValue);
        } else {
            throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass().getName() + "' cannot be set with value '" + newValue + "'. Incorrect type.", object.getClass());
        }
    }
}

