/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.validation.AbstractVetoingConstraint;
import org.springframework.validation.Errors;

public class BlankConstraint
extends AbstractVetoingConstraint {
    private boolean blank;

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    @Override
    public Object getParameter() {
        return this.blank;
    }

    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [blank] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        this.blank = (Boolean)constraintParameter;
        super.setParameter(constraintParameter);
    }

    @Override
    public String getName() {
        return "blank";
    }

    @Override
    protected boolean skipBlankValues() {
        return false;
    }

    @Override
    protected boolean processValidateWithVetoing(Object target, Object propertyValue, Errors errors) {
        if (propertyValue instanceof String && StringUtils.isBlank((String)((String)propertyValue)) && !this.blank) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass};
            this.rejectValue(target, errors, "default.blank.message", "blank", args);
            return true;
        }
        return false;
    }
}

