/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.Environment;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import groovy.xml.DOMBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.WebRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.plugins.AbstractGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.BinaryGrailsPlugin;
import org.codehaus.groovy.grails.plugins.BinaryGrailsPluginDescriptor;
import org.codehaus.groovy.grails.plugins.CorePluginFinder;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.GrailsVersionUtils;
import org.codehaus.groovy.grails.plugins.IdentityPluginFilter;
import org.codehaus.groovy.grails.plugins.PluginFilter;
import org.codehaus.groovy.grails.plugins.PluginFilterRetriever;
import org.codehaus.groovy.grails.plugins.Servlet3AsyncWebXmlProcessor;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.grails.support.ParentApplicationContextAware;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefaultGrailsPluginManager
extends AbstractGrailsPluginManager {
    private static final Log LOG = LogFactory.getLog(DefaultGrailsPluginManager.class);
    protected static final Class<?>[] COMMON_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Class.class, Double.class, Float.class, Integer.class, Long.class, Number.class, Short.class, String.class, BigInteger.class, BigDecimal.class, URL.class, URI.class};
    private List<GrailsPlugin> delayedLoadPlugins = new LinkedList<GrailsPlugin>();
    private ApplicationContext parentCtx;
    private PathMatchingResourcePatternResolver resolver;
    private Map<GrailsPlugin, String[]> delayedEvictions = new HashMap<GrailsPlugin, String[]>();
    private ServletContext servletContext;
    private Map<String, Set<GrailsPlugin>> pluginToObserverMap = new HashMap<String, Set<GrailsPlugin>>();
    private PluginFilter pluginFilter;
    private static final String GRAILS_PLUGIN_SUFFIX = "GrailsPlugin";
    private List<GrailsPlugin> userPlugins = new ArrayList<GrailsPlugin>();

    public DefaultGrailsPluginManager(String resourcePath, GrailsApplication application) {
        super(application);
        Assert.notNull((Object)application, (String)"Argument [application] cannot be null!");
        this.resolver = new PathMatchingResourcePatternResolver();
        try {
            this.pluginResources = this.resolver.getResources(resourcePath);
        }
        catch (IOException ioe) {
            LOG.debug((Object)("Unable to load plugins for resource path " + resourcePath), (Throwable)ioe);
        }
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(String[] pluginResources, GrailsApplication application) {
        super(application);
        this.resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String resourcePath : pluginResources) {
            try {
                resourceList.addAll(Arrays.asList(this.resolver.getResources(resourcePath)));
            }
            catch (IOException ioe) {
                LOG.debug((Object)("Unable to load plugins for resource path " + resourcePath), (Throwable)ioe);
            }
        }
        this.pluginResources = resourceList.toArray(new Resource[resourceList.size()]);
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Class<?>[] plugins, GrailsApplication application) {
        super(application);
        this.pluginClasses = plugins;
        this.resolver = new PathMatchingResourcePatternResolver();
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application) {
        super(application);
        this.resolver = new PathMatchingResourcePatternResolver();
        this.pluginResources = pluginFiles;
        this.application = application;
        this.setPluginFilter();
    }

    @Override
    public GrailsPlugin[] getUserPlugins() {
        return this.userPlugins.toArray(new GrailsPlugin[this.userPlugins.size()]);
    }

    private void setPluginFilter() {
        this.pluginFilter = new PluginFilterRetriever().getPluginFilter((Map)this.application.getConfig());
    }

    @Deprecated
    public void startPluginChangeScanner() {
    }

    @Deprecated
    public void stopPluginChangeScanner() {
    }

    @Override
    public void refreshPlugin(String name) {
        if (this.hasGrailsPlugin(name)) {
            this.getGrailsPlugin(name).refresh();
        }
    }

    @Override
    public Collection<GrailsPlugin> getPluginObservers(GrailsPlugin plugin) {
        Assert.notNull((Object)plugin, (String)"Argument [plugin] cannot be null");
        Collection c = this.pluginToObserverMap.get(plugin.getName());
        Collection wildcardObservers = this.pluginToObserverMap.get("*");
        if (wildcardObservers != null) {
            if (c != null) {
                c.addAll(wildcardObservers);
            } else {
                c = wildcardObservers;
            }
        }
        if (c != null) {
            c.remove(plugin);
            return c;
        }
        return Collections.emptySet();
    }

    @Override
    public void informObservers(String pluginName, Map event) {
        GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        if (plugin == null) {
            return;
        }
        for (GrailsPlugin observingPlugin : this.getPluginObservers(plugin)) {
            observingPlugin.notifyOfEvent(event);
        }
    }

    @Override
    public void loadPlugins() throws PluginException {
        if (this.initialised) {
            return;
        }
        ClassLoader gcl = this.application.getClassLoader();
        this.attemptLoadPlugins(gcl);
        if (!this.delayedLoadPlugins.isEmpty()) {
            this.loadDelayedPlugins();
        }
        if (!this.delayedEvictions.isEmpty()) {
            this.processDelayedEvictions();
        }
        this.pluginList = this.sortPlugins(this.pluginList);
        this.initializePlugins();
        this.initialised = true;
    }

    protected List<GrailsPlugin> sortPlugins(List<GrailsPlugin> toSort) {
        ArrayList<GrailsPlugin> sortedPlugins = new ArrayList<GrailsPlugin>(toSort.size());
        HashSet<GrailsPlugin> visitedPlugins = new HashSet<GrailsPlugin>();
        Map<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies = this.resolveLoadDependencies(toSort);
        for (GrailsPlugin plugin : toSort) {
            this.visitTopologicalSort(plugin, sortedPlugins, visitedPlugins, loadOrderDependencies);
        }
        return sortedPlugins;
    }

    protected Map<GrailsPlugin, List<GrailsPlugin>> resolveLoadDependencies(List<GrailsPlugin> plugins) {
        HashMap<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies = new HashMap<GrailsPlugin, List<GrailsPlugin>>();
        for (GrailsPlugin plugin : plugins) {
            if (plugin.getLoadAfterNames() != null) {
                ArrayList<GrailsPlugin> loadDepsForPlugin = (ArrayList<GrailsPlugin>)loadOrderDependencies.get(plugin);
                if (loadDepsForPlugin == null) {
                    loadDepsForPlugin = new ArrayList<GrailsPlugin>();
                    loadOrderDependencies.put(plugin, loadDepsForPlugin);
                }
                for (String pluginName : plugin.getLoadAfterNames()) {
                    GrailsPlugin loadAfterPlugin = this.getGrailsPlugin(pluginName);
                    if (loadAfterPlugin == null) continue;
                    loadDepsForPlugin.add(loadAfterPlugin);
                }
            }
            for (String loadBefore : plugin.getLoadBeforeNames()) {
                GrailsPlugin loadBeforePlugin = this.getGrailsPlugin(loadBefore);
                if (loadBeforePlugin == null) continue;
                ArrayList<GrailsPlugin> loadDepsForPlugin = (ArrayList<GrailsPlugin>)loadOrderDependencies.get(loadBeforePlugin);
                if (loadDepsForPlugin == null) {
                    loadDepsForPlugin = new ArrayList<GrailsPlugin>();
                    loadOrderDependencies.put(loadBeforePlugin, loadDepsForPlugin);
                }
                loadDepsForPlugin.add(plugin);
            }
        }
        return loadOrderDependencies;
    }

    private void visitTopologicalSort(GrailsPlugin plugin, List<GrailsPlugin> sortedPlugins, Set<GrailsPlugin> visitedPlugins, Map<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies) {
        if (plugin != null && !visitedPlugins.contains(plugin)) {
            visitedPlugins.add(plugin);
            List<GrailsPlugin> loadDepsForPlugin = loadOrderDependencies.get(plugin);
            if (loadDepsForPlugin != null) {
                for (GrailsPlugin dependentPlugin : loadDepsForPlugin) {
                    this.visitTopologicalSort(dependentPlugin, sortedPlugins, visitedPlugins, loadOrderDependencies);
                }
            }
            sortedPlugins.add(plugin);
        }
    }

    private void attemptLoadPlugins(ClassLoader gcl) {
        ArrayList grailsCorePlugins = this.loadCorePlugins ? this.findCorePlugins() : new ArrayList();
        List<GrailsPlugin> grailsUserPlugins = this.findUserPlugins(gcl);
        this.userPlugins = grailsUserPlugins;
        ArrayList<GrailsPlugin> allPlugins = new ArrayList<GrailsPlugin>(grailsCorePlugins);
        allPlugins.addAll(grailsUserPlugins);
        List<GrailsPlugin> filteredPlugins = this.getPluginFilter().filterPluginList(allPlugins);
        ArrayList<GrailsPlugin> orderedCorePlugins = new ArrayList<GrailsPlugin>();
        ArrayList<GrailsPlugin> orderedUserPlugins = new ArrayList<GrailsPlugin>();
        for (GrailsPlugin plugin : filteredPlugins) {
            if (grailsCorePlugins == null) continue;
            if (grailsCorePlugins.contains(plugin)) {
                orderedCorePlugins.add(plugin);
                continue;
            }
            orderedUserPlugins.add(plugin);
        }
        ArrayList<GrailsPlugin> orderedPlugins = new ArrayList<GrailsPlugin>();
        orderedPlugins.addAll(orderedCorePlugins);
        orderedPlugins.addAll(orderedUserPlugins);
        for (GrailsPlugin plugin : orderedPlugins) {
            this.attemptPluginLoad(plugin);
        }
    }

    private List<GrailsPlugin> findCorePlugins() {
        Class<?>[] corePluginClasses;
        CorePluginFinder finder = new CorePluginFinder(this.application);
        finder.setParentApplicationContext(this.parentCtx);
        ArrayList<GrailsPlugin> grailsCorePlugins = new ArrayList<GrailsPlugin>();
        for (Class<?> pluginClass : corePluginClasses = finder.getPluginClasses()) {
            if (pluginClass == null || Modifier.isAbstract(pluginClass.getModifiers()) || pluginClass == DefaultGrailsPlugin.class) continue;
            BinaryGrailsPluginDescriptor binaryDescriptor = finder.getBinaryDescriptor(pluginClass);
            GrailsPlugin plugin = binaryDescriptor != null ? this.createBinaryGrailsPlugin(pluginClass, binaryDescriptor) : this.createGrailsPlugin(pluginClass);
            plugin.setApplicationContext(this.applicationContext);
            grailsCorePlugins.add(plugin);
        }
        return grailsCorePlugins;
    }

    private GrailsPlugin createBinaryGrailsPlugin(Class<?> pluginClass, BinaryGrailsPluginDescriptor binaryDescriptor) {
        return new BinaryGrailsPlugin(pluginClass, binaryDescriptor, this.application);
    }

    protected GrailsPlugin createGrailsPlugin(Class<?> pluginClass) {
        return new DefaultGrailsPlugin(pluginClass, this.application);
    }

    protected GrailsPlugin createGrailsPlugin(Class<?> pluginClass, Resource resource) {
        return new DefaultGrailsPlugin(pluginClass, resource, this.application);
    }

    private List<GrailsPlugin> findUserPlugins(ClassLoader gcl) {
        ArrayList<GrailsPlugin> grailsUserPlugins = new ArrayList<GrailsPlugin>();
        LOG.info((Object)("Attempting to load [" + this.pluginResources.length + "] user defined plugins"));
        for (Resource resource : this.pluginResources) {
            Class<?> pluginClass = this.loadPluginClass(gcl, resource);
            if (this.isGrailsPlugin(pluginClass)) {
                GrailsPlugin plugin = this.createGrailsPlugin(pluginClass, resource);
                grailsUserPlugins.add(plugin);
                continue;
            }
            LOG.warn((Object)("Class [" + pluginClass + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!"));
        }
        for (Class clazz : this.pluginClasses) {
            if (this.isGrailsPlugin(clazz)) {
                GrailsPlugin plugin = this.createGrailsPlugin(clazz);
                grailsUserPlugins.add(plugin);
                continue;
            }
            LOG.warn((Object)("Class [" + clazz + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!"));
        }
        return grailsUserPlugins;
    }

    private boolean isGrailsPlugin(Class<?> pluginClass) {
        return pluginClass != null && pluginClass.getName().endsWith(GRAILS_PLUGIN_SUFFIX);
    }

    private void processDelayedEvictions() {
        for (Map.Entry<GrailsPlugin, String[]> entry : this.delayedEvictions.entrySet()) {
            GrailsPlugin plugin = entry.getKey();
            for (String pluginName : entry.getValue()) {
                this.evictPlugin(plugin, pluginName);
            }
        }
    }

    private void initializePlugins() {
        for (GrailsPlugin plugin : this.plugins.values()) {
            if (!(plugin instanceof ApplicationContextAware)) continue;
            ((ApplicationContextAware)plugin).setApplicationContext(this.applicationContext);
        }
    }

    private void loadDelayedPlugins() {
        while (!this.delayedLoadPlugins.isEmpty()) {
            GrailsPlugin plugin = this.delayedLoadPlugins.remove(0);
            if (this.areDependenciesResolved(plugin)) {
                if (!this.hasValidPluginsToLoadBefore(plugin)) {
                    this.registerPlugin(plugin);
                    continue;
                }
                this.delayedLoadPlugins.add(plugin);
                continue;
            }
            boolean foundInDelayed = false;
            for (GrailsPlugin remainingPlugin : this.delayedLoadPlugins) {
                if (!this.isDependentOn(plugin, remainingPlugin)) continue;
                foundInDelayed = true;
                break;
            }
            if (foundInDelayed) {
                this.delayedLoadPlugins.add(plugin);
                continue;
            }
            this.failedPlugins.put(plugin.getName(), plugin);
            LOG.warn((Object)("WARNING: Plugin [" + plugin.getName() + "] cannot be loaded because its dependencies [" + ArrayUtils.toString((Object)plugin.getDependencyNames()) + "] cannot be resolved"));
        }
    }

    private boolean hasValidPluginsToLoadBefore(GrailsPlugin plugin) {
        String[] loadAfterNames = plugin.getLoadAfterNames();
        Iterator<GrailsPlugin> i$ = this.delayedLoadPlugins.iterator();
        while (i$.hasNext()) {
            GrailsPlugin delayedLoadPlugin;
            GrailsPlugin other = delayedLoadPlugin = i$.next();
            for (String name : loadAfterNames) {
                if (!other.getName().equals(name)) continue;
                return this.hasDelayedDependencies(other) || this.areDependenciesResolved(other);
            }
        }
        return false;
    }

    private boolean hasDelayedDependencies(GrailsPlugin other) {
        String[] dependencyNames;
        for (String dependencyName : dependencyNames = other.getDependencyNames()) {
            for (GrailsPlugin grailsPlugin : this.delayedLoadPlugins) {
                if (!grailsPlugin.getName().equals(dependencyName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDependentOn(GrailsPlugin plugin, GrailsPlugin dependency) {
        for (String name : plugin.getDependencyNames()) {
            String requiredVersion = plugin.getDependentVersion(name);
            if (!name.equals(dependency.getName()) || !GrailsPluginUtils.isValidVersion((String)dependency.getVersion(), (String)requiredVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean areDependenciesResolved(GrailsPlugin plugin) {
        for (String name : plugin.getDependencyNames()) {
            if (this.hasGrailsPlugin(name, plugin.getDependentVersion(name))) continue;
            return false;
        }
        return true;
    }

    private boolean areNoneToLoadBefore(GrailsPlugin plugin) {
        for (String name : plugin.getLoadAfterNames()) {
            if (this.getGrailsPlugin(name) != null) continue;
            return false;
        }
        return true;
    }

    private Class<?> loadPluginClass(ClassLoader cl, Resource r) {
        Class<?> pluginClass;
        if (cl instanceof GroovyClassLoader) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Parsing & compiling " + r.getFilename()));
                }
                pluginClass = ((GroovyClassLoader)cl).parseClass(IOGroovyMethods.getText((InputStream)r.getInputStream()));
            }
            catch (CompilationFailedException e) {
                throw new PluginException("Error compiling plugin [" + r.getFilename() + "] " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new PluginException("Error reading plugin [" + r.getFilename() + "] " + e.getMessage(), (Throwable)e);
            }
        }
        String className = null;
        try {
            className = GrailsResourceUtils.getClassName((String)r.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new PluginException("Cannot find plugin class [" + className + "] resource: [" + r.getFilename() + "]", (Throwable)e);
        }
        try {
            pluginClass = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Cannot find plugin class [" + className + "] resource: [" + r.getFilename() + "]", (Throwable)e);
        }
        return pluginClass;
    }

    private void attemptPluginLoad(GrailsPlugin plugin) {
        if (this.areDependenciesResolved(plugin) && this.areNoneToLoadBefore(plugin)) {
            this.registerPlugin(plugin);
        } else {
            this.delayedLoadPlugins.add(plugin);
        }
    }

    private void registerPlugin(GrailsPlugin plugin) {
        String[] observedPlugins;
        if (!this.canRegisterPlugin(plugin)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Grails plugin " + plugin + " is disabled and was not loaded"));
            }
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Grails plug-in [" + plugin.getName() + "] with version [" + plugin.getVersion() + "] loaded successfully"));
        }
        if (plugin instanceof ParentApplicationContextAware) {
            ((ParentApplicationContextAware)((Object)plugin)).setParentApplicationContext(this.parentCtx);
        }
        plugin.setManager(this);
        String[] evictionNames = plugin.getEvictionNames();
        if (evictionNames.length > 0) {
            this.delayedEvictions.put(plugin, evictionNames);
        }
        for (String observedPlugin : observedPlugins = plugin.getObservedPluginNames()) {
            Set<GrailsPlugin> observers = this.pluginToObserverMap.get(observedPlugin);
            if (observers == null) {
                observers = new HashSet<GrailsPlugin>();
                this.pluginToObserverMap.put(observedPlugin, observers);
            }
            observers.add(plugin);
        }
        this.pluginList.add(plugin);
        this.plugins.put(plugin.getName(), plugin);
        this.classNameToPluginMap.put(plugin.getPluginClass().getName(), plugin);
    }

    protected boolean canRegisterPlugin(GrailsPlugin plugin) {
        Environment environment = Environment.getCurrent();
        return plugin.isEnabled() && plugin.supportsEnvironment(environment);
    }

    protected void evictPlugin(GrailsPlugin evictor, String evicteeName) {
        GrailsPlugin pluginToEvict = (GrailsPlugin)this.plugins.get(evicteeName);
        if (pluginToEvict != null) {
            this.pluginList.remove(pluginToEvict);
            this.plugins.remove(pluginToEvict.getName());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Grails plug-in " + pluginToEvict + " was evicted by " + evictor));
            }
        }
    }

    private boolean hasGrailsPlugin(String name, String version) {
        return this.getGrailsPlugin(name, version) != null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        for (GrailsPlugin plugin : this.pluginList) {
            plugin.setApplicationContext(applicationContext);
        }
    }

    public void setParentApplicationContext(ApplicationContext parent) {
        this.parentCtx = parent;
    }

    @Override
    @Deprecated
    public void checkForChanges() {
    }

    public void reloadPlugin(GrailsPlugin plugin) {
        plugin.doArtefactConfiguration();
        WebRuntimeSpringConfiguration springConfig = new WebRuntimeSpringConfiguration(this.parentCtx);
        springConfig.setServletContext(this.getServletContext());
        this.doRuntimeConfiguration(plugin.getName(), (RuntimeSpringConfiguration)springConfig);
        springConfig.registerBeansWithContext((GenericApplicationContext)this.applicationContext);
        plugin.doWithApplicationContext(this.applicationContext);
        plugin.doWithDynamicMethods(this.applicationContext);
    }

    @Override
    public void doWebDescriptor(Resource descriptor, Writer target) {
        try {
            this.doWebDescriptor(descriptor.getInputStream(), target);
        }
        catch (IOException e) {
            throw new PluginException("Unable to read web.xml [" + descriptor + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private void doWebDescriptor(InputStream inputStream, Writer target) {
        this.checkInitialised();
        try {
            Document document = DOMBuilder.parse((Reader)new InputStreamReader(inputStream));
            Element documentElement = document.getDocumentElement();
            for (GrailsPlugin plugin : this.pluginList) {
                if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
                plugin.doWithWebDescriptor(documentElement);
            }
            boolean areServlet3JarsPresent = ClassUtils.isPresent((String)"javax.servlet.AsyncContext", (ClassLoader)Thread.currentThread().getContextClassLoader());
            String servletVersion = this.application.getMetadata().getServletVersion();
            if (areServlet3JarsPresent && GrailsVersionUtils.supportsAtLeastVersion((String)servletVersion, (String)"3.0")) {
                new Servlet3AsyncWebXmlProcessor().process(documentElement);
            }
            this.writeWebDescriptorResult(documentElement, target);
        }
        catch (ParserConfigurationException e) {
            throw new PluginException("Unable to configure web.xml due to parser configuration problem: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new PluginException("XML parsing error configuring web.xml: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException("Unable to read web.xml" + e.getMessage(), (Throwable)e);
        }
    }

    private void writeWebDescriptorResult(Element result, Writer output) throws IOException {
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(result), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new IOException("Error transforming web.xml: " + e.getMessage(), e);
        }
    }

    @Override
    public void doWebDescriptor(File descriptor, Writer target) {
        try {
            this.doWebDescriptor(new FileInputStream(descriptor), target);
        }
        catch (FileNotFoundException e) {
            throw new PluginException("Unable to read web.xml [" + descriptor + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setApplication(GrailsApplication application) {
        Assert.notNull((Object)application, (String)"Argument [application] cannot be null");
        this.application = application;
        for (GrailsPlugin plugin : this.pluginList) {
            plugin.setApplication(application);
        }
    }

    @Override
    public void doDynamicMethods() {
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class<?> COMMON_CLASS : COMMON_CLASSES) {
            registry.removeMetaClass(COMMON_CLASS);
        }
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            try {
                plugin.doWithDynamicMethods(this.applicationContext);
            }
            catch (Throwable t) {
                LOG.error((Object)("Error configuring dynamic methods for plugin " + plugin + ": " + t.getMessage()), t);
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    void setPluginFilter(PluginFilter pluginFilter) {
        this.pluginFilter = pluginFilter;
    }

    private PluginFilter getPluginFilter() {
        if (this.pluginFilter == null) {
            this.pluginFilter = new IdentityPluginFilter();
        }
        return this.pluginFilter;
    }

    List<GrailsPlugin> getPluginList() {
        return Collections.unmodifiableList(this.pluginList);
    }
}

