/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingState;

public class EncodingStateImpl
implements EncodingState {
    public static final EncodingState UNDEFINED_ENCODING_STATE = new EncodingStateImpl((Set<Encoder>)null);
    private final Set<Encoder> encoders;

    public EncodingStateImpl(Set<Encoder> encoders) {
        this.encoders = encoders;
    }

    public EncodingStateImpl(Encoder encoder) {
        this.encoders = Collections.singleton(encoder);
    }

    @Override
    public Set<Encoder> getEncoders() {
        return this.encoders;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encoders == null ? 0 : ((Object)this.encoders).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncodingStateImpl other = (EncodingStateImpl)obj;
        return !(this.encoders == null ? other.encoders != null && other.encoders.size() > 0 : !((Object)this.encoders).equals(other.encoders));
    }

    @Override
    public EncodingState appendEncoder(Encoder encoder) {
        Set<Encoder> newEncoders;
        if (encoder == null) {
            return this;
        }
        if (this.encoders == null || this.encoders.size() == 0) {
            newEncoders = Collections.singleton(encoder);
        } else {
            if (this.encoders.size() == 1 && this.encoders.contains(encoder)) {
                return this;
            }
            newEncoders = new LinkedHashSet<Encoder>();
            newEncoders.addAll(this.encoders);
            newEncoders.add(encoder);
        }
        return new EncodingStateImpl(newEncoders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EncodingStateImpl");
        if (this.encoders != null && this.encoders.size() > 0) {
            sb.append(" [encoders=");
            boolean first = true;
            for (Encoder encoder : this.encoders) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append("[@");
                sb.append(System.identityHashCode(encoder));
                sb.append(" ");
                sb.append(encoder.getCodecIdentifier().getCodecName() + " safe:" + encoder.isSafe() + " apply to safe:" + encoder.isApplyToSafelyEncoded());
                sb.append("]");
            }
            sb.append("]");
        } else {
            sb.append("[no encoders]");
        }
        return sb.toString();
    }
}

