/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncoderAware;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;

public class EncodedAppenderWriter
extends Writer
implements EncodedAppenderWriterFactory,
EncodedAppenderFactory,
EncoderAware {
    protected EncodedAppender encodedAppender;
    protected Encoder encoder;
    protected EncodingStateRegistry encodingStateRegistry;

    public EncodedAppenderWriter(EncodedAppender encodedAppender, Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        this.encodedAppender = encodedAppender;
        this.encoder = encoder;
        this.encodingStateRegistry = encodingStateRegistry;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encodedAppender.append(this.encoder, null, cbuf, off, len);
    }

    public void flush() throws IOException {
        this.encodedAppender.flush();
    }

    public void close() throws IOException {
        this.encodedAppender.close();
    }

    public void write(int c) throws IOException {
        this.encodedAppender.append(this.encoder, (char)c);
    }

    public void write(String str, int off, int len) throws IOException {
        this.encodedAppender.append(this.encoder, this.encodingStateRegistry != null && off == 0 && len == str.length() ? this.encodingStateRegistry.getEncodingStateFor(str) : null, str, off, len);
    }

    public Writer append(CharSequence csq) throws IOException {
        this.encodedAppender.append(this.encoder, this.encodingStateRegistry != null ? this.encodingStateRegistry.getEncodingStateFor(csq) : null, csq, 0, csq.length());
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.encodedAppender.append(this.encoder, null, csq, 0, end - start);
        return this;
    }

    public Writer append(char c) throws IOException {
        this.encodedAppender.append(this.encoder, c);
        return this;
    }

    public EncodedAppender getEncodedAppender() {
        return this.encodedAppender;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        return new EncodedAppenderWriter(this.encodedAppender, encoder, encodingStateRegistry);
    }
}

