/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.jndi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.grails.cli.jndi.JndiBindingHandler;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.mock.jndi.SimpleNamingContextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiBindingSupport {
    private static Map<String, JndiBindingHandler> jndiBinders = new HashMap<String, JndiBindingHandler>();
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final Object TYPE;
    private Map<String, Object> jndiConfig;

    public JndiBindingSupport(Map<String, Object> jndiConfig) {
        this.jndiConfig = jndiConfig;
    }

    public static void registerJndiBindingHandler(JndiBindingHandler handler) {
        if (handler != null && handler.getType() != null) {
            jndiBinders.put(handler.getType(), handler);
        }
    }

    Object bind() {
        SimpleNamingContextBuilder builder = new SimpleNamingContextBuilder();
        if (this.jndiConfig != null) {
            System.setProperty("javax.sql.DataSource.Factory", "org.apache.tomcat.jdbc.pool.DataSourceFactory");
            Iterator<Map.Entry<String, Object>> i$ = this.jndiConfig.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Object> o;
                Map.Entry<String, Object> entry = o = i$.next();
                Object propsObj = entry.getValue();
                String entryName = entry.getKey().toString();
                if (propsObj instanceof Map) {
                    Map props = (Map)propsObj;
                    Object typeObj = props.get(TYPE);
                    if (typeObj == null) continue;
                    props.remove(TYPE);
                    String type = typeObj.toString();
                    JndiBindingHandler handler = jndiBinders.get(type);
                    if (handler != null) {
                        handler.handleBinding(builder, entryName, props);
                        continue;
                    }
                    try {
                        Class<?> c = Class.forName(type, true, Thread.currentThread().getContextClassLoader());
                        Object beanObj = BeanUtils.instantiate(c);
                        JndiBindingSupport.bindProperties(beanObj, props);
                        builder.bind(entryName, beanObj);
                    }
                    catch (BeanInstantiationException e) {
                    }
                    catch (ClassNotFoundException e) {}
                    continue;
                }
                builder.bind(entryName, propsObj);
            }
        }
        try {
            builder.activate();
            return builder.createInitialContextFactory(null).getInitialContext(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void bindProperties(Object obj, Map entryProperties) {
        BeanWrapperImpl dsBean = new BeanWrapperImpl(obj);
        for (Map.Entry o : entryProperties.entrySet()) {
            Map.Entry entry2 = o;
            String propertyName = entry2.getKey().toString();
            if (!dsBean.isWritableProperty(propertyName)) continue;
            dsBean.setPropertyValue(propertyName, entry2.getValue());
        }
    }

    static {
        DataSourceBinder dsBinder = new DataSourceBinder();
        jndiBinders.put(dsBinder.getType(), dsBinder);
        TYPE = "type";
    }

    static class DataSourceBinder
    implements JndiBindingHandler {
        DataSourceBinder() {
        }

        public String getType() {
            return JndiBindingSupport.DATA_SOURCE;
        }

        public void handleBinding(SimpleNamingContextBuilder builder, String entryName, Map entryProperties) {
            try {
                Object ds = BeanUtils.instantiate(Class.forName("org.apache.tomcat.jdbc.pool.DataSource", true, Thread.currentThread().getContextClassLoader()));
                JndiBindingSupport.bindProperties(ds, entryProperties);
                builder.bind(entryName, ds);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

