/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.ComponentCapableDomainClass;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.exceptions.InvalidPropertyException;
import org.codehaus.groovy.grails.validation.ConstraintsEvaluator;
import org.codehaus.groovy.grails.validation.DefaultConstraintEvaluator;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsDomainClass
extends AbstractGrailsClass
implements GrailsDomainClass,
ComponentCapableDomainClass {
    private GrailsDomainClassProperty identifier;
    private GrailsDomainClassProperty version;
    private GrailsDomainClassProperty[] properties;
    private GrailsDomainClassProperty[] persistentProperties;
    private Map<String, GrailsDomainClassProperty> propertyMap;
    private Map relationshipMap;
    private Map hasOneMap;
    private Map constraints;
    private Map mappedBy;
    private Validator validator;
    private String mappingStrategy = "GORM";
    private List<Class<?>> owners = new ArrayList();
    private boolean root = true;
    private Set subClasses = new HashSet();
    private Collection<String> embedded;
    private Map<String, Object> defaultConstraints;
    private List<GrailsDomainClass> components = new ArrayList<GrailsDomainClass>();
    private List<GrailsDomainClassProperty> associations = new ArrayList<GrailsDomainClassProperty>();

    public DefaultGrailsDomainClass(Class<?> clazz, Map<String, Object> defaultConstraints) {
        super(clazz, "");
        PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
        Class<?> superClass = clazz.getSuperclass();
        if (DomainClassArtefactHandler.isDomainClass(superClass)) {
            this.root = false;
        }
        this.propertyMap = new LinkedHashMap<String, GrailsDomainClassProperty>();
        this.relationshipMap = this.getAssociationMap();
        this.embedded = this.getEmbeddedList();
        this.defaultConstraints = defaultConstraints;
        this.mappingStrategy = this.getStaticPropertyValue("mapWith", String.class);
        if (this.mappingStrategy == null) {
            this.mappingStrategy = "GORM";
        }
        this.mappedBy = this.getMergedConfigurationMap("mappedBy");
        this.hasOneMap = this.getMergedConfigurationMap("hasOne");
        if (this.hasOneMap == null) {
            this.hasOneMap = Collections.emptyMap();
        }
        if (this.mappedBy == null) {
            this.mappedBy = Collections.emptyMap();
        }
        this.establishRelationshipOwners();
        this.populateDomainClassProperties(propertyDescriptors);
        if (this.identifier == null) {
            throw new GrailsDomainException("Identity property not found, but required in domain class [" + this.getFullName() + "]");
        }
        if (this.version == null) {
            throw new GrailsDomainException("Version property not found, but required in domain class [" + this.getFullName() + "]");
        }
        this.properties = this.propertyMap.values().toArray(new GrailsDomainClassProperty[this.propertyMap.size()]);
        this.establishRelationships();
        this.establishPersistentProperties();
    }

    public DefaultGrailsDomainClass(Class<?> clazz) {
        this(clazz, (Map<String, Object>)null);
    }

    @Override
    public boolean hasSubClasses() {
        return !this.getSubClasses().isEmpty();
    }

    private void establishPersistentProperties() {
        ArrayList<GrailsDomainClassProperty> tempList = new ArrayList<GrailsDomainClassProperty>();
        for (GrailsDomainClassProperty o : this.propertyMap.values()) {
            GrailsDomainClassProperty currentProp = o;
            if (currentProp.getType() == Object.class || !currentProp.isPersistent() || currentProp.isIdentity() || currentProp.getName().equals("version")) continue;
            tempList.add(currentProp);
        }
        this.persistentProperties = tempList.toArray(new GrailsDomainClassProperty[tempList.size()]);
    }

    private void establishRelationshipOwners() {
        Class belongsTo = this.getStaticPropertyValue("belongsTo", Class.class);
        if (belongsTo == null) {
            List ownersProp = this.getStaticPropertyValue("belongsTo", List.class);
            if (ownersProp != null) {
                this.owners = ownersProp;
            } else {
                Map ownersMap = this.getStaticPropertyValue("belongsTo", Map.class);
                if (ownersMap != null) {
                    this.owners = new ArrayList(ownersMap.values());
                }
            }
        } else {
            this.owners = new ArrayList();
            this.owners.add(belongsTo);
        }
    }

    private void populateDomainClassProperties(PropertyDescriptor[] propertyDescriptors) {
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getPropertyType() == null || !GrailsDomainConfigurationUtil.isNotConfigurational(descriptor)) continue;
            DefaultGrailsDomainClassProperty property = new DefaultGrailsDomainClassProperty(this, descriptor, this.defaultConstraints);
            this.propertyMap.put(property.getName(), property);
            if (property.isIdentity()) {
                this.identifier = property;
                continue;
            }
            if (!property.getName().equals("version")) continue;
            this.version = property;
        }
    }

    @Override
    public Map getAssociationMap() {
        if (this.relationshipMap == null) {
            this.relationshipMap = this.getMergedConfigurationMap("hasMany");
        }
        return this.relationshipMap;
    }

    private Map getMergedConfigurationMap(String propertyName) {
        HashMap configurationMap = this.getStaticPropertyValue(propertyName, Map.class);
        if (configurationMap == null) {
            configurationMap = new HashMap();
        }
        Class<?> theClass = this.getClazz();
        while (theClass != Object.class) {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(theClass = theClass.getSuperclass());
            Map superRelationshipMap = propertyFetcher.getStaticPropertyValue(propertyName, Map.class);
            if (superRelationshipMap == null || ((Object)superRelationshipMap).equals(configurationMap)) continue;
            configurationMap.putAll(superRelationshipMap);
        }
        return configurationMap;
    }

    private Collection<String> getEmbeddedList() {
        Collection potentialList = this.getStaticPropertyValue("embedded", Collection.class);
        if (potentialList != null) {
            return potentialList;
        }
        return Collections.emptyList();
    }

    private void establishRelationships() {
        for (GrailsDomainClassProperty o : this.propertyMap.values()) {
            Class currentPropType;
            DefaultGrailsDomainClassProperty currentProp = (DefaultGrailsDomainClassProperty)o;
            if (!currentProp.isPersistent() || (currentPropType = currentProp.getType()) == null) continue;
            if (Collection.class.isAssignableFrom(currentPropType) || Map.class.isAssignableFrom(currentPropType)) {
                this.establishRelationshipForCollection(currentProp);
                continue;
            }
            if (DomainClassArtefactHandler.isDomainClass(currentPropType) && currentProp.isPersistent()) {
                this.associations.add(currentProp);
                this.establishDomainClassRelationship(currentProp);
                continue;
            }
            if (!this.embedded.contains(currentProp.getName())) continue;
            this.associations.add(currentProp);
            this.establishDomainClassRelationship(currentProp);
        }
    }

    private void establishRelationshipForCollection(DefaultGrailsDomainClassProperty property) {
        Class<?> relatedClassType = this.getRelatedClassType(property.getName());
        if (relatedClassType != null) {
            this.associations.add(property);
            property.setReferencedPropertyType(relatedClassType);
            if (DomainClassArtefactHandler.isDomainClass(relatedClassType)) {
                Map<?, ?> relatedClassRelationships = GrailsDomainConfigurationUtil.getAssociationMap(relatedClassType);
                Class<?> relatedClassPropertyType = null;
                String mappingProperty = (String)this.mappedBy.get(property.getName());
                if (!StringUtils.isBlank((String)mappingProperty)) {
                    PropertyDescriptor pd = this.findProperty(GrailsClassUtils.getPropertiesOfType(relatedClassType, this.getClazz()), mappingProperty);
                    if (pd == null) {
                        pd = this.findProperty(GrailsClassUtils.getPropertiesAssignableToType(relatedClassType, Collection.class), mappingProperty);
                    }
                    boolean isNone = "none".equals(mappingProperty);
                    if (pd == null && !isNone) {
                        throw new GrailsDomainException("Non-existent mapping property [" + mappingProperty + "] specified for property [" + property.getName() + "] in class [" + this.getClazz() + "]");
                    }
                    if (pd != null) {
                        relatedClassPropertyType = pd.getPropertyType();
                        property.setReferencePropertyName(pd.getName());
                    }
                } else {
                    if (this.mappedBy.containsKey(property.getName()) && this.mappedBy.get(property.getName()) == null) {
                        return;
                    }
                    if (this.isRelationshipManyToMany(property, relatedClassType, relatedClassRelationships)) {
                        String relatedClassPropertyName = null;
                        Map<?, ?> relatedClassMappedBy = GrailsDomainConfigurationUtil.getMappedByMap(relatedClassType);
                        for (Object o : relatedClassRelationships.keySet()) {
                            Class currentClass;
                            String currentKey = (String)o;
                            String mappedByProperty = (String)relatedClassMappedBy.get(currentKey);
                            if (mappedByProperty != null && !mappedByProperty.equals(property.getName()) || !(currentClass = (Class)relatedClassRelationships.get(currentKey)).isAssignableFrom(this.getClazz())) continue;
                            relatedClassPropertyName = currentKey;
                            break;
                        }
                        if (relatedClassPropertyName != null) {
                            relatedClassPropertyType = GrailsClassUtils.getPropertyType(relatedClassType, relatedClassPropertyName);
                        }
                    }
                    if (relatedClassPropertyType == null) {
                        PropertyDescriptor[] descriptors = GrailsClassUtils.getPropertiesOfType(relatedClassType, this.getClazz());
                        if (descriptors.length == 1) {
                            relatedClassPropertyType = descriptors[0].getPropertyType();
                            property.setReferencePropertyName(descriptors[0].getName());
                        } else if (descriptors.length > 1) {
                            String classPropertyName = this.getPropertyName();
                            PropertyDescriptor pd = this.findProperty(descriptors, classPropertyName);
                            if (pd == null) {
                                throw new GrailsDomainException("Property [" + property.getName() + "] in class [" + this.getClazz() + "] is a bidirectional one-to-many with two possible properties on the inverse side. " + "Either name one of the properties on other side of the relationship [" + classPropertyName + "] or use the 'mappedBy' static to define the property " + "that the relationship is mapped with. Example: static mappedBy = [" + property.getName() + ":'myprop']");
                            }
                            relatedClassPropertyType = pd.getPropertyType();
                            property.setReferencePropertyName(pd.getName());
                        }
                    }
                }
                this.establishRelationshipForSetToType(property, relatedClassPropertyType);
                if (property.isManyToMany()) {
                    this.establishOwnerOfManyToMany(property, relatedClassType);
                }
            } else {
                property.setBasicCollectionType(true);
            }
        } else if (!Map.class.isAssignableFrom(property.getType())) {
            property.setPersistent(false);
        }
    }

    private PropertyDescriptor findProperty(PropertyDescriptor[] descriptors, String propertyName) {
        PropertyDescriptor d = null;
        for (PropertyDescriptor descriptor : descriptors) {
            if (!descriptor.getName().equals(propertyName)) continue;
            d = descriptor;
            break;
        }
        return d;
    }

    private boolean isRelationshipManyToMany(DefaultGrailsDomainClassProperty property, Class<?> relatedClassType, Map relatedClassRelationships) {
        return relatedClassRelationships != null && !relatedClassRelationships.isEmpty() && !relatedClassType.equals(property.getDomainClass().getClazz());
    }

    private void establishOwnerOfManyToMany(DefaultGrailsDomainClassProperty property, Class<?> relatedClassType) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(relatedClassType);
        Object relatedBelongsTo = cpf.getPropertyValue("belongsTo");
        boolean owningSide = false;
        boolean relatedOwner = this.isOwningSide(relatedClassType, this.owners);
        Class propertyClass = property.getDomainClass().getClazz();
        if (relatedBelongsTo instanceof Collection) {
            Collection associatedOwners = (Collection)relatedBelongsTo;
            owningSide = this.isOwningSide(propertyClass, associatedOwners);
        } else if (relatedBelongsTo instanceof Class) {
            ArrayList associatedOwners = new ArrayList();
            associatedOwners.add((Class<?>)relatedBelongsTo);
            owningSide = this.isOwningSide(propertyClass, associatedOwners);
        }
        property.setOwningSide(owningSide);
        if (relatedOwner && property.isOwningSide()) {
            throw new GrailsDomainException("Domain classes [" + propertyClass + "] and [" + relatedClassType + "] cannot own each other in a many-to-many relationship. Both contain belongsTo definitions that reference each other.");
        }
        if (!(relatedOwner || property.isOwningSide() || property.isCircular() && property.isManyToMany())) {
            throw new GrailsDomainException("No owner defined between domain classes [" + propertyClass + "] and [" + relatedClassType + "] in a many-to-many relationship. Example: static belongsTo = " + relatedClassType.getName());
        }
    }

    private boolean isOwningSide(Class<?> relatedClassType, Collection<Class<?>> potentialOwners) {
        boolean relatedOwner = false;
        for (Class<?> relatedClass : potentialOwners) {
            if (!relatedClass.isAssignableFrom(relatedClassType)) continue;
            relatedOwner = true;
            break;
        }
        return relatedOwner;
    }

    private void establishRelationshipForSetToType(DefaultGrailsDomainClassProperty property, Class<?> relatedClassPropertyType) {
        if (relatedClassPropertyType == null) {
            property.setOneToMany(true);
            property.setBidirectional(false);
        } else if (Collection.class.isAssignableFrom(relatedClassPropertyType) || Map.class.isAssignableFrom(relatedClassPropertyType)) {
            property.setManyToMany(true);
            property.setBidirectional(true);
        } else if (DomainClassArtefactHandler.isDomainClass(relatedClassPropertyType)) {
            property.setOneToMany(true);
            property.setBidirectional(true);
        }
    }

    private void establishDomainClassRelationship(DefaultGrailsDomainClassProperty property) {
        PropertyDescriptor[] descriptors;
        Class propType = property.getType();
        if (this.embedded.contains(property.getName())) {
            property.setEmbedded(true);
            return;
        }
        Map<?, ?> relatedClassRelationships = GrailsDomainConfigurationUtil.getAssociationMap(propType);
        Map<?, ?> mappedBy = GrailsDomainConfigurationUtil.getMappedByMap(propType);
        Class<?> relatedClassPropertyType = null;
        if (mappedBy.containsKey(property.getName()) && mappedBy.get(property.getName()) == null) {
            return;
        }
        if (relatedClassRelationships != null && !relatedClassRelationships.isEmpty()) {
            String relatedClassPropertyName = this.findOneToManyThatMatchesType(property, relatedClassRelationships);
            PropertyDescriptor[] descriptors2 = GrailsClassUtils.getPropertiesOfType(this.getClazz(), property.getType());
            if (descriptors2.length == 1 && this.isNotMappedToDifferentProperty(property, relatedClassPropertyName, mappedBy)) {
                if (!StringUtils.isBlank((String)relatedClassPropertyName)) {
                    property.setReferencePropertyName(relatedClassPropertyName);
                    relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, relatedClassPropertyName);
                }
            } else if (descriptors2.length > 1) {
                if (mappedBy.containsValue(property.getName())) {
                    for (Object o : mappedBy.keySet()) {
                        Class mappedByRelatedType;
                        String mappedByPropertyName = (String)o;
                        if (!property.getName().equals(mappedBy.get(mappedByPropertyName)) || (mappedByRelatedType = (Class)relatedClassRelationships.get(mappedByPropertyName)) == null || !propType.isAssignableFrom(mappedByRelatedType)) continue;
                        relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, mappedByPropertyName);
                    }
                } else {
                    String classNameAsProperty = GrailsNameUtils.getPropertyName((Class)propType);
                    if (property.getName().equals(classNameAsProperty) && !mappedBy.containsKey(relatedClassPropertyName)) {
                        relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, relatedClassPropertyName);
                    }
                }
            }
        }
        if (relatedClassPropertyType == null && (descriptors = GrailsClassUtils.getPropertiesOfType(propType, this.getClazz())).length == 1) {
            relatedClassPropertyType = descriptors[0].getPropertyType();
        }
        this.establishDomainClassRelationshipToType(property, relatedClassPropertyType);
    }

    private boolean isNotMappedToDifferentProperty(GrailsDomainClassProperty property, String relatedClassPropertyName, Map mappedBy) {
        String mappedByForRelation = (String)mappedBy.get(relatedClassPropertyName);
        if (mappedByForRelation == null) {
            return true;
        }
        return property.getName().equals(mappedByForRelation);
    }

    private String findOneToManyThatMatchesType(DefaultGrailsDomainClassProperty property, Map relatedClassRelationships) {
        String relatedClassPropertyName = null;
        for (Object o : relatedClassRelationships.keySet()) {
            String currentKey = (String)o;
            Class currentClass = (Class)relatedClassRelationships.get(currentKey);
            if (!property.getDomainClass().getClazz().getName().equals(currentClass.getName())) continue;
            relatedClassPropertyName = currentKey;
            break;
        }
        return relatedClassPropertyName;
    }

    private void establishDomainClassRelationshipToType(DefaultGrailsDomainClassProperty property, Class<?> relatedClassPropertyType) {
        if (relatedClassPropertyType == null) {
            if (this.hasOneMap.containsKey(property.getName())) {
                property.setHasOne(true);
            }
            property.setOneToOne(true);
            property.setBidirectional(false);
        } else if (Collection.class.isAssignableFrom(relatedClassPropertyType) || Map.class.isAssignableFrom(relatedClassPropertyType)) {
            property.setManyToOne(true);
            property.setBidirectional(true);
        } else if (DomainClassArtefactHandler.isDomainClass(relatedClassPropertyType)) {
            if (this.hasOneMap.containsKey(property.getName())) {
                property.setHasOne(true);
            }
            property.setOneToOne(true);
            if (!this.getClazz().equals(relatedClassPropertyType)) {
                property.setBidirectional(true);
            }
        }
    }

    @Override
    public boolean isOwningClass(Class domainClass) {
        return this.owners.contains(domainClass);
    }

    @Override
    public GrailsDomainClassProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public GrailsDomainClassProperty getIdentifier() {
        return this.identifier;
    }

    @Override
    public GrailsDomainClassProperty getVersion() {
        return this.version;
    }

    @Override
    @Deprecated
    public GrailsDomainClassProperty[] getPersistantProperties() {
        return this.persistentProperties;
    }

    @Override
    public GrailsDomainClassProperty[] getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public GrailsDomainClassProperty getPropertyByName(String name) {
        GrailsDomainClassProperty persistentProperty = this.getPersistentProperty(name);
        if (persistentProperty == null) {
            throw new InvalidPropertyException("No property found for name [" + name + "] for class [" + this.getClazz() + "]");
        }
        return persistentProperty;
    }

    @Override
    public GrailsDomainClassProperty getPersistentProperty(String name) {
        GrailsDomainClassProperty prop;
        GrailsDomainClass referencedDomainClass;
        String basePropertyName;
        if (this.propertyMap.containsKey(name)) {
            return this.propertyMap.get(name);
        }
        int indexOfDot = name.indexOf(46);
        if (indexOfDot > 0 && this.propertyMap.containsKey(basePropertyName = name.substring(0, indexOfDot)) && (referencedDomainClass = (prop = this.propertyMap.get(basePropertyName)).getReferencedDomainClass()) != null) {
            String restOfPropertyName = name.substring(indexOfDot + 1);
            return referencedDomainClass.getPropertyByName(restOfPropertyName);
        }
        return null;
    }

    @Override
    public String getFieldName(String propertyName) {
        return this.getPropertyByName(propertyName).getFieldName();
    }

    @Override
    public String getName() {
        return ClassUtils.getShortClassName((String)super.getName());
    }

    @Override
    public boolean isOneToMany(String propertyName) {
        return this.getPropertyByName(propertyName).isOneToMany();
    }

    @Override
    public boolean isManyToOne(String propertyName) {
        return this.getPropertyByName(propertyName).isManyToOne();
    }

    @Override
    public Class<?> getRelatedClassType(String propertyName) {
        return (Class)this.relationshipMap.get(propertyName);
    }

    @Override
    public String getPropertyName() {
        return GrailsNameUtils.getPropertyNameRepresentation(this.getClazz());
    }

    @Override
    public boolean isBidirectional(String propertyName) {
        return this.getPropertyByName(propertyName).isBidirectional();
    }

    @Override
    public Map getConstrainedProperties() {
        if (this.constraints == null) {
            this.initializeConstraints();
        }
        return Collections.unmodifiableMap(this.constraints);
    }

    private void initializeConstraints() {
        ConstraintsEvaluator constraintsEvaluator = this.getConstraintsEvaluator();
        this.constraints = constraintsEvaluator.evaluate(this.getClazz(), this.persistentProperties);
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public String getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    public Set getSubClasses() {
        return this.subClasses;
    }

    @Override
    public void refreshConstraints() {
        ConstraintsEvaluator constraintEvaluator = this.getConstraintsEvaluator();
        this.constraints = this.defaultConstraints != null ? constraintEvaluator.evaluate(this.getClazz(), this.persistentProperties) : constraintEvaluator.evaluate(this.getClazz(), this.persistentProperties);
        for (GrailsDomainClassProperty property : this.persistentProperties) {
            if (!property.isEmbedded()) continue;
            property.getComponent().refreshConstraints();
        }
    }

    ConstraintsEvaluator getConstraintsEvaluator() {
        ApplicationContext context;
        if (this.grailsApplication != null && this.grailsApplication.getMainContext() != null && (context = this.grailsApplication.getMainContext()).containsBean("orgGrailsBeansConstraintsEvaluator")) {
            return (ConstraintsEvaluator)context.getBean("orgGrailsBeansConstraintsEvaluator", ConstraintsEvaluator.class);
        }
        return new DefaultConstraintEvaluator(this.defaultConstraints);
    }

    @Override
    public Map getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public boolean hasPersistentProperty(String propertyName) {
        for (GrailsDomainClassProperty persistentProperty : this.persistentProperties) {
            if (!persistentProperty.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMappingStrategy(String strategy) {
        this.mappingStrategy = strategy;
    }

    @Override
    public void addComponent(GrailsDomainClass component) {
        this.components.add(component);
    }

    @Override
    public List<GrailsDomainClass> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public List<GrailsDomainClassProperty> getAssociations() {
        return this.associations;
    }
}

