/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import grails.web.Action;
import grails.web.UrlConverter;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.codehaus.groovy.grails.commons.AbstractInjectableGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.springframework.context.ApplicationContext;
import org.springframework.util.AntPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsControllerClass
extends AbstractInjectableGrailsClass
implements GrailsControllerClass {
    public static final String CONTROLLER = "Controller";
    private static final String SLASH = "/";
    private static final String DEFAULT_CLOSURE_PROPERTY = "defaultAction";
    private static final String ALLOWED_HTTP_METHODS_PROPERTY = "allowedMethods";
    private static final String EXCEPT = "except";
    private static final String ONLY = "only";
    private static final String FLOW_SUFFIX = "Flow";
    private static final String ACTION = "action";
    private Map<String, String> uri2viewMap = new HashMap<String, String>();
    private Map<String, String> uri2methodMap = new HashMap<String, String>();
    private Map<String, String> viewNames = new HashMap<String, String>();
    private String[] uris;
    private String uri;
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private Map<String, FeatureDescriptor> flows = new HashMap<String, FeatureDescriptor>();
    private UrlConverter urlConverter;
    private String defaultActionName = this.getStaticPropertyValue("defaultAction", String.class);
    private String controllerPath;

    @Override
    public void setDefaultActionName(String defaultActionName) {
        this.defaultActionName = defaultActionName;
        this.configureDefaultActionIfSet();
        this.configureURIsForCurrentState();
    }

    public DefaultGrailsControllerClass(Class<?> clazz) {
        super(clazz, CONTROLLER);
        if (this.defaultActionName == null) {
            this.defaultActionName = "index";
        }
    }

    @Override
    public void initialize() {
        ApplicationContext mainContext = this.grailsApplication.getMainContext();
        this.urlConverter = (UrlConverter)mainContext.getBean("grailsUrlConverter", UrlConverter.class);
        this.uri = SLASH + this.urlConverter.toUrlElement(this.getName());
        this.controllerPath = this.uri + SLASH;
        HashSet<String> actionNames = new HashSet<String>();
        this.flowStrategy(actionNames);
        this.methodStrategy(actionNames);
        this.configureDefaultActionIfSet();
        this.configureURIsForCurrentState();
    }

    private void flowStrategy(Collection<String> closureNames) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            Class<?> propertyType;
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null || Modifier.isStatic(readMethod.getModifiers()) || (propertyType = propertyDescriptor.getPropertyType()) != Object.class && propertyType != Closure.class || !propertyDescriptor.getName().endsWith(FLOW_SUFFIX)) continue;
            String closureName = propertyDescriptor.getName();
            String flowId = closureName.substring(0, closureName.length() - FLOW_SUFFIX.length());
            this.flows.put(flowId, propertyDescriptor);
            closureNames.add(flowId);
            this.configureMappingForMethodAction(flowId);
        }
        if (!this.isReadableProperty(this.defaultActionName) && closureNames.size() == 1) {
            this.defaultActionName = closureNames.iterator().next();
        }
    }

    private void methodStrategy(Collection<String> methodNames) {
        for (Class<?> superClass = this.getClazz(); superClass != null && superClass != Object.class && superClass != GroovyObject.class; superClass = superClass.getSuperclass()) {
            for (Method method : superClass.getMethods()) {
                String methodName;
                if (!Modifier.isPublic(method.getModifiers()) || method.getAnnotation(Action.class) == null || (methodName = method.getName()).endsWith(FLOW_SUFFIX)) continue;
                methodNames.add(methodName);
                this.configureMappingForMethodAction(methodName);
            }
        }
        if (!this.isActionMethod(this.defaultActionName) && methodNames.size() == 1 && !this.isReadableProperty("scaffold")) {
            this.defaultActionName = methodNames.iterator().next();
        }
    }

    private void configureURIsForCurrentState() {
        this.uris = this.uri2methodMap.keySet().toArray(new String[this.uri2methodMap.keySet().size()]);
    }

    private void configureDefaultActionIfSet() {
        if (this.defaultActionName == null) {
            return;
        }
        String defaultViewPath = SLASH + GrailsNameUtils.getPropertyNameRepresentation((String)this.getName()) + SLASH + this.defaultActionName;
        this.uri2methodMap.put(this.uri, this.defaultActionName);
        this.uri2methodMap.put(this.controllerPath, this.defaultActionName);
        this.uri2viewMap.put(this.controllerPath, defaultViewPath);
        this.uri2viewMap.put(this.uri, defaultViewPath);
        this.viewNames.put(this.defaultActionName, defaultViewPath);
    }

    private void configureMappingForMethodAction(String closureName) {
        String tmpUri = this.controllerPath + this.urlConverter.toUrlElement(closureName);
        this.uri2methodMap.put(tmpUri, closureName);
        this.uri2methodMap.put(tmpUri + SLASH + "**", closureName);
        String viewPath = SLASH + GrailsNameUtils.getPropertyNameRepresentation((String)this.getName()) + SLASH + closureName;
        this.uri2viewMap.put(tmpUri, viewPath);
        this.viewNames.put(closureName, viewPath);
    }

    @Override
    public String[] getURIs() {
        return this.uris;
    }

    @Override
    public boolean mapsToURI(String uri) {
        for (String uri1 : this.uris) {
            if (!this.pathMatcher.match(uri1, uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getViewByURI(String uri) {
        return this.uri2viewMap.get(uri);
    }

    @Override
    public String getMethodActionName(String uri) {
        return this.uri2methodMap.get(uri);
    }

    @Override
    public String getViewByName(String viewName) {
        if (this.viewNames.containsKey(viewName)) {
            return this.viewNames.get(viewName);
        }
        return this.uri + SLASH + viewName;
    }

    @Override
    public boolean isInterceptedBefore(GroovyObject controller, String action) {
        return controller.getMetaClass().hasProperty((Object)controller, "beforeInterceptor") != null && this.isIntercepted(controller.getProperty("beforeInterceptor"), action);
    }

    private boolean isIntercepted(Object bip, String action) {
        if (bip instanceof Closure) {
            return true;
        }
        if (!(bip instanceof Map)) {
            return false;
        }
        Map bipMap = (Map)bip;
        if (bipMap.containsKey(EXCEPT)) {
            Object excepts = bipMap.get(EXCEPT);
            if (excepts instanceof String ? !excepts.equals(action) : excepts instanceof List && !((List)excepts).contains(action)) {
                return true;
            }
        } else if (bipMap.containsKey(ONLY)) {
            Object onlys = bipMap.get(ONLY);
            if (onlys instanceof String ? onlys.equals(action) : onlys instanceof List && ((List)onlys).contains(action)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isHttpMethodAllowedForAction(GroovyObject controller, final String httpMethod, String actionName) {
        Object methodRestrictionsProperty = null;
        MetaProperty metaProp = controller.getMetaClass().getMetaProperty(ALLOWED_HTTP_METHODS_PROPERTY);
        if (metaProp != null) {
            methodRestrictionsProperty = metaProp.getProperty((Object)controller);
        }
        if (!(methodRestrictionsProperty instanceof Map)) {
            return true;
        }
        Map map = (Map)methodRestrictionsProperty;
        Object value = map.get(actionName);
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase(httpMethod);
        }
        if (!(value instanceof List)) {
            return true;
        }
        return CollectionUtils.exists((Collection)((List)value), (Predicate)new Predicate(){

            public boolean evaluate(Object method) {
                return httpMethod.equalsIgnoreCase(method.toString());
            }
        });
    }

    @Override
    public boolean isInterceptedAfter(GroovyObject controller, String action) {
        return controller.getMetaClass().hasProperty((Object)controller, "afterInterceptor") != null && this.isIntercepted(controller.getProperty("afterInterceptor"), action);
    }

    @Override
    public Closure getBeforeInterceptor(GroovyObject controller) {
        if (this.isReadableProperty("beforeInterceptor")) {
            return this.getInterceptor(controller, controller.getProperty("beforeInterceptor"));
        }
        return null;
    }

    @Override
    public Closure getAfterInterceptor(GroovyObject controller) {
        if (this.isReadableProperty("afterInterceptor")) {
            return this.getInterceptor(controller, controller.getProperty("afterInterceptor"));
        }
        return null;
    }

    private Closure getInterceptor(GroovyObject controller, Object ip) {
        Closure interceptor = null;
        if (ip instanceof Map) {
            Map ipMap = (Map)ip;
            if (ipMap.containsKey(ACTION)) {
                interceptor = (Closure)ipMap.get(ACTION);
            }
        } else if (ip instanceof Closure) {
            interceptor = (Closure)ip;
        }
        if (interceptor != null && interceptor.getDelegate() != controller) {
            interceptor = (Closure)interceptor.clone();
            interceptor.setDelegate((Object)controller);
            interceptor.setResolveStrategy(1);
        }
        return interceptor;
    }

    @Override
    @Deprecated
    public Set getCommandObjectActions() {
        return Collections.EMPTY_SET;
    }

    @Override
    @Deprecated
    public Set getCommandObjectClasses() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Map<String, Closure> getFlows() {
        HashMap<String, Closure> closureFlows = new HashMap<String, Closure>();
        for (String name : this.flows.keySet()) {
            Closure c = this.getPropertyValue(name + FLOW_SUFFIX, Closure.class);
            if (c == null) continue;
            closureFlows.put(name, c);
        }
        return closureFlows;
    }

    @Override
    public boolean isFlowAction(String actionName) {
        return this.flows.containsKey(actionName);
    }

    @Override
    public String getDefaultAction() {
        return this.defaultActionName;
    }

    @Override
    public void registerMapping(String actionName) {
        this.configureMappingForMethodAction(actionName);
        this.configureURIsForCurrentState();
    }
}

