/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.context.support;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Environment;
import grails.util.Metadata;
import grails.util.PluginBuildSettings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.BinaryGrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.support.DevelopmentResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginAwareResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource
implements GrailsApplicationAware,
PluginManagerAware,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(PluginAwareResourceBundleMessageSource.class);
    private static final String WEB_INF_PLUGINS_PATH = "/WEB-INF/plugins/";
    protected GrailsApplication application;
    protected GrailsPluginManager pluginManager;
    protected List<String> pluginBaseNames = new ArrayList<String>();
    private ResourceLoader localResourceLoader;
    private PathMatchingResourcePatternResolver resourceResolver;
    private Map<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder> cachedMergedPluginProperties = new ConcurrentHashMap<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder>();
    private int pluginCacheMillis = -1;
    private final PluginBuildSettings pluginBuildSettings = GrailsPluginUtils.getPluginBuildSettings();

    public List<String> getPluginBaseNames() {
        return this.pluginBaseNames;
    }

    public void setPluginBaseNames(List<String> pluginBaseNames) {
        this.pluginBaseNames = pluginBaseNames;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.application = grailsApplication;
    }

    @Override
    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.pluginManager != null && this.localResourceLoader != null) {
            GrailsPlugin[] plugins;
            for (GrailsPlugin plugin : plugins = this.pluginManager.getAllPlugins()) {
                Resource[] pluginBundles;
                for (Resource pluginBundle : pluginBundles = this.getPluginBundles(plugin)) {
                    String basePath = null;
                    String baseName = StringUtils.substringBefore((String)FilenameUtils.getBaseName((String)pluginBundle.getFilename()), (String)"_");
                    basePath = this.isInlinePlugin(plugin) ? this.getInlinePluginPath(plugin) : WEB_INF_PLUGINS_PATH.substring(1) + plugin.getFileSystemName();
                    this.pluginBaseNames.add(basePath + "/grails-app/i18n/" + baseName);
                }
            }
        }
    }

    protected Resource[] getPluginBundles(GrailsPlugin grailsPlugin) {
        try {
            String basePath = null;
            if (!(grailsPlugin instanceof BinaryGrailsPlugin)) {
                String inlinePath = this.getInlinePluginPath(grailsPlugin);
                basePath = inlinePath != null ? "file:" + inlinePath : WEB_INF_PLUGINS_PATH + grailsPlugin.getFileSystemName();
                return this.resourceResolver.getResources(basePath + "/grails-app/i18n/*.properties");
            }
            return new Resource[0];
        }
        catch (Exception e) {
            LOG.debug((Object)("Could not resolve any resources for plugin " + grailsPlugin.getFileSystemName()), (Throwable)e);
            return new Resource[0];
        }
    }

    protected boolean isInlinePlugin(GrailsPlugin grailsPlugin) {
        return this.getInlinePluginPath(grailsPlugin) != null;
    }

    protected String getInlinePluginPath(GrailsPlugin grailsPlugin) {
        String path = null;
        try {
            GrailsPluginInfo pluginInfo = this.pluginBuildSettings.getPluginInfoForName(grailsPlugin.getFileSystemShortName());
            if (pluginInfo != null) {
                BuildSettings buildSettings = this.pluginBuildSettings.getBuildSettings();
                File resourcesDir = buildSettings.getResourcesDir();
                path = new File(resourcesDir, "plugins/" + pluginInfo.getFullName()).getCanonicalPath();
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Unable to retrieve plugin directory for plugin " + grailsPlugin.getFileSystemShortName() + "."), (Throwable)e);
        }
        return path;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String msg = super.resolveCodeWithoutArguments(code, locale);
        if (msg == null) {
            return this.resolveCodeWithoutArgumentsFromPlugins(code, locale);
        }
        return msg;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat mf = super.resolveCode(code, locale);
        if (mf == null) {
            return this.resolveCodeFromPlugins(code, locale);
        }
        return mf;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder getMergedPluginProperties(Locale locale) {
        GrailsPlugin[] allPlugins;
        ReloadableResourceBundleMessageSource.PropertiesHolder mergedHolder = this.cachedMergedPluginProperties.get(locale);
        if (mergedHolder != null) {
            return mergedHolder;
        }
        Properties mergedProps = new Properties();
        mergedHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, mergedProps, -1L);
        for (String basename : this.pluginBaseNames) {
            List filenames = this.calculateAllFilenames(basename, locale);
            for (int j = filenames.size() - 1; j >= 0; --j) {
                String filename = (String)filenames.get(j);
                ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getProperties(filename);
                if (propHolder.getProperties() == null) continue;
                mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
            }
        }
        for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
            BinaryGrailsPlugin binaryPlugin;
            Properties binaryPluginProperties;
            if (!(plugin instanceof BinaryGrailsPlugin) || (binaryPluginProperties = (binaryPlugin = (BinaryGrailsPlugin)plugin).getProperties(locale)) == null) continue;
            mergedProps.putAll((Map<?, ?>)binaryPluginProperties);
        }
        this.cachedMergedPluginProperties.put(locale, mergedHolder);
        return mergedHolder;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.pluginCacheMillis = cacheSeconds * 1000;
        super.setCacheSeconds(cacheSeconds);
    }

    protected String resolveCodeWithoutArgumentsFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            String result = this.findMessageInSourcePlugins(code, locale);
            if (result != null) {
                return result;
            }
            result = this.findCodeInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private String findCodeInBinaryPlugins(String code, Locale locale) {
        BinaryGrailsPlugin binaryPlugin;
        Properties binaryPluginProperties;
        GrailsPlugin plugin;
        GrailsPlugin[] allPlugins;
        String result = null;
        GrailsPlugin[] arr$ = allPlugins = this.pluginManager.getAllPlugins();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (plugin = arr$[i$]) instanceof BinaryGrailsPlugin && (binaryPluginProperties = (binaryPlugin = (BinaryGrailsPlugin)plugin).getProperties(locale)) != null && (result = binaryPluginProperties.getProperty(code)) != null); ++i$) {
        }
        return result;
    }

    private String findMessageInSourcePlugins(String code, Locale locale) {
        String result = null;
        for (String pluginBaseName : this.pluginBaseNames) {
            List filenames = this.calculateAllFilenames(pluginBaseName, locale);
            for (String filename : filenames) {
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filename);
                result = holder.getProperty(code);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    private MessageFormat findMessageFormatInBinaryPlugins(String code, Locale locale) {
        GrailsPlugin[] allPlugins;
        MessageFormat result = null;
        for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
            BinaryGrailsPlugin binaryPlugin;
            Properties binaryPluginProperties;
            if (!(plugin instanceof BinaryGrailsPlugin) || (binaryPluginProperties = (binaryPlugin = (BinaryGrailsPlugin)plugin).getProperties(locale)) == null) continue;
            String foundCode = binaryPluginProperties.getProperty(code);
            if (foundCode != null) {
                result = new MessageFormat(foundCode, locale);
            }
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private MessageFormat findMessageFormatInSourcePlugins(String code, Locale locale) {
        MessageFormat result = null;
        for (String pluginBaseName : this.pluginBaseNames) {
            List filenames = this.calculateAllFilenames(pluginBaseName, locale);
            for (String filename : filenames) {
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filename);
                result = holder.getMessageFormat(code, locale);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    protected MessageFormat resolveCodeFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            MessageFormat result = this.findMessageFormatInSourcePlugins(code, locale);
            if (result != null) {
                return result;
            }
            result = this.findMessageFormatInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (Metadata.getCurrent().isWarDeployed()) {
            this.localResourceLoader = resourceLoader;
        } else {
            BuildSettings settings = BuildSettingsHolder.getSettings();
            String location = null;
            if (settings != null) {
                location = settings.getResourcesDir().getPath();
            } else if (Environment.getCurrent().isReloadEnabled()) {
                location = Environment.getCurrent().getReloadLocation();
            }
            this.localResourceLoader = location != null ? new DevelopmentResourceLoader(this.application, location) : resourceLoader;
        }
        super.setResourceLoader(this.localResourceLoader);
        this.resourceResolver = new PathMatchingResourcePatternResolver(this.localResourceLoader);
    }
}

