/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.util.Environment;
import grails.util.GrailsUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadAwareAutowireCapableBeanFactory
extends DefaultListableBeanFactory {
    public static boolean DISABLE_AUTOWIRE_BY_NAME_OPTIMIZATIONS = Boolean.getBoolean("grails.disable.optimization.autowirebyname");
    ConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> autowireableBeanPropsCacheForClass = new ConcurrentHashMap();
    private boolean reloadEnabled;

    public ReloadAwareAutowireCapableBeanFactory() {
        boolean bl = this.reloadEnabled = GrailsUtil.isDevelopmentEnv() || Environment.getCurrent().isReloadEnabled();
        if (this.reloadEnabled) {
            this.setInstantiationStrategy((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(){

                public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
                    if (beanDefinition.getMethodOverrides().isEmpty()) {
                        Constructor constructorToUse;
                        Class clazz = beanDefinition.getBeanClass();
                        if (clazz.isInterface()) {
                            throw new BeanInstantiationException(clazz, "Specified class is an interface");
                        }
                        try {
                            constructorToUse = clazz.getDeclaredConstructor(null);
                        }
                        catch (Exception ex) {
                            throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
                        }
                        return BeanUtils.instantiateClass(constructorToUse, (Object[])new Object[0]);
                    }
                    return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
                }
            });
        }
        this.setParameterNameDiscoverer((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
        this.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        this.ignoreDependencyType(Closure.class);
    }

    protected Object doCreateBean(String beanName, RootBeanDefinition mbd, Object[] args) {
        if (!this.reloadEnabled) {
            return super.doCreateBean(beanName, mbd, args);
        }
        try {
            return super.doCreateBean(beanName, mbd, args);
        }
        catch (BeanCreationException t) {
            Object bean;
            if (t.getCause() instanceof TypeMismatchException && (bean = this.handleTypeMismatchException(beanName, mbd, args)) != null) {
                return bean;
            }
            throw t;
        }
    }

    private Object handleTypeMismatchException(String beanName, RootBeanDefinition mbd, Object[] args) {
        Class newBeanClass;
        Class beanClass = mbd.getBeanClass();
        if (!GroovyObject.class.isAssignableFrom(beanClass)) {
            return null;
        }
        GrailsApplication application = (GrailsApplication)this.getBean("grailsApplication");
        ClassLoader classLoader = application.getClassLoader();
        if (!(classLoader instanceof GrailsClassLoader)) {
            return null;
        }
        GrailsClassLoader gcl = (GrailsClassLoader)((Object)classLoader);
        gcl.reloadClass(beanClass.getName());
        try {
            newBeanClass = gcl.loadClass(beanClass.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        mbd.setBeanClass(newBeanClass);
        if (newBeanClass.equals(beanClass)) {
            return null;
        }
        GrailsPluginManager pluginManager = (GrailsPluginManager)this.getBean("pluginManager");
        pluginManager.informOfClassChange(newBeanClass);
        return super.doCreateBean(beanName, mbd, args);
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return pd.getName().indexOf(36) > -1 || super.isExcludedFromDependencyCheck(pd);
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (Environment.isInitializing()) {
            return;
        }
        if (autowireMode == 1) {
            if (DISABLE_AUTOWIRE_BY_NAME_OPTIMIZATIONS || dependencyCheck || existingBean instanceof Aware) {
                super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
            } else {
                this.populateBeanInAutowireByName(existingBean);
            }
        } else {
            super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
        }
    }

    protected void populateBeanInAutowireByName(Object existingBean) {
        Map<String, PropertyDescriptor> autowireableBeanProps = this.resolveAutowireablePropertyDescriptors(existingBean);
        this.autowireBeanInAutowireByName(existingBean, autowireableBeanProps);
    }

    protected void autowireBeanInAutowireByName(final Object existingBean, Map<String, PropertyDescriptor> autowireableBeanProps) {
        for (Map.Entry<String, PropertyDescriptor> entry : autowireableBeanProps.entrySet()) {
            PropertyDescriptor pd = entry.getValue();
            final Method writeMethod = pd.getWriteMethod();
            String beanName = entry.getKey();
            final Object value = this.getBean(beanName);
            try {
                if (System.getSecurityManager() != null) {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                writeMethod.invoke(existingBean, value);
                                return null;
                            }
                        }, this.getAccessControlContext());
                        continue;
                    }
                    catch (PrivilegedActionException ex) {
                        throw ex.getException();
                    }
                }
                writeMethod.invoke(existingBean, value);
            }
            catch (TypeMismatchException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(existingBean, beanName, null, value);
                if (ex.getTargetException() instanceof ClassCastException) {
                    throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
                }
                throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            }
            catch (Exception ex) {
                PropertyChangeEvent pce = new PropertyChangeEvent(existingBean, beanName, null, value);
                throw new MethodInvocationException(pce, (Throwable)ex);
            }
        }
    }

    protected Map<String, PropertyDescriptor> resolveAutowireablePropertyDescriptors(Object existingBean) {
        Class beanClass = ClassUtils.getUserClass(existingBean.getClass());
        HashMap<String, PropertyDescriptor> autowireableBeanProps = (HashMap<String, PropertyDescriptor>)this.autowireableBeanPropsCacheForClass.get(beanClass);
        if (autowireableBeanProps == null) {
            PropertyDescriptor[] pds;
            autowireableBeanProps = new HashMap<String, PropertyDescriptor>();
            BeanWrapperImpl bw = new BeanWrapperImpl(false);
            bw.setWrappedInstance(existingBean);
            bw.setConversionService(this.getConversionService());
            for (PropertyDescriptor pd : pds = bw.getPropertyDescriptors()) {
                if (!this.containsBean(pd.getName()) || pd.getWriteMethod() == null || this.isExcludedFromDependencyCheck(pd) || BeanUtils.isSimpleProperty(pd.getPropertyType())) continue;
                final Method writeMethod = pd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers()) && !writeMethod.isAccessible()) {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                writeMethod.setAccessible(true);
                                return null;
                            }
                        });
                    } else {
                        writeMethod.setAccessible(true);
                    }
                }
                autowireableBeanProps.put(pd.getName(), pd);
            }
            if (!this.reloadEnabled) {
                this.autowireableBeanPropsCacheForClass.put(beanClass, autowireableBeanProps);
            }
        }
        return autowireableBeanProps;
    }
}

