/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import groovy.lang.GroovyObjectSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockApplicationContext
extends GroovyObjectSupport
implements WebApplicationContext {
    Date startupDate = new Date();
    Map<String, Object> beans = new HashMap<String, Object>();
    List<Resource> resources = new ArrayList<Resource>();
    List<String> ignoredClassLocations = new ArrayList<String>();
    PathMatcher pathMatcher = new AntPathMatcher();
    ServletContext servletContext = new MockServletContext();

    public void registerMockBean(String name, Object instance) {
        this.beans.put(name, instance);
    }

    public void registerMockResource(String location) {
        this.resources.add((Resource)new ClassPathResource(StringUtils.removeStart((String)location, (String)"/")));
    }

    public void registerMockResource(String location, String contents) {
        this.resources.add((Resource)new MockResource(StringUtils.removeStart((String)location, (String)"/"), contents));
    }

    public void unregisterMockResource(String location) {
        Iterator<Resource> it = this.resources.iterator();
        while (it.hasNext()) {
            MockResource mockResource = (MockResource)it.next();
            if (!mockResource.location.equals(location)) continue;
            it.remove();
        }
    }

    public void registerIgnoredClassPathLocation(String location) {
        this.ignoredClassLocations.add(location);
    }

    public void unregisterIgnoredClassPathLocation(String location) {
        this.ignoredClassLocations.remove(location);
    }

    public ApplicationContext getParent() {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public String getId() {
        return "MockApplicationContext";
    }

    public String getDisplayName() {
        return this.getId();
    }

    public long getStartupDate() {
        return this.startupDate.getTime();
    }

    public void publishEvent(ApplicationEvent event) {
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beans.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.beans.keySet().toArray(new String[this.beans.keySet().size()]);
    }

    public String[] getBeanNamesForType(Class type) {
        ArrayList<String> beanNames = new ArrayList<String>();
        for (String beanName : this.beans.keySet()) {
            if (!type.isAssignableFrom(this.beans.get(beanName).getClass())) continue;
            beanNames.add(beanName);
        }
        return beanNames.toArray(new String[beanNames.size()]);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        return this.getBeanNamesForType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            newMap.put(beanName, this.getBean(beanName));
        }
        return newMap;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.getBeansOfType(type);
    }

    public <A extends Annotation> A findAnnotationOnBean(String name, Class<A> annotation) {
        Object o = this.getBean(name);
        if (o != null) {
            return o.getClass().getAnnotation(annotation);
        }
        return null;
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotation) throws BeansException {
        HashMap<String, Object> submap = new HashMap<String, Object>();
        for (String beanName : this.beans.keySet()) {
            Object bean = this.beans.get(beanName);
            if (bean == null || bean.getClass().getAnnotation(annotation) == null) continue;
            submap.put(beanName.toString(), bean);
        }
        return submap;
    }

    public Object getBean(String name) throws BeansException {
        if (!this.beans.containsKey(name)) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return this.beans.get(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        if (!this.beans.containsKey(name)) {
            throw new NoSuchBeanDefinitionException(name);
        }
        if (requiredType != null && !requiredType.isAssignableFrom(this.beans.get(name).getClass())) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return (T)this.beans.get(name);
    }

    public <T> T getBean(Class<T> tClass) throws BeansException {
        Map<String, T> map = this.getBeansOfType(tClass);
        if (map.isEmpty()) {
            throw new NoSuchBeanDefinitionException(tClass, "No bean found for type: " + tClass.getName());
        }
        return map.values().iterator().next();
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.getBean(name);
    }

    public Object getProperty(String name) {
        if (this.beans.containsKey(name)) {
            return this.beans.get(name);
        }
        return super.getProperty(name);
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public boolean isPrototype(String s) {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public boolean isTypeMatch(String s, Class aClass) {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        if (!this.beans.containsKey(name)) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return this.beans.get(name).getClass();
    }

    public String[] getAliases(String name) {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        MessageSource messageSource = (MessageSource)this.getBean("messageSource");
        if (messageSource == null) {
            throw new BeanCreationException("No bean [messageSource] found in MockApplicationContext");
        }
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        MessageSource messageSource = (MessageSource)this.getBean("messageSource");
        if (messageSource == null) {
            throw new BeanCreationException("No bean [messageSource] found in MockApplicationContext");
        }
        return messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        MessageSource messageSource = (MessageSource)this.getBean("messageSource");
        if (messageSource == null) {
            throw new BeanCreationException("No bean [messageSource] found in MockApplicationContext");
        }
        return messageSource.getMessage(resolvable, locale);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath:") || locationPattern.startsWith("file:")) {
            throw new UnsupportedOperationException("Location patterns 'classpath:' and 'file:' not supported by implementation");
        }
        locationPattern = StringUtils.removeStart((String)locationPattern, (String)"/");
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource res : this.resources) {
            String path = res instanceof ClassPathResource ? ((ClassPathResource)res).getPath() : res.getDescription();
            if (!this.pathMatcher.match(locationPattern, path)) continue;
            result.add(res);
        }
        return result.toArray(new Resource[0]);
    }

    public Resource getResource(String location) {
        for (Resource mockResource : this.resources) {
            if (!this.pathMatcher.match(mockResource.getDescription(), StringUtils.removeStart((String)location, (String)"/"))) continue;
            return mockResource;
        }
        for (String resourceLocation : this.ignoredClassLocations) {
            if (!this.pathMatcher.match(StringUtils.removeStart((String)location, (String)"/"), StringUtils.removeStart((String)resourceLocation, (String)"/"))) continue;
            return null;
        }
        return new ClassPathResource(location);
    }

    public boolean containsLocalBean(String arg0) {
        throw new UnsupportedOperationException("Method not supported by implementation");
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return new DefaultListableBeanFactory();
    }

    public ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public class MockResource
    extends AbstractResource {
        private String contents = "";
        private String location;

        public MockResource(String location) {
            this.location = location;
        }

        public MockResource(String location, String contents) {
            this(location);
            this.contents = contents;
        }

        public boolean exists() {
            return true;
        }

        public String getDescription() {
            return this.location;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.contents.getBytes("UTF-8"));
        }
    }
}

