/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Environment;
import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObjectSupport;
import groovy.util.ConfigObject;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.BootstrapArtefactHandler;
import org.codehaus.groovy.grails.commons.CodecArtefactHandler;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.ControllerArtefactHandler;
import org.codehaus.groovy.grails.commons.DefaultArtefactInfo;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.ServiceArtefactHandler;
import org.codehaus.groovy.grails.commons.TagLibArtefactHandler;
import org.codehaus.groovy.grails.commons.UrlMappingsArtefactHandler;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;
import org.codehaus.groovy.grails.commons.spring.GrailsResourceHolder;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.documentation.DocumentationContext;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAwareBeanPostProcessor;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsConfigurationAware;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DefaultGrailsApplication
extends GroovyObjectSupport
implements GrailsApplication,
BeanClassLoaderAware {
    private static final Pattern GETCLASSESPROP_PATTERN = Pattern.compile("(\\w+)(Classes)");
    private static final Pattern GETCLASSESMETH_PATTERN = Pattern.compile("(get)(\\w+)(Classes)");
    private static final Pattern ISCLASS_PATTERN = Pattern.compile("(is)(\\w+)(Class)");
    private static final Pattern GETCLASS_PATTERN = Pattern.compile("(get)(\\w+)Class");
    private ClassLoader cl = null;
    private Class[] allClasses = new Class[0];
    private static Log log = LogFactory.getLog(DefaultGrailsApplication.class);
    private ApplicationContext parentContext;
    private ApplicationContext mainContext;
    private List<Class> loadedClasses = new ArrayList<Class>();
    private GrailsResourceLoader resourceLoader;
    private ArtefactHandler[] artefactHandlers;
    private Map<String, ArtefactHandler> artefactHandlersByName = new HashMap<String, ArtefactHandler>();
    private List<Class> allArtefactClasses = new ArrayList<Class>();
    private Map<String, ArtefactInfo> artefactInfo = new HashMap<String, ArtefactInfo>();
    private Class[] allArtefactClassesArray;
    private Map applicationMeta;
    private Resource[] resources;
    private boolean initialised = false;

    public DefaultGrailsApplication() {
        this.cl = new GroovyClassLoader();
        this.applicationMeta = Metadata.getCurrent();
    }

    public DefaultGrailsApplication(Class[] classes, ClassLoader classLoader) {
        if (classes == null) {
            throw new IllegalArgumentException("Constructor argument 'classes' cannot be null");
        }
        this.loadedClasses.addAll(Arrays.asList(classes));
        this.allClasses = classes;
        this.cl = classLoader;
        this.applicationMeta = Metadata.getCurrent();
    }

    public DefaultGrailsApplication(Resource[] resources) throws IOException {
        this(new GrailsResourceLoader(resources));
    }

    public DefaultGrailsApplication(GrailsResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        try {
            this.applicationMeta = Metadata.getCurrent();
            this.loadGrailsApplicationFromResources(resourceLoader.getResources());
        }
        catch (IOException e) {
            throw new GrailsConfigurationException("I/O exception loading Grails: " + e.getMessage(), e);
        }
    }

    private void loadGrailsApplicationFromResources(Resource[] resources) throws IOException {
        GrailsResourceHolder resourceHolder = new GrailsResourceHolder();
        this.cl = this.configureClassLoader(this.resourceLoader);
        GroovyClassLoader gcl = (GroovyClassLoader)this.cl;
        List loadedResources = new ArrayList();
        this.loadedClasses = new ArrayList<Class>();
        try {
            for (int i = 0; resources != null && i < resources.length; ++i) {
                if (!loadedResources.contains(resources[i])) {
                    try {
                        String className = resourceHolder.getClassName(resources[i]);
                        log.debug((Object)("Loading groovy file from resource loader :[" + resources[i].getFile().getAbsolutePath() + "] with name [" + className + "]"));
                        if (StringUtils.isBlank((String)className)) continue;
                        Class c = gcl.loadClass(className, true, false);
                        Assert.notNull((Object)c, (String)"Groovy Bug! GCL loadClass method returned a null class!");
                        if (!this.loadedClasses.contains(c)) {
                            this.loadedClasses.add(c);
                        }
                        log.debug((Object)("Added Groovy class [" + c + "] to loaded classes"));
                        loadedResources = this.resourceLoader.getLoadedResources();
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("The class [" + e.getMessage() + "] was not found when attempting to load Grails application. Skipping."));
                    }
                    continue;
                }
                Class<?> c = null;
                try {
                    log.debug((Object)("Loading groovy file from class loader :[" + resources[i].getFile().getAbsolutePath() + "]"));
                    c = this.cl.loadClass(resourceHolder.getClassName(resources[i]));
                }
                catch (ClassNotFoundException e) {
                    GrailsUtil.deepSanitize(e);
                    log.error((Object)("Class not found attempting to load class " + e.getMessage()), (Throwable)e);
                }
                if (c != null) {
                    this.loadedClasses.add(c);
                }
                log.debug((Object)("Added Groovy class [" + c + "] to loaded classes"));
            }
        }
        catch (CompilationFailedException e) {
            if (Environment.getCurrent() == Environment.DEVELOPMENT) {
                log.fatal((Object)("Compilation error loading Grails application: " + e.getMessage()), (Throwable)e);
                System.exit(1);
            }
            throw e;
        }
    }

    private void initArtefactHandlers() {
        UrlMappingsArtefactHandler urlMappingsArtefactHandler;
        CodecArtefactHandler codecArtefactHandler;
        BootstrapArtefactHandler bootstrapArtefactHandler;
        TagLibArtefactHandler tagLibArtefactHandler;
        ServiceArtefactHandler serviceArtefactHandler;
        ControllerArtefactHandler controllerArtefactHandler;
        AnnotationDomainClassArtefactHandler domainClassArtefactHandler = new AnnotationDomainClassArtefactHandler();
        if (!this.hasArtefactHandler(domainClassArtefactHandler.getType())) {
            this.registerArtefactHandler(domainClassArtefactHandler);
        }
        if (!this.hasArtefactHandler((controllerArtefactHandler = new ControllerArtefactHandler()).getType())) {
            this.registerArtefactHandler(controllerArtefactHandler);
        }
        if (!this.hasArtefactHandler((serviceArtefactHandler = new ServiceArtefactHandler()).getType())) {
            this.registerArtefactHandler(serviceArtefactHandler);
        }
        if (!this.hasArtefactHandler((tagLibArtefactHandler = new TagLibArtefactHandler()).getType())) {
            this.registerArtefactHandler(tagLibArtefactHandler);
        }
        if (!this.hasArtefactHandler((bootstrapArtefactHandler = new BootstrapArtefactHandler()).getType())) {
            this.registerArtefactHandler(bootstrapArtefactHandler);
        }
        if (!this.hasArtefactHandler((codecArtefactHandler = new CodecArtefactHandler()).getType())) {
            this.registerArtefactHandler(codecArtefactHandler);
        }
        if (!this.hasArtefactHandler((urlMappingsArtefactHandler = new UrlMappingsArtefactHandler()).getType())) {
            this.registerArtefactHandler(urlMappingsArtefactHandler);
        }
        this.artefactHandlers = this.artefactHandlersByName.values().toArray(new ArtefactHandler[this.artefactHandlersByName.size()]);
    }

    private GroovyClassLoader configureClassLoader(GrailsResourceLoader resourceLoader) {
        GroovyClassLoader cl;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CompilerConfiguration config = CompilerConfiguration.DEFAULT;
        config.setSourceEncoding("UTF-8");
        ClassLoader rootLoader = DefaultGroovyMethods.getRootLoader((ClassLoader)contextLoader);
        if (rootLoader != null) {
            cl = new GrailsClassLoader(contextLoader, config, resourceLoader);
        } else {
            GrailsAwareClassLoader gcl = new GrailsAwareClassLoader(contextLoader, config);
            if (resourceLoader != null) {
                gcl.setResourceLoader(resourceLoader);
            }
            gcl.setClassInjectors(new ClassInjector[]{new DefaultGrailsDomainClassInjector()});
            cl = gcl;
        }
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        return cl;
    }

    public Class[] getAllArtefacts() {
        return this.allArtefactClassesArray;
    }

    private Class[] populateAllClasses() {
        this.allClasses = this.loadedClasses.toArray(new Class[this.loadedClasses.size()]);
        return this.allClasses;
    }

    private void configureLoadedClasses(Class[] classes) {
        this.initArtefactHandlers();
        this.artefactInfo.clear();
        this.allArtefactClasses.clear();
        this.allArtefactClassesArray = null;
        this.allClasses = classes;
        log.debug((Object)"Going to inspect artefact classes.");
        block0: for (Class theClass : classes) {
            log.debug((Object)("Inspecting [" + theClass.getName() + "]"));
            if (Modifier.isAbstract(theClass.getModifiers())) {
                log.debug((Object)("[" + theClass.getName() + "] is abstract."));
                continue;
            }
            if (this.allArtefactClasses.contains(theClass)) continue;
            for (ArtefactHandler artefactHandler : this.artefactHandlers) {
                if (!artefactHandler.isArtefact(theClass)) continue;
                log.debug((Object)("Adding artefact " + theClass + " of kind " + artefactHandler.getType()));
                GrailsClass gclass = this.addArtefact(artefactHandler.getType(), theClass);
                this.allArtefactClasses.add(theClass);
                DefaultArtefactInfo info = this.getArtefactInfo(artefactHandler.getType(), true);
                info.addGrailsClass(gclass);
                continue block0;
            }
        }
        this.refreshArtefactGrailsClassCaches();
        this.allArtefactClassesArray = this.allArtefactClasses.toArray(new Class[this.allArtefactClasses.size()]);
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            this.initializeArtefacts(artefactHandler);
        }
    }

    private void refreshArtefactGrailsClassCaches() {
        for (ArtefactInfo o : this.artefactInfo.values()) {
            DefaultArtefactInfo info = (DefaultArtefactInfo)o;
            info.updateComplete();
        }
    }

    private void addToLoaded(Class clazz) {
        this.loadedClasses.add(clazz);
        this.populateAllClasses();
    }

    public GrailsResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public ConfigObject getConfig() {
        ConfigObject c = ConfigurationHolder.getConfig();
        if (c == null) {
            c = ConfigurationHelper.loadConfigFromClasspath(this);
        }
        return c;
    }

    public Map getFlatConfig() {
        return ConfigurationHolder.getFlatConfig();
    }

    private int getArtefactCount(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? 0 : info.getClasses().length;
    }

    public Class[] getAllClasses() {
        return this.allClasses;
    }

    public ApplicationContext getMainContext() {
        return this.mainContext;
    }

    public void setMainContext(ApplicationContext context) {
        this.mainContext = context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public Class getClassForName(String className) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        for (Class c : this.allClasses) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    public void refreshConstraints() {
        GrailsClass[] domainClasses;
        DefaultArtefactInfo info = this.getArtefactInfo("Domain", true);
        for (GrailsClass domainClass : domainClasses = info.getGrailsClasses()) {
            ((GrailsDomainClass)domainClass).refreshConstraints();
        }
    }

    public void refresh() {
        if (this.cl instanceof GroovyClassLoader) {
            this.configureLoadedClasses(((GroovyClassLoader)this.cl).getLoadedClasses());
        }
    }

    public void rebuild() {
        this.initialised = false;
        this.loadedClasses.clear();
        this.initArtefactHandlers();
        if (GrailsUtil.isDevelopmentEnv()) {
            try {
                this.loadGrailsApplicationFromResources(this.resources);
                this.initialise();
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("I/O error rebuilding GrailsApplication: " + e.getMessage(), e);
            }
        } else {
            throw new IllegalStateException("Cannot rebuild GrailsApplication when not in development mode!");
        }
    }

    public Resource getResourceForClass(Class theClazz) {
        if (this.resourceLoader == null) {
            return null;
        }
        return this.resourceLoader.getResourceForClass(theClazz);
    }

    public boolean isArtefact(Class theClazz) {
        String className = theClazz.getName();
        for (Class allArtefactClass : this.allArtefactClasses) {
            Class artefactClass = allArtefactClass;
            if (!className.equals(artefactClass.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isArtefactOfType(String artefactType, Class theClazz) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler == null) {
            throw new GrailsConfigurationException("Unable to locate arefact handler for specified type: " + artefactType);
        }
        return handler.isArtefact(theClazz);
    }

    public boolean isArtefactOfType(String artefactType, String className) {
        return this.getArtefact(artefactType, className) != null;
    }

    public GrailsClass getArtefact(String artefactType, String name) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClass(name);
    }

    public ArtefactHandler getArtefactType(Class theClass) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(theClass)) continue;
            return artefactHandler;
        }
        return null;
    }

    private GrailsClass getFirstArtefact(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClasses()[0];
    }

    public GrailsClass[] getArtefacts(String artefactType) {
        if (!this.isWarDeployed()) {
            DocumentationContext.getInstance().setArtefactType(artefactType);
        }
        DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
        return info.getGrailsClasses();
    }

    public GrailsClass getArtefactForFeature(String artefactType, Object featureID) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        return handler.getArtefactForFeature(featureID);
    }

    public GrailsClass addArtefact(String artefactType, Class artefactClass) {
        if (Modifier.isAbstract(artefactClass.getModifiers())) {
            return null;
        }
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefact(artefactClass)) {
            GrailsClass artefactGrailsClass = handler.newArtefactClass(artefactClass);
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.addToLoaded(artefactClass);
            if (this.isInitialised()) {
                this.initializeArtefacts(artefactType);
            }
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactClass + "]. It is not a " + artefactType + "!");
    }

    public GrailsClass addArtefact(String artefactType, GrailsClass artefactGrailsClass) {
        if (Modifier.isAbstract(artefactGrailsClass.getClazz().getModifiers())) {
            return null;
        }
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefactGrailsClass(artefactGrailsClass)) {
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.initializeArtefacts(artefactType);
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactGrailsClass + "]. It is not a " + artefactType + "!");
    }

    public void registerArtefactHandler(ArtefactHandler handler) {
        GrailsApplicationAwareBeanPostProcessor.processAwareInterfaces(this, handler);
        this.artefactHandlersByName.put(handler.getType(), handler);
    }

    public boolean hasArtefactHandler(String type) {
        return this.artefactHandlersByName.containsKey(type);
    }

    public ArtefactHandler[] getArtefactHandlers() {
        return this.artefactHandlers;
    }

    public ArtefactHandler getArtefactHandler(String type) {
        return this.artefactHandlersByName.get(type);
    }

    private void initializeArtefacts(String artefactType) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        this.initializeArtefacts(handler);
    }

    private void initializeArtefacts(ArtefactHandler handler) {
        ArtefactInfo info;
        if (handler != null && (info = this.getArtefactInfo(handler.getType())) != null) {
            handler.initialize(info);
        }
    }

    private DefaultArtefactInfo getArtefactInfo(String artefactType, boolean create) {
        DefaultArtefactInfo cache = (DefaultArtefactInfo)this.artefactInfo.get(artefactType);
        if (cache == null && create) {
            cache = new DefaultArtefactInfo();
            this.artefactInfo.put(artefactType, cache);
            cache.updateComplete();
        }
        return cache;
    }

    public ArtefactInfo getArtefactInfo(String artefactType) {
        return this.getArtefactInfo(artefactType, false);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object[] argsv = (Object[])args;
        Matcher match = GETCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length > 0) {
                if (argsv[0] instanceof CharSequence) {
                    argsv[0] = argsv[0].toString();
                }
                if (argsv.length != 1 || !(argsv[0] instanceof String)) {
                    throw new IllegalArgumentException("Dynamic method get<Artefact>Class(artefactName) requires a single String parameter");
                }
                return this.getArtefact(match.group(2), argsv[0].toString());
            }
            return super.invokeMethod(methodName, args);
        }
        match = ISCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length != 1 || !(argsv[0] instanceof Class)) {
                throw new IllegalArgumentException("Dynamic method is<Artefact>Class(artefactClass) requires a single Class parameter");
            }
            return this.isArtefactOfType(match.group(2), (Class)argsv[0]);
        }
        match = GETCLASSESMETH_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            String artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(2));
            if (this.artefactHandlersByName.containsKey(artefactName)) {
                return this.getArtefacts(match.group(2));
            }
            throw new IllegalArgumentException("Dynamic method get<Artefact>Classes() called for unrecognized artefact: " + match.group(2));
        }
        return super.invokeMethod(methodName, args);
    }

    public Object getProperty(String propertyName) {
        String artefactName;
        Matcher match = GETCLASSESPROP_PATTERN.matcher(propertyName);
        match.find();
        if (match.matches() && this.artefactHandlersByName.containsKey(artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(1)))) {
            return this.getArtefacts(artefactName);
        }
        return super.getProperty(propertyName);
    }

    public void initialise() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded classes: [" + this.loadedClasses + "]"));
        }
        Class[] classes = this.populateAllClasses();
        this.configureLoadedClasses(classes);
        this.initialised = true;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public Map getMetadata() {
        return this.applicationMeta;
    }

    public GrailsClass getArtefactByLogicalPropertyName(String type, String logicalName) {
        ArtefactInfo info = this.getArtefactInfo(type);
        return info == null ? null : info.getGrailsClassByLogicalPropertyName(logicalName);
    }

    public void addArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addArtefact(artefactHandler.getType(), artefact);
        }
    }

    public boolean isWarDeployed() {
        Metadata metadata = (Metadata)this.getMetadata();
        return metadata.isWarDeployed();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
    }

    public void addOverridableArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addOverridableArtefact(artefactHandler.getType(), artefact);
        }
    }

    public void configChanged() {
        ArtefactHandler[] handlers;
        ConfigObject co = this.getConfig();
        for (ArtefactHandler handler : handlers = this.getArtefactHandlers()) {
            if (!(handler instanceof GrailsConfigurationAware)) continue;
            ((GrailsConfigurationAware)((Object)handler)).setConfiguration(co);
        }
    }

    public GrailsClass addOverridableArtefact(String artefactType, Class artefactClass) {
        if (Modifier.isAbstract(artefactClass.getModifiers())) {
            return null;
        }
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefact(artefactClass)) {
            GrailsClass artefactGrailsClass = handler.newArtefactClass(artefactClass);
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addOverridableGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.addToLoaded(artefactClass);
            if (this.isInitialised()) {
                this.initializeArtefacts(artefactType);
            }
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactClass + "]. It is not a " + artefactType + "!");
    }
}

