/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.exceptions.NewInstanceCreationException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrailsClass
implements GrailsClass {
    static final Log LOG = LogFactory.getLog(AbstractGrailsClass.class);
    private final Class clazz;
    private BeanWrapper reference;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private final ClassPropertyFetcher classPropertyFetcher;

    public AbstractGrailsClass(Class clazz, String trailingName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter should not be null");
        }
        this.clazz = clazz;
        this.fullName = clazz.getName();
        this.packageName = ClassUtils.getPackageName((Class)clazz);
        this.naturalName = GrailsNameUtils.getNaturalName((String)clazz.getName());
        this.shortName = ClassUtils.getShortClassName((Class)clazz);
        this.name = GrailsNameUtils.getLogicalName((Class)clazz, (String)trailingName);
        this.propertyName = GrailsNameUtils.getPropertyNameRepresentation((String)this.shortName);
        this.logicalPropertyName = StringUtils.isBlank((String)this.name) ? this.propertyName : GrailsNameUtils.getPropertyNameRepresentation((String)this.name);
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(clazz);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public Class getClazz() {
        return this.clazz;
    }

    @Override
    public Object newInstance() {
        try {
            Constructor defaultConstructor = this.getClazz().getDeclaredConstructor(new Class[0]);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable targetException = null;
            targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class [" + this.getClazz().getName() + "]!", targetException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Object getReferenceInstance() {
        Object obj = this.classPropertyFetcher.getReference();
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setMetaClass(this.getMetaClass());
        }
        return obj;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.classPropertyFetcher.getPropertyDescriptors();
    }

    public Class getPropertyType(String name) {
        return this.classPropertyFetcher.getPropertyType(name);
    }

    public boolean isReadableProperty(String name) {
        return this.classPropertyFetcher.isReadableProperty(name);
    }

    public boolean hasMetaMethod(String name) {
        return this.hasMetaMethod(name, null);
    }

    public boolean hasMetaMethod(String name, Object[] args) {
        return this.getMetaClass().getMetaMethod(name, args) != null;
    }

    public boolean hasMetaProperty(String name) {
        return this.getMetaClass().getMetaProperty(name) != null;
    }

    @Override
    public BeanWrapper getReference() {
        GrailsUtil.deprecated(AbstractGrailsClass.class, "getReference");
        if (this.reference == null) {
            this.reference = new BeanWrapperImpl(this.newInstance());
        }
        return this.reference;
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(String name, Class type) {
        Object value = this.classPropertyFetcher.getPropertyValue(name);
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public <T> T getStaticPropertyValue(String name, Class<T> type) {
        T value = this.classPropertyFetcher.getStaticPropertyValue(name, type);
        if (value == null) {
            return this.getGroovyProperty(name, type, true);
        }
        return value;
    }

    @Override
    public <T> T getPropertyValue(String name, Class<T> type) {
        T value = this.classPropertyFetcher.getPropertyValue(name, type);
        if (value == null) {
            return this.getGroovyProperty(name, type, false);
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    private <T> T getGroovyProperty(String name, Class<T> type, boolean onlyStatic) {
        MetaProperty metaProperty;
        Object value = null;
        if (GroovyObject.class.isAssignableFrom(this.getClazz()) && (metaProperty = this.getMetaClass().getMetaProperty(name)) != null) {
            int modifiers = metaProperty.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                value = metaProperty.getProperty((Object)this.clazz);
            } else if (!onlyStatic) {
                value = metaProperty.getProperty(this.getReferenceInstance());
            }
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public Object getPropertyValueObject(String name) {
        return this.getPropertyValue(name, Object.class);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getPropertyOrStaticPropertyOrFieldValue(name, Object.class);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.classPropertyFetcher.isReadableProperty(name);
    }

    @Override
    public MetaClass getMetaClass() {
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.clazz);
    }

    public String toString() {
        return "Artefact > " + this.getName();
    }
}

