/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.exceptions.CompilationFailedException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GrailsClassLoader
extends GroovyClassLoader {
    private GrailsResourceLoader grailsResourceLoader;
    private Map innerClassLoaderMap = new ConcurrentHashMap();
    private Map<String, MultipleCompilationErrorsException> compilationErrors = new ConcurrentHashMap<String, MultipleCompilationErrorsException>();

    public GrailsClassLoader() {
    }

    public GrailsClassLoader(ClassLoader parent, CompilerConfiguration config, GrailsResourceLoader resourceLoader) {
        super(parent, config);
        this.grailsResourceLoader = resourceLoader;
    }

    public boolean hasCompilationErrors() {
        return !this.compilationErrors.isEmpty();
    }

    public MultipleCompilationErrorsException getCompilationError() {
        if (this.hasCompilationErrors()) {
            return this.compilationErrors.values().iterator().next();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class reloadClass(String name) {
        try {
            Resource resourceURL = this.loadGroovySource(name);
            GrailsAwareClassLoader innerLoader = new GrailsAwareClassLoader(this);
            InputStream inputStream = null;
            this.clearCache();
            try {
                inputStream = resourceURL.getInputStream();
                Class reloadedClass = innerLoader.parseClass(DefaultGroovyMethods.getText((InputStream)inputStream), name);
                this.compilationErrors.remove(name);
                this.innerClassLoaderMap.put(name, innerLoader);
                Class clazz = reloadedClass;
                return clazz;
            }
            catch (MultipleCompilationErrorsException e) {
                this.compilationErrors.put(name, e);
                throw e;
            }
            catch (IOException e) {
                throw new CompilationFailedException("Error opening stream to class " + name + " with URL " + resourceURL, e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (MalformedURLException e) {
            throw new CompilationFailedException("Error opening stream to class " + name + ":" + e.getMessage(), e);
        }
    }

    protected Resource loadGroovySource(String name) throws MalformedURLException {
        URL resourceURL = this.grailsResourceLoader.loadGroovySource(name);
        return new UrlResource(resourceURL);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        GroovyClassLoader innerLoader = (GroovyClassLoader)this.innerClassLoaderMap.get(name);
        if (innerLoader != null) {
            return innerLoader.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
        this.grailsResourceLoader = resourceLoader;
    }
}

