/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.MissingMethodException;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.metaclass.DynamicConstructor;
import org.codehaus.groovy.grails.commons.metaclass.DynamicMethodInvocation;
import org.codehaus.groovy.grails.commons.metaclass.DynamicMethods;
import org.codehaus.groovy.grails.commons.metaclass.DynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.InvocationCallback;
import org.codehaus.groovy.grails.commons.metaclass.StaticMethodInvocation;

public abstract class AbstractDynamicMethods
implements DynamicMethods {
    protected Collection dynamicMethodInvocations = null;
    protected Collection staticMethodInvocations = null;
    protected Collection dynamicConstructors = null;
    protected Map dynamicProperties = null;
    protected Class clazz = null;
    private static final Log LOG = LogFactory.getLog(AbstractDynamicMethods.class);

    public AbstractDynamicMethods(Class theClass) throws IntrospectionException {
        this(theClass, true);
    }

    public AbstractDynamicMethods(Class theClass, boolean inRegistry) throws IntrospectionException {
        this.clazz = theClass;
        this.dynamicMethodInvocations = new ArrayList();
        this.staticMethodInvocations = new ArrayList();
        this.dynamicProperties = new HashMap();
        this.dynamicConstructors = new ArrayList();
    }

    public void addDynamicConstructor(DynamicConstructor constructor) {
        this.dynamicConstructors.add(constructor);
    }

    public AbstractDynamicMethods() {
        this.dynamicMethodInvocations = new ArrayList();
        this.staticMethodInvocations = new ArrayList();
        this.dynamicProperties = new HashMap();
        this.dynamicConstructors = new ArrayList();
    }

    public void addDynamicMethodInvocation(DynamicMethodInvocation methodInvocation) {
        this.dynamicMethodInvocations.add(methodInvocation);
    }

    public void addStaticMethodInvocation(StaticMethodInvocation methodInvocation) {
        this.staticMethodInvocations.add(methodInvocation);
    }

    public void addDynamicProperty(DynamicProperty property) {
        this.dynamicProperties.put(property.getPropertyName(), property);
    }

    public Object getProperty(Object object, String propertyName, InvocationCallback callback) {
        DynamicProperty getter = (DynamicProperty)this.dynamicProperties.get(propertyName);
        if (getter != null && getter.isPropertyMatch(propertyName)) {
            callback.markInvoked();
            return getter.get(object);
        }
        return null;
    }

    public void setProperty(Object object, String propertyName, Object newValue, InvocationCallback callback) {
        DynamicProperty setter = (DynamicProperty)this.dynamicProperties.get(propertyName);
        if (setter != null && setter.isPropertyMatch(propertyName)) {
            callback.markInvoked();
            setter.set(object, newValue);
        }
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments, InvocationCallback callback) {
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)("[DynamicMethods] Attempting invocation of dynamic method [" + methodName + "] on target [" + object + "] with arguments [" + ArrayUtils.toString((Object)arguments) + "]"));
        }
        for (DynamicMethodInvocation methodInvocation : this.dynamicMethodInvocations) {
            if (!methodInvocation.isMethodMatch(methodName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[DynamicMethods] Dynamic method [" + methodName + "] matched, attempting to invoke."));
            }
            try {
                Object result = methodInvocation.invoke(object, methodName, arguments);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[DynamicMethods] Instance method [" + methodName + "] invoked successfully with result [" + result + "]. Marking as invoked"));
                }
                callback.setInvoker(methodInvocation);
                callback.markInvoked();
                return result;
            }
            catch (MissingMethodException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[DynamicMethods] Instance method [" + methodName + "] threw MissingMethodException. Returning null and falling back to standard MetaClass"), (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    public Object invokeConstructor(Object[] arguments, InvocationCallback callBack) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DynamicMethods] Attempting invocation of dynamic constructor with arguments [" + ArrayUtils.toString((Object)arguments) + "]"));
        }
        for (DynamicConstructor constructor : this.dynamicConstructors) {
            if (!constructor.isArgumentsMatch(arguments)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[DynamicMethods] Dynamic constructor found, marked and invoking...");
            }
            callBack.markInvoked();
            return constructor.invoke(this.clazz, arguments);
        }
        return null;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments, InvocationCallback callBack) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DynamicMethods] Attempting invocation of dynamic static method [" + methodName + "] on target [" + object + "] with arguments [" + ArrayUtils.toString((Object)arguments) + "]"));
        }
        for (StaticMethodInvocation methodInvocation : this.staticMethodInvocations) {
            if (!methodInvocation.isMethodMatch(methodName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[DynamicMethods] Static method matched, attempting to invoke");
            }
            try {
                Object result = methodInvocation.invoke(this.clazz, methodName, arguments);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[DynamicMethods] Static method [" + methodName + "] invoked successfully with result [" + result + "]. Marking as invoked"));
                }
                callBack.markInvoked();
                return result;
            }
            catch (MissingMethodException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[DynamicMethods] Static method [" + methodName + "] threw MissingMethodException. Returning null and falling back to standard MetaClass"), (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    public DynamicProperty getDynamicProperty(String propertyName) {
        return (DynamicProperty)this.dynamicProperties.get(propertyName);
    }

    public DynamicMethodInvocation getDynamicMethod(String method_signature) {
        for (DynamicMethodInvocation methodInvocation : this.dynamicMethodInvocations) {
            if (!methodInvocation.isMethodMatch(method_signature)) continue;
            return methodInvocation;
        }
        return null;
    }
}

