/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import grails.util.GrailsUtil;
import groovy.lang.MissingMethodException;
import groovy.util.BuilderSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.springframework.beans.InvalidPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedPropertyBuilder
extends BuilderSupport {
    private Map<String, ConstrainedProperty> constrainedProperties = new HashMap<String, ConstrainedProperty>();
    private List<String> sharedConstraints = new ArrayList<String>();
    private int order = 1;
    private Class targetClass;
    private ClassPropertyFetcher classPropertyFetcher;
    private static final String SHARED_CONSTRAINT = "shared";

    public ConstrainedPropertyBuilder(Object target) {
        this(target.getClass());
    }

    public ConstrainedPropertyBuilder(Class targetClass) {
        this.targetClass = targetClass;
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(targetClass);
    }

    public List<String> getSharedConstraints() {
        return Collections.unmodifiableList(this.sharedConstraints);
    }

    protected Object createNode(Object name, Map attributes) {
        try {
            ConstrainedProperty cp;
            String property = (String)name;
            if (this.constrainedProperties.containsKey(property)) {
                cp = this.constrainedProperties.get(property);
            } else {
                cp = new ConstrainedProperty(this.targetClass, property, this.classPropertyFetcher.getPropertyType(property));
                cp.setOrder(this.order++);
                this.constrainedProperties.put(property, cp);
            }
            for (Object o : attributes.keySet()) {
                String constraintName = (String)o;
                Object value = attributes.get(constraintName);
                if (SHARED_CONSTRAINT.equals(constraintName)) {
                    if (value == null) continue;
                    this.sharedConstraints.add(value.toString());
                    continue;
                }
                if (cp.supportsContraint(constraintName)) {
                    cp.applyConstraint(constraintName, value);
                    continue;
                }
                if (ConstrainedProperty.hasRegisteredConstraint(constraintName)) {
                    GrailsUtil.warn("Property [" + cp.getPropertyName() + "] of domain class " + this.targetClass.getName() + " has type [" + cp.getPropertyType().getName() + "] and doesn't support constraint [" + constraintName + "]. This constraint will not be checked during validation.");
                    continue;
                }
                cp.addMetaConstraint(constraintName, value);
            }
            return cp;
        }
        catch (InvalidPropertyException ipe) {
            throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes});
        }
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes, value});
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    public Map<String, ConstrainedProperty> getConstrainedProperties() {
        return this.constrainedProperties;
    }
}

