/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import groovy.lang.Closure;
import java.util.Collection;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

public class ValidatorConstraint
extends AbstractConstraint {
    private Closure validator;
    private int numValidatorParams;

    protected boolean skipNullValues() {
        return false;
    }

    protected boolean skipBlankValues() {
        return false;
    }

    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.validator == null) {
            return;
        }
        Object[] params = new Object[this.numValidatorParams];
        params[0] = propertyValue;
        if (this.numValidatorParams >= 2) {
            params[1] = target;
        }
        if (this.numValidatorParams == 3) {
            params[2] = errors;
        }
        ValidatorDelegate delegate = new ValidatorDelegate();
        delegate.setPropertyName(this.getPropertyName());
        this.validator.setDelegate((Object)delegate);
        Object result = this.validator.call(params);
        if (this.numValidatorParams == 3) {
            return;
        }
        boolean bad = false;
        String errmsg = null;
        Object[] args = null;
        if (result != null) {
            if (result instanceof Boolean) {
                bad = (Boolean)result == false;
            } else if (result instanceof String) {
                bad = true;
                errmsg = (String)result;
            } else if (result instanceof Collection || result.getClass().isArray()) {
                Object[] values;
                bad = true;
                Object[] objectArray = values = result instanceof Collection ? ((Collection)result).toArray() : (Object[])result;
                if (!(values[0] instanceof String)) {
                    throw new IllegalArgumentException("Return value from validation closure [validator] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] is returning a list but the first element must be a string " + "containing the error message code");
                }
                errmsg = (String)values[0];
                args = new Object[values.length - 1 + 3];
                int i = 0;
                args[i++] = this.constraintPropertyName;
                args[i++] = this.constraintOwningClass;
                args[i++] = propertyValue;
                System.arraycopy(values, 1, args, i, values.length - 1);
            } else {
                throw new IllegalArgumentException("Return value from validation closure [validator] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean, a string, an array or a collection");
            }
        }
        if (bad) {
            if (args == null) {
                args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
            }
            this.rejectValue(target, errors, "default.invalid.validator.message", errmsg == null ? "validator.invalid" : errmsg, args);
        }
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Closure)) {
            throw new IllegalArgumentException("Parameter for constraint [validator] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a Closure");
        }
        this.validator = (Closure)constraintParameter;
        Class[] params = this.validator.getParameterTypes();
        if (params.length == 0) {
            throw new IllegalArgumentException("Parameter for constraint [validator] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a Closure taking at least 1 parameter (value, [object])");
        }
        if (params.length > 3) {
            throw new IllegalArgumentException("Parameter for constraint [validator] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a Closure taking no more than 3 parameters (value, [object, [errors]])");
        }
        this.numValidatorParams = params.length;
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "validator";
    }

    public boolean supports(Class type) {
        return type != null;
    }

    private static class ValidatorDelegate {
        private String propertyName;

        private ValidatorDelegate() {
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

