/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import groovy.lang.IntRange;
import java.lang.reflect.Array;
import java.util.Collection;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

class SizeConstraint
extends AbstractConstraint {
    private IntRange range;

    SizeConstraint() {
    }

    public IntRange getRange() {
        return this.range;
    }

    public boolean supports(Class type) {
        return type != null && (String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray());
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof IntRange)) {
            throw new IllegalArgumentException("Parameter for constraint [size] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [groovy.lang.IntRange]");
        }
        this.range = (IntRange)constraintParameter;
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "size";
    }

    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.range.getFrom(), this.range.getTo()};
        Integer size = null;
        if (propertyValue.getClass().isArray()) {
            size = new Integer(Array.getLength(propertyValue));
        } else if (propertyValue instanceof Collection) {
            size = new Integer(((Collection)propertyValue).size());
        } else if (propertyValue instanceof String) {
            size = new Integer(((String)propertyValue).length());
        }
        if (!this.range.contains((Object)size)) {
            if (this.range.getFrom().compareTo(size) == 1) {
                this.rejectValueTooSmall(args, errors, target);
            } else if (this.range.getTo().compareTo(size) == -1) {
                this.rejectValueTooBig(args, errors, target);
            }
        }
    }

    private void rejectValueTooSmall(Object[] args, Errors errors, Object target) {
        this.rejectValue(args, errors, target, false);
    }

    private void rejectValueTooBig(Object[] args, Errors errors, Object target) {
        this.rejectValue(args, errors, target, true);
    }

    private void rejectValue(Object[] args, Errors errors, Object target, boolean tooBig) {
        String suffix = tooBig ? ".toobig" : ".toosmall";
        super.rejectValue(target, errors, "default.invalid.size.message", "size" + suffix, args);
    }
}

