/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.MissingPropertyException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.FunctionCallback;

public class GenericDynamicProperty
extends AbstractDynamicProperty {
    private Class type;
    private boolean readyOnly;
    private Map propertyToInstanceMap = new ConcurrentHashMap();
    private Object initialValue;
    private FunctionCallback initialValueGenerator;

    public GenericDynamicProperty(String propertyName, Class type, Object initialValue, boolean readOnly) {
        super(propertyName);
        if (type == null) {
            throw new IllegalArgumentException("Constructor argument 'type' cannot be null");
        }
        this.readyOnly = readOnly;
        this.type = type;
        this.initialValue = initialValue;
    }

    public GenericDynamicProperty(String propertyName, Class type, boolean readOnly) {
        super(propertyName);
        if (type == null) {
            throw new IllegalArgumentException("Constructor argument 'type' cannot be null");
        }
        this.readyOnly = readOnly;
        this.type = type;
    }

    public GenericDynamicProperty(String propertyName, Class type, FunctionCallback initialValueGenerator, boolean readOnly) {
        this(propertyName, type, readOnly);
        this.initialValueGenerator = initialValueGenerator;
    }

    public Object get(Object object) {
        String propertyKey = System.identityHashCode(object) + this.getPropertyName();
        if (this.propertyToInstanceMap.containsKey(propertyKey)) {
            return this.propertyToInstanceMap.get(propertyKey);
        }
        if (this.initialValueGenerator != null) {
            Object value = this.initialValueGenerator.execute(object);
            this.propertyToInstanceMap.put(propertyKey, value);
            return value;
        }
        if (this.initialValue != null) {
            this.propertyToInstanceMap.put(propertyKey, this.initialValue);
            return this.initialValue;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, Object newValue) {
        if (this.readyOnly) throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass() + "' is read-only!", object.getClass());
        if (newValue == null) {
            this.propertyToInstanceMap.put(String.valueOf(System.identityHashCode(object)) + this.getPropertyName(), null);
            return;
        } else {
            if (!this.type.isInstance(newValue)) throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass() + "' cannot be set with value '" + newValue + "'. Incorrect type.", object.getClass());
            this.propertyToInstanceMap.put(String.valueOf(System.identityHashCode(object)) + this.getPropertyName(), newValue);
        }
    }
}

