/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsControllerClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;

public class ControllerArtefactHandler
extends ArtefactHandlerAdapter {
    public static final String TYPE = "Controller";
    public static final String PLUGIN_NAME = "controllers";
    private GrailsClass[] controllerClasses;
    private ConcurrentHashMap<String, GrailsClass> uriToControllerClassCache;

    public ControllerArtefactHandler() {
        super(TYPE, GrailsControllerClass.class, DefaultGrailsControllerClass.class, TYPE, false);
    }

    public void initialize(ArtefactInfo artefacts) {
        this.controllerClasses = artefacts.getGrailsClasses();
        this.uriToControllerClassCache = new ConcurrentHashMap();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        String uri = feature.toString();
        if (this.controllerClasses != null) {
            GrailsClass controllerClass = this.uriToControllerClassCache.get(uri);
            if (controllerClass == null) {
                for (GrailsClass c : this.controllerClasses) {
                    if (!((GrailsControllerClass)c).mapsToURI(uri)) continue;
                    controllerClass = c;
                    break;
                }
                if (controllerClass != null) {
                    this.uriToControllerClassCache.putIfAbsent(uri, controllerClass);
                }
            }
            return controllerClass;
        }
        return null;
    }
}

