/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.BuildScope;
import grails.util.GrailsNameUtils;
import groovy.lang.ExpandoMetaClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrailsPluginManager
implements GrailsPluginManager {
    private static final String BLANK = "";
    protected List<GrailsPlugin> pluginList = new ArrayList<GrailsPlugin>();
    protected GrailsApplication application;
    protected Resource[] pluginResources = new Resource[0];
    protected Map<String, GrailsPlugin> plugins = new HashMap<String, GrailsPlugin>();
    protected Map<String, GrailsPlugin> classNameToPluginMap = new HashMap<String, GrailsPlugin>();
    protected Class[] pluginClasses = new Class[0];
    protected boolean initialised = false;
    protected ApplicationContext applicationContext;
    protected Map<String, GrailsPlugin> failedPlugins = new HashMap<String, GrailsPlugin>();
    protected boolean loadCorePlugins = true;

    public AbstractGrailsPluginManager(GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException("Argument [application] cannot be null!");
        }
        this.application = application;
    }

    @Override
    public List<TypeFilter> getTypeFilters() {
        ArrayList<? extends TypeFilter> list = new ArrayList<TypeFilter>();
        for (GrailsPlugin grailsPlugin : this.pluginList) {
            list.addAll(grailsPlugin.getTypeFilters());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public GrailsPlugin[] getAllPlugins() {
        return this.pluginList.toArray(new GrailsPlugin[this.pluginList.size()]);
    }

    @Override
    public GrailsPlugin[] getFailedLoadPlugins() {
        return this.failedPlugins.values().toArray(new GrailsPlugin[this.failedPlugins.size()]);
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    protected void checkInitialised() {
        if (!this.initialised) {
            throw new IllegalStateException("Must call loadPlugins() before invoking configurational methods on GrailsPluginManager");
        }
    }

    @Override
    public GrailsPlugin getFailedPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.failedPlugins.get(name);
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        this.checkInitialised();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doRuntimeConfiguration(String pluginName, RuntimeSpringConfiguration springConfig) {
        String[] loadAfters;
        this.checkInitialised();
        GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        if (plugin == null) {
            throw new PluginException("Plugin [" + pluginName + "] not found");
        }
        if (!plugin.supportsCurrentScopeAndEnvironment()) {
            return;
        }
        String[] dependencyNames = plugin.getDependencyNames();
        this.doRuntimeConfigurationForDependencies(dependencyNames, springConfig);
        for (String name : loadAfters = plugin.getLoadAfterNames()) {
            GrailsPlugin current = this.getGrailsPlugin(name);
            if (current == null) continue;
            current.doWithRuntimeConfiguration(springConfig);
        }
        plugin.doWithRuntimeConfiguration(springConfig);
    }

    private void doRuntimeConfigurationForDependencies(String[] dependencyNames, RuntimeSpringConfiguration springConfig) {
        for (String dn : dependencyNames) {
            GrailsPlugin current = this.getGrailsPlugin(dn);
            if (current == null) {
                throw new PluginException("Cannot load Plugin. Dependency [" + current + "] not found");
            }
            String[] pluginDependencies = current.getDependencyNames();
            if (pluginDependencies.length > 0) {
                this.doRuntimeConfigurationForDependencies(pluginDependencies, springConfig);
            }
            current.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doPostProcessing(ApplicationContext applicationContext) {
        this.checkInitialised();
        for (GrailsPlugin aPluginList : this.pluginList) {
            GrailsPlugin plugin = aPluginList;
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doWithApplicationContext(applicationContext);
        }
    }

    public Resource[] getPluginResources() {
        return this.pluginResources;
    }

    @Override
    public GrailsPlugin getGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.plugins.get(name);
    }

    @Override
    public GrailsPlugin getGrailsPluginForClassName(String name) {
        return this.classNameToPluginMap.get(name);
    }

    @Override
    public GrailsPlugin getGrailsPlugin(String name, Object version) {
        GrailsPlugin plugin;
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        if ((plugin = this.plugins.get(name)) != null && GrailsPluginUtils.isValidVersion(plugin.getVersion(), version.toString())) {
            return plugin;
        }
        return null;
    }

    @Override
    public boolean hasGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.plugins.containsKey(name);
    }

    @Override
    public void doDynamicMethods() {
        this.checkInitialised();
        Class[] allClasses = this.application.getAllClasses();
        if (allClasses != null) {
            for (Class c : allClasses) {
                ExpandoMetaClass emc = new ExpandoMetaClass(c, true, true);
                emc.initialize();
            }
            Iterator<GrailsPlugin> i$ = this.pluginList.iterator();
            while (i$.hasNext()) {
                GrailsPlugin aPluginList;
                GrailsPlugin plugin = aPluginList = i$.next();
                plugin.doWithDynamicMethods(this.applicationContext);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Iterator<GrailsPlugin> i$ = this.pluginList.iterator();
        while (i$.hasNext()) {
            GrailsPlugin aPluginList;
            GrailsPlugin plugin = aPluginList = i$.next();
            plugin.setApplicationContext(applicationContext);
        }
    }

    @Override
    public void setApplication(GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException("Argument [application] cannot be null");
        }
        this.application = application;
        Iterator<GrailsPlugin> i$ = this.pluginList.iterator();
        while (i$.hasNext()) {
            GrailsPlugin aPluginList;
            GrailsPlugin plugin = aPluginList = i$.next();
            plugin.setApplication(application);
        }
    }

    @Override
    public void registerProvidedArtefacts(GrailsApplication application) {
        this.checkInitialised();
        for (GrailsPlugin aPluginList : this.pluginList) {
            Class[] artefacts;
            GrailsPlugin plugin = aPluginList;
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            for (Class artefact : artefacts = plugin.getProvidedArtefacts()) {
                String shortName = GrailsNameUtils.getShortName((Class)artefact);
                if (this.isAlreadyRegistered(application, artefact, shortName)) continue;
                application.addOverridableArtefact(artefact);
            }
        }
    }

    private boolean isAlreadyRegistered(GrailsApplication application, Class artefact, String shortName) {
        return application.getClassForName(shortName) != null || application.getClassForName(artefact.getName()) != null;
    }

    @Override
    public void doArtefactConfiguration() {
        this.checkInitialised();
        for (GrailsPlugin aPluginList : this.pluginList) {
            GrailsPlugin plugin = aPluginList;
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doArtefactConfiguration();
        }
    }

    @Override
    public void shutdown() {
        this.checkInitialised();
        for (GrailsPlugin aPluginList : this.pluginList) {
            GrailsPlugin plugin = aPluginList;
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.notifyOfEvent(2, plugin);
        }
    }

    @Override
    public boolean supportsCurrentBuildScope(String pluginName) {
        GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        return plugin == null || plugin.supportsScope(BuildScope.getCurrent());
    }

    @Override
    public void setLoadCorePlugins(boolean shouldLoadCorePlugins) {
        this.loadCorePlugins = shouldLoadCorePlugins;
    }

    @Override
    public void informOfClassChange(Class aClass) {
        GrailsPlugin plugin;
        String pluginName;
        ArtefactHandler handler;
        if (aClass != null && this.application != null && (handler = this.application.getArtefactType(aClass)) != null && (pluginName = handler.getPluginName()) != null && (plugin = this.getGrailsPlugin(pluginName)) != null) {
            plugin.notifyOfEvent(0, aClass);
        }
    }

    @Override
    public String getPluginPath(String name) {
        GrailsPlugin plugin = this.getGrailsPlugin(name);
        if (plugin != null && !plugin.isBasePlugin()) {
            return plugin.getPluginPath();
        }
        return BLANK;
    }
}

