/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test;

import grails.util.GrailsNameUtils;
import grails.util.GrailsWebUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.spring.GrailsWebApplicationContext;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.request.RequestContextHolder;

public class GrailsTestSuite
extends TestSuite {
    private static final String TRANSACTIONAL = "transactional";
    private Pattern controllerTestPattern;
    private GrailsWebApplicationContext applicationContext;

    public GrailsTestSuite(GrailsWebApplicationContext applicationContext, String testSuffix) {
        this.init(applicationContext, testSuffix);
    }

    public GrailsTestSuite(GrailsWebApplicationContext applicationContext, Class clazz, String testSuffix) {
        super(clazz);
        this.init(applicationContext, testSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runTest(final Test test, final TestResult result) {
        if (test instanceof TestCase && this.applicationContext != null) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)test, 1, false);
        }
        if (test instanceof ApplicationContextAware && this.applicationContext != null) {
            ((ApplicationContextAware)test).setApplicationContext((ApplicationContext)this.applicationContext);
        }
        try {
            GrailsWebRequest webRequest = GrailsWebUtil.bindMockWebRequest(this.applicationContext);
            ServletContextHolder.setServletContext((ServletContext)webRequest.getServletContext());
            webRequest.getServletContext().setAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT", (Object)this.applicationContext);
            if (this.isTransactional(test)) {
                if (!this.applicationContext.containsBean("transactionManager")) throw new RuntimeException("There is no test TransactionManager defined and integration test ${test.name} does not set transactional = false");
                TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)this.applicationContext.getBean("transactionManager"));
                template.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        test.run(result);
                        status.setRollbackOnly();
                        return null;
                    }
                });
                return;
            } else {
                test.run(result);
            }
            return;
        }
        finally {
            RequestContextHolder.setRequestAttributes(null);
            ServletContextHolder.setServletContext(null);
        }
    }

    public boolean isTransactional(Test test) {
        Object val = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(test, TRANSACTIONAL);
        return !(val instanceof Boolean) || (Boolean)val != false;
    }

    private void init(GrailsWebApplicationContext applicationContext, String testSuffix) {
        this.applicationContext = applicationContext;
        this.controllerTestPattern = Pattern.compile("^(\\w+)Controller" + testSuffix + "$");
    }

    void initControllerName(Test test, GrailsWebRequest webRequest) {
        Matcher matcher = this.controllerTestPattern.matcher(test.getClass().getName());
        if (matcher.matches()) {
            String name = matcher.group(1);
            webRequest.setControllerName(GrailsNameUtils.getLogicalPropertyName((String)name, (String)"Controller"));
        } else {
            webRequest.setControllerName("test");
        }
    }
}

