/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.codehaus.groovy.grails.test.FormattedOutput;
import org.codehaus.groovy.grails.test.GrailsConsoleResultFormatter;
import org.codehaus.groovy.grails.test.GrailsTestRunner;
import org.codehaus.groovy.grails.test.PlainFormatter;
import org.codehaus.groovy.grails.test.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsTestRunner
implements GrailsTestRunner {
    private PrintStream savedOut;
    private PrintStream savedErr;
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;
    private List<FormattedOutput> formattedOutputs;
    private File reportsDir;
    private List<String> formats;

    public DefaultGrailsTestRunner(File reportsDir, List<String> formats) {
        this.reportsDir = reportsDir;
        this.formats = new ArrayList<String>(formats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestResult runTests(TestSuite suite) {
        GrailsConsoleResultFormatter consoleFormatter = new GrailsConsoleResultFormatter();
        TestResult result = new TestResult();
        result.addListener((TestListener)consoleFormatter);
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            TestSuite test = (TestSuite)tests.nextElement();
            this.reset();
            JUnitTest junitTest = new JUnitTest(test.getName());
            try {
                this.replaceStandardStreams();
                this.prepareReports(test);
                consoleFormatter.setOutput(this.savedOut);
                consoleFormatter.startTestSuite(junitTest);
                for (FormattedOutput output : this.formattedOutputs) {
                    result.addListener((TestListener)output.getFormatter());
                    output.start(junitTest);
                }
                long start = System.currentTimeMillis();
                int runCount = result.runCount();
                int failureCount = result.failureCount();
                int errorCount = result.errorCount();
                for (int i = 0; i < test.testCount(); ++i) {
                    TestCase t = (TestCase)test.testAt(i);
                    System.out.println("--Output from " + t.getName() + "--");
                    System.err.println("--Output from " + t.getName() + "--");
                    test.runTest((Test)t, result);
                }
                junitTest.setCounts((long)(result.runCount() - runCount), (long)(result.failureCount() - failureCount), (long)(result.errorCount() - errorCount));
                junitTest.setRunTime(System.currentTimeMillis() - start);
            }
            finally {
                for (FormattedOutput output : this.formattedOutputs) {
                    output.end(junitTest, this.out.toString(), this.err.toString());
                }
                consoleFormatter.endTestSuite(junitTest);
                this.restoreStandardStreams();
            }
        }
        return result;
    }

    public void reset() {
        this.formattedOutputs = null;
        this.savedOut = null;
        this.savedErr = null;
        this.out = null;
        this.err = null;
    }

    public void prepareReports(TestSuite test) {
        this.formattedOutputs = new ArrayList<FormattedOutput>(this.formats.size());
        for (String format : this.formats) {
            this.formattedOutputs.add(this.createFormatter(format, test));
        }
    }

    public FormattedOutput createFormatter(String type, TestSuite test) {
        if (type.equals("xml")) {
            return new FormattedOutput(new File(this.reportsDir, "TEST-" + test.getName() + ".xml"), (JUnitResultFormatter)new XMLFormatter());
        }
        if (type.equals("plain")) {
            return new FormattedOutput(new File(this.reportsDir, "plain/TEST-" + test.getName() + ".txt"), (JUnitResultFormatter)new PlainFormatter());
        }
        throw new RuntimeException("Unknown formatter type: $type");
    }

    private void replaceStandardStreams() {
        this.savedOut = System.out;
        this.savedErr = System.err;
        this.out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void restoreStandardStreams() {
        if (this.savedOut != null) {
            System.setOut(this.savedOut);
        }
        if (this.savedErr != null) {
            System.setErr(this.savedErr);
        }
    }
}

