/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.context.annotation;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Metadata;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScanBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.w3c.dom.Element;

public class ClosureClassIgnoringComponentScanBeanDefinitionParser
extends ComponentScanBeanDefinitionParser {
    protected ClassPathBeanDefinitionScanner createScanner(XmlReaderContext readerContext, boolean useDefaultFilters) {
        ClassPathBeanDefinitionScanner scanner = super.createScanner(readerContext, useDefaultFilters);
        GrailsPluginManager pluginManager = PluginManagerHolder.getPluginManager();
        if (pluginManager != null) {
            List<TypeFilter> typeFilters = pluginManager.getTypeFilters();
            for (TypeFilter typeFilter : typeFilters) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        return scanner;
    }

    protected ClassPathBeanDefinitionScanner configureScanner(ParserContext parserContext, Element element) {
        ClassPathBeanDefinitionScanner scanner = super.configureScanner(parserContext, element);
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(parserContext.getReaderContext().getResourceLoader()){

            protected Resource[] findAllClassPathResources(String location) throws IOException {
                String path;
                BuildSettings buildSettings;
                LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
                URL classesDir = null;
                boolean warDeployed = Metadata.getCurrent().isWarDeployed();
                if (!warDeployed && (buildSettings = BuildSettingsHolder.getSettings()) != null && buildSettings.getClassesDir() != null) {
                    classesDir = buildSettings.getClassesDir().toURI().toURL();
                }
                if ((path = location).startsWith("/")) {
                    path = path.substring(1);
                }
                Enumeration<URL> resourceUrls = this.getClassLoader().getResources(path);
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    if (!warDeployed && classesDir != null && url.equals(classesDir)) {
                        result.add(this.convertClassLoaderURL(url));
                        continue;
                    }
                    if (!warDeployed) continue;
                    result.add(this.convertClassLoaderURL(url));
                }
                return result.toArray(new Resource[result.size()]);
            }
        };
        resourceResolver.setPathMatcher((PathMatcher)new AntPathMatcher(){

            public boolean match(String pattern, String path) {
                String filename;
                if (path.endsWith(".class") && (filename = FilenameUtils.getBaseName((String)path)).indexOf("$") > -1) {
                    return false;
                }
                return super.match(pattern, path);
            }
        });
        scanner.setResourceLoader((ResourceLoader)resourceResolver);
        return scanner;
    }
}

