/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsDomainClassInjector;

public class DefaultGrailsDomainClassInjector
implements GrailsDomainClassInjector {
    private static final Log LOG = LogFactory.getLog(DefaultGrailsDomainClassInjector.class);
    private List classesWithInjectedToString = new ArrayList();

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (this.isDomainClass(classNode, source) && this.shouldInjectClass(classNode)) {
            this.performInjectionOnAnnotatedEntity(classNode);
        }
    }

    public void performInjectionOnAnnotatedEntity(ClassNode classNode) {
        this.injectIdProperty(classNode);
        this.injectVersionProperty(classNode);
        this.injectToStringMethod(classNode);
        this.injectAssociations(classNode);
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass(url);
    }

    protected boolean isDomainClass(ClassNode classNode, SourceUnit sourceNode) {
        String clsName = classNode.getNameWithoutPackage();
        String sourcePath = sourceNode.getName();
        String sourceFileName = sourcePath.substring(Math.max(sourcePath.lastIndexOf("/"), sourcePath.lastIndexOf("\\")) + 1);
        return String.format("%s.groovy", clsName).equals(sourceFileName);
    }

    protected boolean shouldInjectClass(ClassNode classNode) {
        String fullName = GrailsASTUtils.getFullName(classNode);
        String mappingFile = GrailsDomainConfigurationUtil.getMappingFileName(fullName);
        if (this.getClass().getResource(mappingFile) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainInjector] Mapping file [" + mappingFile + "] found. Skipping property injection."));
            }
            return false;
        }
        return !this.isEnum(classNode);
    }

    private void injectAssociations(ClassNode classNode) {
        List properties = classNode.getProperties();
        ArrayList propertiesToAdd = new ArrayList();
        for (Object property : properties) {
            boolean isBelongsTo;
            boolean isHasManyProperty;
            PropertyNode pn = (PropertyNode)property;
            String name = pn.getName();
            boolean bl = isHasManyProperty = name.equals("relatesToMany") || name.equals("hasMany");
            if (isHasManyProperty) {
                Expression e = pn.getInitialExpression();
                propertiesToAdd.addAll(this.createPropertiesForHasManyExpression(e, classNode));
            }
            if (!(isBelongsTo = name.equals("belongsTo") || name.equals("hasOne"))) continue;
            Expression e = pn.getInitialExpression();
            propertiesToAdd.addAll(this.createPropertiesForBelongsToExpression(e, classNode));
        }
        this.injectAssociationProperties(classNode, propertiesToAdd);
    }

    private Collection createPropertiesForBelongsToExpression(Expression e, ClassNode classNode) {
        ArrayList<PropertyNode> properties = new ArrayList<PropertyNode>();
        if (e instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            List mapEntries = me.getMapEntryExpressions();
            for (Object mapEntry : mapEntries) {
                MapEntryExpression mme = (MapEntryExpression)mapEntry;
                String key = mme.getKeyExpression().getText();
                String type = mme.getValueExpression().getText();
                properties.add(new PropertyNode(key, 1, ClassHelper.make((String)type), classNode, null, null, null));
            }
        }
        return properties;
    }

    private void injectAssociationProperties(ClassNode classNode, List propertiesToAdd) {
        for (Object aPropertiesToAdd : propertiesToAdd) {
            PropertyNode pn = (PropertyNode)aPropertiesToAdd;
            if (GrailsASTUtils.hasProperty(classNode, pn.getName())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainInjector] Adding property [" + pn.getName() + "] to class [" + classNode.getName() + "]"));
            }
            classNode.addProperty(pn);
        }
    }

    private List createPropertiesForHasManyExpression(Expression e, ClassNode classNode) {
        ArrayList properties = new ArrayList();
        if (e instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            List mapEntries = me.getMapEntryExpressions();
            for (Object mapEntry : mapEntries) {
                MapEntryExpression mee = (MapEntryExpression)mapEntry;
                Expression keyExpression = mee.getKeyExpression();
                String key = keyExpression.getText();
                this.addAssociationForKey(key, properties, classNode);
            }
        }
        return properties;
    }

    private void addAssociationForKey(String key, List properties, ClassNode classNode) {
        properties.add(new PropertyNode(key, 1, new ClassNode(Set.class), classNode, null, null, null));
    }

    private void injectToStringMethod(ClassNode classNode) {
        boolean hasToString = GrailsASTUtils.implementsOrInheritsZeroArgMethod(classNode, "toString", this.classesWithInjectedToString);
        if (!hasToString && !this.isEnum(classNode)) {
            GStringExpression ge = new GStringExpression(classNode.getName() + " : ${id}");
            ge.addString(new ConstantExpression((Object)(classNode.getName() + " : ")));
            ge.addValue((Expression)new VariableExpression("id"));
            ReturnStatement s = new ReturnStatement((Expression)ge);
            MethodNode mn = new MethodNode("toString", 1, new ClassNode(String.class), new Parameter[0], new ClassNode[0], (Statement)s);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainInjector] Adding method [toString()] to class [" + classNode.getName() + "]"));
            }
            classNode.addMethod(mn);
            this.classesWithInjectedToString.add(classNode);
        }
    }

    private boolean isEnum(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
            if (!parent.getName().equals("java.lang.Enum")) continue;
            return true;
        }
        return false;
    }

    private void injectVersionProperty(ClassNode classNode) {
        boolean hasVersion = GrailsASTUtils.hasOrInheritsProperty(classNode, "version");
        if (!hasVersion) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainInjector] Adding property [version] to class [" + classNode.getName() + "]"));
            }
            classNode.addProperty("version", 1, new ClassNode(Long.class), null, null, null);
        }
    }

    private void injectIdProperty(ClassNode classNode) {
        boolean hasId = GrailsASTUtils.hasOrInheritsProperty(classNode, "id");
        if (!hasId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainInjector] Adding property [id] to class [" + classNode.getName() + "]"));
            }
            classNode.addProperty("id", 1, new ClassNode(Long.class), null, null, null);
        }
    }
}

