/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation.metaclass;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.ProxyMetaClass;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstrainedPropertyBuilder;
import org.codehaus.groovy.grails.validation.metaclass.ConstraintsDynamicProperty;

public class ConstraintsEvaluatingDynamicProperty
extends AbstractDynamicProperty {
    private static final String CONSTRAINTS_GROOVY = "Constraints.groovy";
    private static final Log LOG = LogFactory.getLog(ConstraintsDynamicProperty.class);
    public static final String PROPERTY_NAME = "constraints";
    private GrailsDomainClassProperty[] properties;

    public ConstraintsEvaluatingDynamicProperty(GrailsDomainClassProperty[] properties) {
        super(PROPERTY_NAME);
        this.properties = properties;
    }

    public ConstraintsEvaluatingDynamicProperty() {
        super(PROPERTY_NAME);
    }

    public Object get(Object object) {
        GroovyObject go;
        if (object instanceof GroovyObject && (go = (GroovyObject)object).getMetaClass() instanceof ProxyMetaClass) {
            go.setMetaClass(((ProxyMetaClass)go.getMetaClass()).getAdaptee());
        }
        LinkedList<Class> classChain = new LinkedList<Class>();
        for (Class clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            classChain.addFirst(clazz);
        }
        ConstrainedPropertyBuilder delegate = new ConstrainedPropertyBuilder(object);
        for (Class clazz : classChain) {
            Closure c = (Closure)GrailsClassUtils.getStaticPropertyValue(clazz, PROPERTY_NAME);
            if (c == null) {
                c = this.getConstraintsFromScript(object);
            }
            if (c != null) {
                c.setDelegate((Object)delegate);
                c.call();
                continue;
            }
            LOG.debug((Object)("User-defined constraints not found on class [" + clazz + "], applying default constraints"));
        }
        Map constrainedProperties = delegate.getConstrainedProperties();
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                GrailsDomainClassProperty p = this.properties[i];
                ConstrainedProperty cp = (ConstrainedProperty)constrainedProperties.get(p.getName());
                if (cp == null) {
                    cp = new ConstrainedProperty(p.getDomainClass().getClazz(), p.getName(), p.getType());
                    cp.setOrder(constrainedProperties.size() + 1);
                    constrainedProperties.put(p.getName(), cp);
                }
                if (cp.hasAppliedConstraint("nullable") || p.getName().equals("dateCreated") || p.getName().equals("lastUpdated") || (p.isOneToOne() || p.isManyToOne()) && p.isCircular()) continue;
                cp.applyConstraint("nullable", p.isOptional() || Collection.class.isAssignableFrom(p.getType()) || Map.class.isAssignableFrom(p.getType()));
            }
        }
        return constrainedProperties;
    }

    private Closure getConstraintsFromScript(Object object) {
        String className = object.getClass().getName();
        String constraintsScript = className.replaceAll("\\.", "/") + CONSTRAINTS_GROOVY;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(constraintsScript);
        if (stream != null) {
            GroovyClassLoader gcl = new GroovyClassLoader();
            try {
                Class scriptClass = gcl.parseClass(stream);
                Script script = (Script)scriptClass.newInstance();
                script.run();
                Binding binding = script.getBinding();
                if (binding.getVariables().containsKey(PROPERTY_NAME)) {
                    return (Closure)binding.getVariable(PROPERTY_NAME);
                }
                LOG.warn((Object)("Unable to evaluate constraints from [" + constraintsScript + "], constraints closure not found!"));
                return null;
            }
            catch (CompilationFailedException e) {
                LOG.error((Object)("Compilation error evaluating constraints for class [" + object.getClass() + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Instantiation error evaluating constraints for class [" + object.getClass() + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Illegal access error evaluating constraints for class [" + object.getClass() + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void set(Object object, Object newValue) {
        throw new UnsupportedOperationException("Cannot set read-only property [constraints]");
    }
}

