/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import java.util.List;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.codehaus.groovy.grails.validation.routines.RegexValidator;
import org.codehaus.groovy.grails.validation.routines.UrlValidator;
import org.springframework.validation.Errors;

class UrlConstraint
extends AbstractConstraint {
    private boolean url;
    private UrlValidator validator;

    UrlConstraint() {
    }

    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    public void setParameter(Object constraintParameter) {
        RegexValidator domainValidator = null;
        if (constraintParameter instanceof Boolean) {
            this.url = (Boolean)constraintParameter;
        } else if (constraintParameter instanceof String) {
            this.url = true;
            domainValidator = new RegexValidator((String)constraintParameter);
        } else if (constraintParameter instanceof List) {
            this.url = true;
            List regexpList = (List)constraintParameter;
            domainValidator = new RegexValidator(regexpList.toArray(new String[regexpList.size()]));
        } else {
            throw new IllegalArgumentException("Parameter for constraint [url] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean, string, or list value");
        }
        this.validator = new UrlValidator(domainValidator, 3L);
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "url";
    }

    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.url && !this.validator.isValid(propertyValue.toString())) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
            super.rejectValue(target, errors, "default.invalid.url.message", "url.invalid", args);
        }
    }
}

