/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GrailsTestSuite
extends TestSuite {
    private static final String CLEANING_ORDER_PROPERTY = "cleaningOrder";
    private static final String TRANSACTIONAL = "transactional";
    private ApplicationContext applicationContext = null;
    private List cleaningOrder;
    private Class testClass;

    public GrailsTestSuite(ApplicationContext applicationContext, Class clazz) {
        super(clazz);
        this.applicationContext = applicationContext;
        Object order = GrailsClassUtils.getStaticPropertyValue(clazz, CLEANING_ORDER_PROPERTY);
        if (order != null && List.class.isAssignableFrom(order.getClass())) {
            this.cleaningOrder = (List)order;
        }
        this.testClass = clazz;
    }

    public void runTest(Test test, TestResult result) {
        if (test instanceof TestCase && this.applicationContext != null) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)test, 1, false);
        }
        if (test instanceof ApplicationContextAware && this.applicationContext != null) {
            ((ApplicationContextAware)test).setApplicationContext(this.applicationContext);
        }
        test.run(result);
    }

    public List getCleaningOrder() {
        return this.cleaningOrder != null ? this.cleaningOrder : new ArrayList();
    }

    public boolean isTransactional() {
        Object val = GrailsClassUtils.getPropertyValueOfNewInstance(this.testClass, TRANSACTIONAL);
        return !(val instanceof Boolean) || (Boolean)val != false;
    }
}

