/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DevelopmentResourceLoader
extends DefaultResourceLoader {
    private GrailsApplication application;
    private String baseLocation = ".";

    public DevelopmentResourceLoader(GrailsApplication application) {
        Assert.notNull((Object)application, (String)"Argument [application] is required");
        this.application = application;
    }

    public DevelopmentResourceLoader(GrailsApplication application, String baseLocation) {
        this(application);
        this.baseLocation = baseLocation;
    }

    public Resource getResource(String location) {
        if (this.application.isWarDeployed()) {
            return super.getResource(location);
        }
        location = this.getRealLocationInProject(location);
        return super.getResource(location);
    }

    protected String getRealLocationInProject(String location) {
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        if (location.startsWith("/WEB-INF")) {
            return "file:" + this.baseLocation + "/" + location.substring("/WEB-INF".length() + 1);
        }
        return "web-app" + location;
    }
}

