/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.support.aware;

import groovy.lang.GroovyObject;
import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.plugins.AbstractGrailsPlugin;
import org.codehaus.groovy.grails.plugins.support.aware.ClassLoaderAware;
import org.codehaus.groovy.grails.plugins.support.aware.ClassLoaderAwareBeanPostProcessor;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class AwarePlugin
extends AbstractGrailsPlugin {
    public AwarePlugin(Class pluginClass, GrailsApplication application) {
        super(pluginClass, application);
    }

    public void doWithApplicationContext(ApplicationContext applicationContext) {
        this.registerGrailsApplicationAwareBeanPostProcessor(applicationContext, this.application);
        this.registerClassLoaderAwareBeanPostProcessor(applicationContext, (ClassLoader)this.application.getClassLoader());
    }

    protected void registerGrailsApplicationAwareBeanPostProcessor(ApplicationContext applicationContext, GrailsApplication grailsApplication) {
        if (applicationContext instanceof GenericApplicationContext) {
            GenericApplicationContext ctx = (GenericApplicationContext)applicationContext;
            ctx.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new GrailsApplicationAwareBeanPostProcessor(grailsApplication));
            ctx.getBeanFactory().ignoreDependencyInterface(GrailsApplicationAware.class);
        }
    }

    protected void registerClassLoaderAwareBeanPostProcessor(ApplicationContext applicationContext, ClassLoader classLoader) {
        if (applicationContext instanceof GenericApplicationContext) {
            GenericApplicationContext ctx = (GenericApplicationContext)applicationContext;
            ctx.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new ClassLoaderAwareBeanPostProcessor(classLoader));
            ctx.getBeanFactory().ignoreDependencyInterface(ClassLoaderAware.class);
        }
    }

    public void doWithRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
    }

    public GroovyObject getInstance() {
        throw new UnsupportedOperationException("Method [getInstance] not supported on AwarePlugin");
    }

    public void doWithDynamicMethods(ApplicationContext applicationContext) {
    }

    public boolean isEnabled() {
        return true;
    }

    public String[] getObservedPluginNames() {
        return new String[0];
    }

    public void notifyOfEvent(Map event) {
    }

    public Map notifyOfEvent(int eventKind, Object source) {
        return Collections.EMPTY_MAP;
    }

    public void doArtefactConfiguration() {
    }

    public Class[] getProvidedArtefacts() {
        return new Class[0];
    }
}

