/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.GrailsUtil;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.WebRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.plugins.AbstractGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.CorePluginFinder;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.IdentityPluginFilter;
import org.codehaus.groovy.grails.plugins.PluginFilter;
import org.codehaus.groovy.grails.plugins.PluginFilterRetriever;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.grails.support.ParentApplicationContextAware;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultGrailsPluginManager
extends AbstractGrailsPluginManager
implements GrailsPluginManager {
    private static final Log LOG = LogFactory.getLog(DefaultGrailsPluginManager.class);
    private static final Class[] COMMON_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Class.class, Double.class, Float.class, Integer.class, Long.class, Number.class, Short.class, String.class, BigInteger.class, BigDecimal.class, URL.class, URI.class};
    private final GrailsPluginChangeChecker pluginChangeScanner = new GrailsPluginChangeChecker(this);
    private static final int SCAN_INTERVAL = 1000;
    private List delayedLoadPlugins = new LinkedList();
    private ApplicationContext parentCtx;
    private PathMatchingResourcePatternResolver resolver;
    private Map delayedEvictions = new HashMap();
    private ServletContext servletContext;
    private Map pluginToObserverMap = new HashMap();
    private long configLastModified;
    private PluginFilter pluginFilter;
    private static final String GRAILS_PLUGIN_SUFFIX = "GrailsPlugin";

    public DefaultGrailsPluginManager(String resourcePath, GrailsApplication application) throws IOException {
        super(application);
        if (application == null) {
            throw new IllegalArgumentException("Argument [application] cannot be null!");
        }
        this.resolver = new PathMatchingResourcePatternResolver();
        try {
            this.pluginResources = this.resolver.getResources(resourcePath);
        }
        catch (IOException ioe) {
            LOG.debug((Object)("Unable to load plugins for resource path " + resourcePath), (Throwable)ioe);
        }
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(String[] pluginResources, GrailsApplication application) {
        super(application);
        this.resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i = 0; i < pluginResources.length; ++i) {
            String resourcePath = pluginResources[i];
            try {
                Resource[] resources = this.resolver.getResources(resourcePath);
                for (int j = 0; j < resources.length; ++j) {
                    Resource resource = resources[j];
                    resourceList.add(resource);
                }
                continue;
            }
            catch (IOException ioe) {
                LOG.debug((Object)("Unable to load plugins for resource path " + resourcePath), (Throwable)ioe);
            }
        }
        this.pluginResources = resourceList.toArray(new Resource[resourceList.size()]);
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Class[] plugins, GrailsApplication application) throws IOException {
        super(application);
        this.pluginClasses = plugins;
        this.resolver = new PathMatchingResourcePatternResolver();
        this.application = application;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application) {
        super(application);
        this.resolver = new PathMatchingResourcePatternResolver();
        this.pluginResources = pluginFiles;
        this.application = application;
        this.setPluginFilter();
    }

    private void setPluginFilter() {
        this.pluginFilter = new PluginFilterRetriever().getPluginFilter(this.application.getConfig().toProperties());
    }

    public void startPluginChangeScanner() {
        if (this.pluginChangeScanner.isAlive()) {
            throw new IllegalStateException("Plugin change scanner is already running!");
        }
        this.pluginChangeScanner.start();
        LOG.info((Object)"Started to scan for plugin changes in every 1000ms.");
    }

    public void refreshPlugin(String name) {
        if (this.hasGrailsPlugin(name)) {
            GrailsPlugin plugin = this.getGrailsPlugin(name);
            plugin.refresh();
        }
    }

    public Collection getPluginObservers(GrailsPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Argument [plugin] cannot be null");
        }
        Collection c = (Collection)this.pluginToObserverMap.get(plugin.getName());
        Collection wildcardObservers = (Collection)this.pluginToObserverMap.get("*");
        if (wildcardObservers != null) {
            if (c != null) {
                c.addAll(wildcardObservers);
            } else {
                c = wildcardObservers;
            }
        }
        if (c != null) {
            c.remove(plugin);
            return c;
        }
        return Collections.EMPTY_SET;
    }

    public void informObservers(String pluginName, Map event) {
        GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        if (plugin != null) {
            Collection observers = this.getPluginObservers(plugin);
            for (GrailsPlugin observingPlugin : observers) {
                observingPlugin.notifyOfEvent(event);
            }
        }
    }

    public void loadPlugins() throws PluginException {
        if (!this.initialised) {
            GroovyClassLoader gcl = this.application.getClassLoader();
            this.attemptLoadPlugins(gcl);
            if (!this.delayedLoadPlugins.isEmpty()) {
                this.loadDelayedPlugins();
            }
            if (!this.delayedEvictions.isEmpty()) {
                this.processDelayedEvictions();
            }
            this.initializePlugins();
            this.initialised = true;
        }
    }

    private void attemptLoadPlugins(GroovyClassLoader gcl) {
        List grailsCorePlugins = this.findCorePlugins();
        List grailsUserPlugins = this.findUserPlugins(gcl);
        ArrayList allPlugins = new ArrayList(grailsCorePlugins);
        allPlugins.addAll(grailsUserPlugins);
        List filteredPlugins = this.getPluginFilter().filterPluginList(allPlugins);
        ArrayList<GrailsPlugin> orderedCorePlugins = new ArrayList<GrailsPlugin>();
        ArrayList<GrailsPlugin> orderedUserPlugins = new ArrayList<GrailsPlugin>();
        for (GrailsPlugin plugin : filteredPlugins) {
            if (grailsCorePlugins.contains(plugin)) {
                orderedCorePlugins.add(plugin);
                continue;
            }
            orderedUserPlugins.add(plugin);
        }
        ArrayList<GrailsPlugin> orderedPlugins = new ArrayList<GrailsPlugin>();
        orderedPlugins.addAll(orderedCorePlugins);
        orderedPlugins.addAll(orderedUserPlugins);
        for (GrailsPlugin plugin : orderedPlugins) {
            this.attemptPluginLoad(plugin);
        }
    }

    private List findCorePlugins() {
        CorePluginFinder finder = new CorePluginFinder(this.application);
        Set classes = finder.getPluginClasses();
        Iterator classesIterator = classes.iterator();
        ArrayList<DefaultGrailsPlugin> grailsCorePlugins = new ArrayList<DefaultGrailsPlugin>();
        while (classesIterator.hasNext()) {
            Class pluginClass = (Class)classesIterator.next();
            if (pluginClass == null || Modifier.isAbstract(pluginClass.getModifiers()) || pluginClass == DefaultGrailsPlugin.class) continue;
            DefaultGrailsPlugin plugin = new DefaultGrailsPlugin(pluginClass, this.application);
            plugin.setApplicationContext(this.applicationContext);
            grailsCorePlugins.add(plugin);
        }
        return grailsCorePlugins;
    }

    private List findUserPlugins(GroovyClassLoader gcl) {
        int i;
        ArrayList<DefaultGrailsPlugin> grailsUserPlugins = new ArrayList<DefaultGrailsPlugin>();
        LOG.info((Object)("Attempting to load [" + this.pluginResources.length + "] user defined plugins"));
        for (i = 0; i < this.pluginResources.length; ++i) {
            Resource r = this.pluginResources[i];
            Class pluginClass = this.loadPluginClass(gcl, r);
            if (this.isGrailsPlugin(pluginClass)) {
                DefaultGrailsPlugin plugin = new DefaultGrailsPlugin(pluginClass, r, this.application);
                grailsUserPlugins.add(plugin);
                continue;
            }
            LOG.warn((Object)("Class [" + pluginClass + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!"));
        }
        for (i = 0; i < this.pluginClasses.length; ++i) {
            Class pluginClass = this.pluginClasses[i];
            if (this.isGrailsPlugin(pluginClass)) {
                DefaultGrailsPlugin plugin = new DefaultGrailsPlugin(pluginClass, this.application);
                grailsUserPlugins.add(plugin);
                continue;
            }
            LOG.warn((Object)("Class [" + pluginClass + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!"));
        }
        return grailsUserPlugins;
    }

    private boolean isGrailsPlugin(Class pluginClass) {
        return pluginClass != null && pluginClass.getName().endsWith(GRAILS_PLUGIN_SUFFIX);
    }

    private void processDelayedEvictions() {
        for (GrailsPlugin plugin : this.delayedEvictions.keySet()) {
            String[] pluginToEvict = (String[])this.delayedEvictions.get(plugin);
            for (int j = 0; j < pluginToEvict.length; ++j) {
                String pluginName = pluginToEvict[j];
                this.evictPlugin(plugin, pluginName);
            }
        }
    }

    private void initializePlugins() {
        for (Object plugin : this.plugins.values()) {
            if (!(plugin instanceof ApplicationContextAware)) continue;
            ((ApplicationContextAware)plugin).setApplicationContext(this.applicationContext);
        }
    }

    private void loadDelayedPlugins() {
        while (!this.delayedLoadPlugins.isEmpty()) {
            GrailsPlugin plugin = (GrailsPlugin)this.delayedLoadPlugins.remove(0);
            if (this.areDependenciesResolved(plugin)) {
                if (!this.hasValidPluginsToLoadBefore(plugin)) {
                    this.registerPlugin(plugin);
                    continue;
                }
                this.delayedLoadPlugins.add(plugin);
                continue;
            }
            boolean foundInDelayed = false;
            for (GrailsPlugin remainingPlugin : this.delayedLoadPlugins) {
                if (!this.isDependentOn(plugin, remainingPlugin)) continue;
                foundInDelayed = true;
                break;
            }
            if (foundInDelayed) {
                this.delayedLoadPlugins.add(plugin);
                continue;
            }
            this.failedPlugins.put(plugin.getName(), plugin);
            LOG.warn((Object)("WARNING: Plugin [" + plugin.getName() + "] cannot be loaded because its dependencies [" + ArrayUtils.toString((Object)plugin.getDependencyNames()) + "] cannot be resolved"));
        }
    }

    private boolean hasValidPluginsToLoadBefore(GrailsPlugin plugin) {
        String[] loadAfterNames = plugin.getLoadAfterNames();
        for (GrailsPlugin other : this.delayedLoadPlugins) {
            for (int j = 0; j < loadAfterNames.length; ++j) {
                String name = loadAfterNames[j];
                if (!other.getName().equals(name)) continue;
                return this.hasDelayedDependencies(other) || this.areDependenciesResolved(other);
            }
        }
        return false;
    }

    private boolean hasDelayedDependencies(GrailsPlugin other) {
        String[] dependencyNames = other.getDependencyNames();
        for (int i = 0; i < dependencyNames.length; ++i) {
            String dependencyName = dependencyNames[i];
            for (GrailsPlugin grailsPlugin : this.delayedLoadPlugins) {
                if (!grailsPlugin.getName().equals(dependencyName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDependentOn(GrailsPlugin plugin, GrailsPlugin dependancy) {
        String[] dependencies = plugin.getDependencyNames();
        for (int i = 0; i < dependencies.length; ++i) {
            String name = dependencies[i];
            String requiredVersion = plugin.getDependentVersion(name);
            if (!name.equals(dependancy.getName()) || !GrailsPluginUtils.isValidVersion(dependancy.getVersion(), requiredVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean areDependenciesResolved(GrailsPlugin plugin) {
        String[] dependencies = plugin.getDependencyNames();
        if (dependencies.length > 0) {
            for (int i = 0; i < dependencies.length; ++i) {
                String name = dependencies[i];
                String version = plugin.getDependentVersion(name);
                if (this.hasGrailsPlugin(name, version)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areNoneToLoadBefore(GrailsPlugin plugin) {
        String[] loadAfterNames = plugin.getLoadAfterNames();
        if (loadAfterNames.length > 0) {
            for (int i = 0; i < loadAfterNames.length; ++i) {
                String name = loadAfterNames[i];
                if (this.getGrailsPlugin(name) != null) continue;
                return false;
            }
        }
        return true;
    }

    private Class loadPluginClass(GroovyClassLoader gcl, Resource r) {
        Class pluginClass;
        try {
            pluginClass = gcl.parseClass(r.getInputStream());
        }
        catch (CompilationFailedException e) {
            throw new PluginException("Error compiling plugin [" + r.getFilename() + "] " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PluginException("Error reading plugin [" + r.getFilename() + "] " + e.getMessage(), e);
        }
        return pluginClass;
    }

    private void attemptPluginLoad(GrailsPlugin plugin) {
        if (this.areDependenciesResolved(plugin) && this.areNoneToLoadBefore(plugin)) {
            this.registerPlugin(plugin);
        } else {
            this.delayedLoadPlugins.add(plugin);
        }
    }

    private void registerPlugin(GrailsPlugin plugin) {
        if (plugin.isEnabled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Grails plug-in [" + plugin.getName() + "] with version [" + plugin.getVersion() + "] loaded successfully"));
            }
            if (plugin instanceof ParentApplicationContextAware) {
                ((ParentApplicationContextAware)((Object)plugin)).setParentApplicationContext(this.parentCtx);
            }
            plugin.setManager(this);
            String[] evictionNames = plugin.getEvictionNames();
            if (evictionNames.length > 0) {
                this.delayedEvictions.put(plugin, evictionNames);
            }
            String[] observedPlugins = plugin.getObservedPluginNames();
            for (int i = 0; i < observedPlugins.length; ++i) {
                String observedPlugin = observedPlugins[i];
                HashSet<GrailsPlugin> observers = (HashSet<GrailsPlugin>)this.pluginToObserverMap.get(observedPlugin);
                if (observers == null) {
                    observers = new HashSet<GrailsPlugin>();
                    this.pluginToObserverMap.put(observedPlugin, observers);
                }
                observers.add(plugin);
            }
            this.pluginList.add(plugin);
            this.plugins.put(plugin.getName(), plugin);
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Grails plugin " + plugin + " is disabled and was not loaded"));
        }
    }

    protected void evictPlugin(GrailsPlugin evictor, String evicteeName) {
        GrailsPlugin pluginToEvict = (GrailsPlugin)this.plugins.get(evicteeName);
        if (pluginToEvict != null) {
            this.pluginList.remove(pluginToEvict);
            this.plugins.remove(pluginToEvict.getName());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Grails plug-in " + pluginToEvict + " was evicted by " + evictor));
            }
        }
    }

    private boolean hasGrailsPlugin(String name, String version) {
        return this.getGrailsPlugin(name, version) != null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        for (GrailsPlugin plugin : this.pluginList) {
            plugin.setApplicationContext(applicationContext);
        }
    }

    public void setParentApplicationContext(ApplicationContext parent) {
        this.parentCtx = parent;
    }

    public void checkForChanges() {
        this.checkForConfigChanges();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.checkForChanges()) continue;
            LOG.info((Object)("Plugin " + plugin + " changed, re-registering beans..."));
            this.reloadPlugin(plugin);
        }
    }

    private void checkForConfigChanges() {
        ConfigObject config = this.application.getConfig();
        URL configURL = config.getConfigFile();
        if (configURL != null) {
            URLConnection connection;
            try {
                connection = configURL.openConnection();
            }
            catch (IOException e) {
                LOG.error((Object)("I/O error obtaining URL connection for configuration [" + configURL + "]: " + e.getMessage()), (Throwable)e);
                return;
            }
            long lastModified = connection.getLastModified();
            if (this.configLastModified == 0L) {
                this.configLastModified = lastModified;
            } else if (this.configLastModified < lastModified) {
                LOG.info((Object)("Configuration [" + configURL + "] changed, reloading changes.."));
                ConfigSlurper slurper = new ConfigSlurper(GrailsUtil.getEnvironment());
                try {
                    config = slurper.parse(configURL);
                    ConfigurationHolder.setConfig(config);
                    this.configLastModified = lastModified;
                    this.informPluginsOfConfigChange();
                }
                catch (GroovyRuntimeException gre) {
                    LOG.error((Object)("Unable to reload configuration. Please correct problem and try again: " + gre.getMessage()), (Throwable)gre);
                }
            }
        }
    }

    private void informPluginsOfConfigChange() {
        LOG.info((Object)"Informing plug-ins of configuration change..");
        for (GrailsPlugin plugin : this.pluginList) {
            plugin.notifyOfEvent(1, this.application.getConfig());
        }
    }

    private void reloadPlugin(GrailsPlugin plugin) {
        plugin.doArtefactConfiguration();
        WebRuntimeSpringConfiguration springConfig = new WebRuntimeSpringConfiguration(this.parentCtx);
        springConfig.setServletContext(this.getServletContext());
        this.doRuntimeConfiguration(plugin.getName(), (RuntimeSpringConfiguration)springConfig);
        springConfig.registerBeansWithContext((GenericApplicationContext)((StaticApplicationContext)this.applicationContext));
        plugin.doWithApplicationContext(this.applicationContext);
        plugin.doWithDynamicMethods(this.applicationContext);
    }

    public void doWebDescriptor(Resource descriptor, Writer target) {
        try {
            this.doWebDescriptor(descriptor.getInputStream(), target);
        }
        catch (IOException e) {
            throw new PluginException("Unable to read web.xml [" + descriptor + "]: " + e.getMessage(), e);
        }
    }

    private void doWebDescriptor(InputStream inputStream, Writer target) {
        this.checkInitialised();
        try {
            XmlSlurper slurper = new XmlSlurper();
            slurper.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                        return new InputSource(new StringReader(DefaultGrailsPluginManager.getWeb23DTD()));
                    }
                    return null;
                }
            });
            GPathResult result = slurper.parse(inputStream);
            for (GrailsPlugin plugin : this.pluginList) {
                plugin.doWithWebDescriptor(result);
            }
            GrailsUtil.writeSlurperResult(result, target);
        }
        catch (ParserConfigurationException e) {
            throw new PluginException("Unable to configure web.xml due to parser configuration problem: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new PluginException("XML parsing error configuring web.xml: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PluginException("Unable to read web.xml" + e.getMessage(), e);
        }
    }

    public void doWebDescriptor(File descriptor, Writer target) {
        try {
            this.doWebDescriptor(new FileInputStream(descriptor), target);
        }
        catch (FileNotFoundException e) {
            throw new PluginException("Unable to read web.xml [" + descriptor + "]: " + e.getMessage(), e);
        }
    }

    public void setApplication(GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException("Argument [application] cannot be null");
        }
        this.application = application;
        for (GrailsPlugin plugin : this.pluginList) {
            plugin.setApplication(application);
        }
    }

    public void doDynamicMethods() {
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (int i = 0; i < COMMON_CLASSES.length; ++i) {
            Class commonClass = COMMON_CLASSES[i];
            registry.removeMetaClass(commonClass);
        }
        for (GrailsPlugin plugin : this.pluginList) {
            try {
                plugin.doWithDynamicMethods(this.applicationContext);
            }
            catch (Throwable t) {
                GrailsUtil.deepSanitize(t);
                LOG.error((Object)("Error configuring dynamic methods for plugin " + plugin + ": " + t.getMessage()), t);
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    void setPluginFilter(PluginFilter pluginFilter) {
        this.pluginFilter = pluginFilter;
    }

    private PluginFilter getPluginFilter() {
        if (this.pluginFilter == null) {
            this.pluginFilter = new IdentityPluginFilter();
        }
        return this.pluginFilter;
    }

    List getPluginList() {
        return Collections.unmodifiableList(this.pluginList);
    }

    public static String getWeb23DTD() {
        return "<!--\nDO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.\n\nCopyright 2000-2007 Sun Microsystems, Inc. All rights reserved.\n\nThe contents of this file are subject to the terms of either the GNU\nGeneral Public License Version 2 only (\"GPL\") or the Common Development\nand Distribution License(\"CDDL\") (collectively, the \"License\").  You\nmay not use this file except in compliance with the License. You can obtain\na copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html\nor glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific\nlanguage governing permissions and limitations under the License.\n\nWhen distributing the software, include this License Header Notice in each\nfile and include the License file at glassfish/bootstrap/legal/LICENSE.txt.\nSun designates this particular file as subject to the \"Classpath\" exception\nas provided by Sun in the GPL Version 2 section of the License file that\naccompanied this code.  If applicable, add the following below the License\nHeader, with the fields enclosed by brackets [] replaced by your own\nidentifying information: \"Portions Copyrighted [year]\n[name of copyright owner]\"\n\nContributor(s):\n\nIf you wish your version of this file to be governed by only the CDDL or\nonly the GPL Version 2, indicate your decision by adding \"[Contributor]\nelects to include this software in this distribution under the [CDDL or GPL\nVersion 2] license.\"  If you don't indicate a single choice of license, a\nrecipient has the option to distribute your version of this file under\neither the CDDL, the GPL Version 2 or to extend the choice of license to\nits licensees as provided above.  However, if you add GPL Version 2 code\nand therefore, elected the GPL Version 2 license, then the option applies\nonly if the new code is made subject to such option by the copyright\nholder.\n-->\n\n<!--\nThis is the XML DTD for the Servlet 2.3 deployment descriptor.\nAll Servlet 2.3 deployment descriptors must include a DOCTYPE\nof the following form:\n\n  <!DOCTYPE web-app PUBLIC\n\t\"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\n\t\"http://java.sun.com/dtd/web-app_2_3.dtd\">\n\n-->\n\n<!--\nThe following conventions apply to all J2EE deployment descriptor\nelements unless indicated otherwise.\n\n- In elements that contain PCDATA, leading and trailing whitespace\n  in the data may be ignored.\n\n- In elements whose value is an \"enumerated type\", the value is\n  case sensitive.\n\n- In elements that specify a pathname to a file within the same\n  JAR file, relative filenames (i.e., those not starting with \"/\")\n  are considered relative to the root of the JAR file's namespace.\n  Absolute filenames (i.e., those starting with \"/\") also specify\n  names in the root of the JAR file's namespace.  In general, relative\n  names are preferred.  The exception is .war files where absolute\n  names are preferred for consistency with the servlet API.\n-->\n\n\n<!--\nThe web-app element is the root of the deployment descriptor for\na web application.\n-->\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\ncontext-param*, filter*, filter-mapping*, listener*, servlet*,\nservlet-mapping*, session-config?, mime-mapping*, welcome-file-list?,\nerror-page*, taglib*, resource-env-ref*, resource-ref*, security-constraint*,\nlogin-config?, security-role*, env-entry*, ejb-ref*,  ejb-local-ref*)>\n\n<!--\nThe auth-constraint element indicates the user roles that should\nbe permitted access to this resource collection. The role-name\nused here must either correspond to the role-name of one of the\nsecurity-role elements defined for this web application, or be\nthe specially reserved role-name \"*\" that is a compact syntax for\nindicating all roles in the web application. If both \"*\" and\nrolenames appear, the container interprets this as all roles.\nIf no roles are defined, no user is allowed access to the portion of\nthe web application described by the containing security-constraint.\nThe container matches role names case sensitively when determining\naccess.\n\n\nUsed in: security-constraint\n-->\n<!ELEMENT auth-constraint (description?, role-name*)>\n\n<!--\nThe auth-method element is used to configure the authentication\nmechanism for the web application. As a prerequisite to gaining access to any web resources which are protected by an authorization\nconstraint, a user must have authenticated using the configured\nmechanism. Legal values for this element are \"BASIC\", \"DIGEST\",\n\"FORM\", or \"CLIENT-CERT\".\n\nUsed in: login-config\n-->\n<!ELEMENT auth-method (#PCDATA)>\n\n<!--\nThe context-param element contains the declaration of a web\napplication's servlet context initialization parameters.\n\nUsed in: web-app\n-->\n<!ELEMENT context-param (param-name, param-value, description?)>\n\n<!--\nThe description element is used to provide text describing the parent\nelement.  The description element should include any information that\nthe web application war file producer wants to provide to the consumer of\nthe web application war file (i.e., to the Deployer). Typically, the tools\nused by the web application war file consumer will display the description\nwhen processing the parent element that contains the description.\n\nUsed in: auth-constraint, context-param, ejb-local-ref, ejb-ref,\nenv-entry, filter, init-param, resource-env-ref, resource-ref, run-as,\nsecurity-role, security-role-ref, servlet, user-data-constraint,\nweb-app, web-resource-collection\n-->\n<!ELEMENT description (#PCDATA)>\n\n<!--\nThe display-name element contains a short name that is intended to be\ndisplayed by tools.  The display name need not be unique.\n\nUsed in: filter, security-constraint, servlet, web-app\n\nExample:\n\n<display-name>Employee Self Service</display-name>\n-->\n<!ELEMENT display-name (#PCDATA)>\n\n<!--\nThe distributable element, by its presence in a web application\ndeployment descriptor, indicates that this web application is\nprogrammed appropriately to be deployed into a distributed servlet\ncontainer\n\nUsed in: web-app\n-->\n<!ELEMENT distributable EMPTY>\n\n<!--\nThe ejb-link element is used in the ejb-ref or ejb-local-ref\nelements to specify that an EJB reference is linked to an\nenterprise bean.\n\nThe name in the ejb-link element is composed of a\npath name specifying the ejb-jar containing the referenced enterprise\nbean with the ejb-name of the target bean appended and separated from\nthe path name by \"#\".  The path name is relative to the war file\ncontaining the web application that is referencing the enterprise bean.\nThis allows multiple enterprise beans with the same ejb-name to be\nuniquely identified.\n\nUsed in: ejb-local-ref, ejb-ref\n\nExamples:\n\n\t<ejb-link>EmployeeRecord</ejb-link>\n\n\t<ejb-link>../products/product.jar#ProductEJB</ejb-link>\n\n-->\n<!ELEMENT ejb-link (#PCDATA)>\n\n<!--\nThe ejb-local-ref element is used for the declaration of a reference to\nan enterprise bean's local home. The declaration consists of:\n\n\t- an optional description\n\t- the EJB reference name used in the code of the web application\n\t  that's referencing the enterprise bean\n\t- the expected type of the referenced enterprise bean\n\t- the expected local home and local interfaces of the referenced\n\t  enterprise bean\n\t- optional ejb-link information, used to specify the referenced\n\t  enterprise bean\n\nUsed in: web-app\n-->\n<!ELEMENT ejb-local-ref (description?, ejb-ref-name, ejb-ref-type,\n\t\tlocal-home, local, ejb-link?)>\n\n<!--\nThe ejb-ref element is used for the declaration of a reference to\nan enterprise bean's home. The declaration consists of:\n\n\t- an optional description\n\t- the EJB reference name used in the code of\n\t  the web application that's referencing the enterprise bean\n\t- the expected type of the referenced enterprise bean\n\t- the expected home and remote interfaces of the referenced\n\t  enterprise bean\n\t- optional ejb-link information, used to specify the referenced\n\t  enterprise bean\n\nUsed in: web-app\n-->\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type,\n\t\thome, remote, ejb-link?)>\n\n<!--\nThe ejb-ref-name element contains the name of an EJB reference. The\nEJB reference is an entry in the web application's environment and is\nrelative to the java:comp/env context.  The name must be unique\nwithin the web application.\n\nIt is recommended that name is prefixed with \"ejb/\".\n\nUsed in: ejb-local-ref, ejb-ref\n\nExample:\n\n<ejb-ref-name>ejb/Payroll</ejb-ref-name>\n-->\n<!ELEMENT ejb-ref-name (#PCDATA)>\n\n<!--\nThe ejb-ref-type element contains the expected type of the\nreferenced enterprise bean.\n\nThe ejb-ref-type element must be one of the following:\n\n\t<ejb-ref-type>Entity</ejb-ref-type>\n\t<ejb-ref-type>Session</ejb-ref-type>\n\nUsed in: ejb-local-ref, ejb-ref\n-->\n<!ELEMENT ejb-ref-type (#PCDATA)>\n\n<!--\nThe env-entry element contains the declaration of a web application's\nenvironment entry. The declaration consists of an optional\ndescription, the name of the environment entry, and an optional\nvalue.  If a value is not specified, one must be supplied\nduring deployment.\n-->\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\nenv-entry-type)>\n\n<!--\nThe env-entry-name element contains the name of a web applications's\nenvironment entry.  The name is a JNDI name relative to the\njava:comp/env context.  The name must be unique within a web application.\n\nExample:\n\n<env-entry-name>minAmount</env-entry-name>\n\nUsed in: env-entry\n-->\n<!ELEMENT env-entry-name (#PCDATA)>\n\n<!--\nThe env-entry-type element contains the fully-qualified Java type of\nthe environment entry value that is expected by the web application's\ncode.\n\nThe following are the legal values of env-entry-type:\n\n\tjava.lang.Boolean\n\tjava.lang.Byte\n\tjava.lang.Character\n\tjava.lang.String\n\tjava.lang.Short\n\tjava.lang.Integer\n\tjava.lang.Long\n\tjava.lang.Float\n\tjava.lang.Double\n\nUsed in: env-entry\n-->\n<!ELEMENT env-entry-type (#PCDATA)>\n\n<!--\nThe env-entry-value element contains the value of a web application's\nenvironment entry. The value must be a String that is valid for the\nconstructor of the specified type that takes a single String\nparameter, or for java.lang.Character, a single character.\n\nExample:\n\n<env-entry-value>100.00</env-entry-value>\n\nUsed in: env-entry\n-->\n<!ELEMENT env-entry-value (#PCDATA)>\n\n<!--\nThe error-code contains an HTTP error code, ex: 404\n\nUsed in: error-page\n-->\n<!ELEMENT error-code (#PCDATA)>\n\n<!--\nThe error-page element contains a mapping between an error code\nor exception type to the path of a resource in the web application\n\nUsed in: web-app\n-->\n<!ELEMENT error-page ((error-code | exception-type), location)>\n\n<!--\nThe exception type contains a fully qualified class name of a\nJava exception type.\n\nUsed in: error-page\n-->\n<!ELEMENT exception-type (#PCDATA)>\n\n<!--\nThe extension element contains a string describing an\nextension. example: \"txt\"\n\nUsed in: mime-mapping\n-->\n<!ELEMENT extension (#PCDATA)>\n\n<!--\nDeclares a filter in the web application. The filter is mapped to\neither a servlet or a URL pattern in the filter-mapping element, using\nthe filter-name value to reference. Filters can access the\ninitialization parameters declared in the deployment descriptor at\nruntime via the FilterConfig interface.\n\nUsed in: web-app\n-->\n<!ELEMENT filter (icon?, filter-name, display-name?, description?,\nfilter-class, init-param*)>\n\n<!--\nThe fully qualified classname of the filter.\n\nUsed in: filter\n-->\n<!ELEMENT filter-class (#PCDATA)>\n\n<!--\nDeclaration of the filter mappings in this web application. The\ncontainer uses the filter-mapping declarations to decide which filters\nto apply to a request, and in what order. The container matches the\nrequest URI to a Servlet in the normal way. To determine which filters\nto apply it matches filter-mapping declarations either on servlet-name,\nor on url-pattern for each filter-mapping element, depending on which\nstyle is used. The order in which filters are invoked is the order in\nwhich filter-mapping declarations that match a request URI for a\nservlet appear in the list of filter-mapping elements.The filter-name\nvalue must be the value of the <filter-name> sub-elements of one of the\n<filter> declarations in the deployment descriptor.\n\nUsed in: web-app\n-->\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n\n<!--\nThe logical name of the filter. This name is used to map the filter.\nEach filter name is unique within the web application.\n\nUsed in: filter, filter-mapping\n-->\n<!ELEMENT filter-name (#PCDATA)>\n\n<!--\nThe form-error-page element defines the location in the web app\nwhere the error page that is displayed when login is not successful\ncan be found. The path begins with a leading / and is interpreted\nrelative to the root of the WAR.\n\nUsed in: form-login-config\n-->\n<!ELEMENT form-error-page (#PCDATA)>\n\n<!--\nThe form-login-config element specifies the login and error pages\nthat should be used in form based login. If form based authentication\nis not used, these elements are ignored.\n\nUsed in: login-config\n-->\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n\n<!--\nThe form-login-page element defines the location in the web app\nwhere the page that can be used for login can be found. The path\nbegins with a leading / and is interpreted relative to the root of the WAR.\n\nUsed in: form-login-config\n-->\n<!ELEMENT form-login-page (#PCDATA)>\n\n<!--\nThe home element contains the fully-qualified name of the enterprise\nbean's home interface.\n\nUsed in: ejb-ref\n\nExample:\n\n<home>com.aardvark.payroll.PayrollHome</home>\n-->\n<!ELEMENT home (#PCDATA)>\n\n<!--\nThe http-method contains an HTTP method (GET | POST |...).\n\nUsed in: web-resource-collection\n-->\n<!ELEMENT http-method (#PCDATA)>\n\n<!--\nThe icon element contains small-icon and large-icon elements that\nspecify the file names for small and a large GIF or JPEG icon images\nused to represent the parent element in a GUI tool.\n\nUsed in: filter, servlet, web-app\n-->\n<!ELEMENT icon (small-icon?, large-icon?)>\n\n<!--\nThe init-param element contains a name/value pair as an\ninitialization param of the servlet\n\nUsed in: filter, servlet\n-->\n<!ELEMENT init-param (param-name, param-value, description?)>\n\n<!--\nThe jsp-file element contains the full path to a JSP file within\nthe web application beginning with a `/'.\n\nUsed in: servlet\n-->\n<!ELEMENT jsp-file (#PCDATA)>\n\n<!--\nThe large-icon element contains the name of a file\ncontaining a large (32 x 32) icon image. The file\nname is a relative path within the web application's\nwar file.\n\nThe image may be either in the JPEG or GIF format.\nThe icon can be used by tools.\n\nUsed in: icon\n\nExample:\n\n<large-icon>employee-service-icon32x32.jpg</large-icon>\n-->\n<!ELEMENT large-icon (#PCDATA)>\n\n<!--\nThe listener element indicates the deployment properties for a web\napplication listener bean.\n\nUsed in: web-app\n-->\n<!ELEMENT listener (listener-class)>\n\n<!--\nThe listener-class element declares a class in the application must be\nregistered as a web application listener bean. The value is the fully qualified classname of the listener class.\n\n\nUsed in: listener\n-->\n<!ELEMENT listener-class (#PCDATA)>\n\n<!--\nThe load-on-startup element indicates that this servlet should be\nloaded (instantiated and have its init() called) on the startup\nof the web application. The optional contents of\nthese element must be an integer indicating the order in which\nthe servlet should be loaded. If the value is a negative integer,\nor the element is not present, the container is free to load the\nservlet whenever it chooses. If the value is a positive integer\nor 0, the container must load and initialize the servlet as the\napplication is deployed. The container must guarantee that\nservlets marked with lower integers are loaded before servlets\nmarked with higher integers. The container may choose the order\nof loading of servlets with the same load-on-start-up value.\n\nUsed in: servlet\n-->\n<!ELEMENT load-on-startup (#PCDATA)>\n\n<!--\n\nThe local element contains the fully-qualified name of the\nenterprise bean's local interface.\n\nUsed in: ejb-local-ref\n\n-->\n<!ELEMENT local (#PCDATA)>\n\n<!--\n\nThe local-home element contains the fully-qualified name of the\nenterprise bean's local home interface.\n\nUsed in: ejb-local-ref\n-->\n<!ELEMENT local-home (#PCDATA)>\n\n<!--\nThe location element contains the location of the resource in the web\napplication relative to the root of the web application. The value of\nthe location must have a leading `/'.\n\nUsed in: error-page\n-->\n<!ELEMENT location (#PCDATA)>\n\n<!--\nThe login-config element is used to configure the authentication\nmethod that should be used, the realm name that should be used for\nthis application, and the attributes that are needed by the form login\nmechanism.\n\nUsed in: web-app\n-->\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n\n<!--\nThe mime-mapping element defines a mapping between an extension\nand a mime type.\n\nUsed in: web-app\n-->\n<!ELEMENT mime-mapping (extension, mime-type)>\n\n<!--\nThe mime-type element contains a defined mime type. example:\n\"text/plain\"\n\nUsed in: mime-mapping\n-->\n<!ELEMENT mime-type (#PCDATA)>\n\n<!--\nThe param-name element contains the name of a parameter. Each parameter\nname must be unique in the web application.\n\n\nUsed in: context-param, init-param\n-->\n<!ELEMENT param-name (#PCDATA)>\n\n<!--\nThe param-value element contains the value of a parameter.\n\nUsed in: context-param, init-param\n-->\n<!ELEMENT param-value (#PCDATA)>\n\n<!--\nThe realm name element specifies the realm name to use in HTTP\nBasic authorization.\n\nUsed in: login-config\n-->\n<!ELEMENT realm-name (#PCDATA)>\n\n<!--\nThe remote element contains the fully-qualified name of the enterprise\nbean's remote interface.\n\nUsed in: ejb-ref\n\nExample:\n\n<remote>com.wombat.empl.EmployeeService</remote>\n-->\n<!ELEMENT remote (#PCDATA)>\n\n<!--\nThe res-auth element specifies whether the web application code signs\non programmatically to the resource manager, or whether the Container\nwill sign on to the resource manager on behalf of the web application. In the\nlatter case, the Container uses information that is supplied by the\nDeployer.\n\nThe value of this element must be one of the two following:\n\n\t<res-auth>Application</res-auth>\n\t<res-auth>Container</res-auth>\n\nUsed in: resource-ref\n-->\n<!ELEMENT res-auth (#PCDATA)>\n\n<!--\nThe res-ref-name element specifies the name of a resource manager\nconnection factory reference.  The name is a JNDI name relative to the\njava:comp/env context.  The name must be unique within a web application.\n\nUsed in: resource-ref\n-->\n<!ELEMENT res-ref-name (#PCDATA)>\n\n<!--\nThe res-sharing-scope element specifies whether connections obtained\nthrough the given resource manager connection factory reference can be\nshared. The value of this element, if specified, must be one of the\ntwo following:\n\n\t<res-sharing-scope>Shareable</res-sharing-scope>\n\t<res-sharing-scope>Unshareable</res-sharing-scope>\n\nThe default value is Shareable.\n\nUsed in: resource-ref\n-->\n<!ELEMENT res-sharing-scope (#PCDATA)>\n\n<!--\nThe res-type element specifies the type of the data source. The type\nis specified by the fully qualified Java language class or interface\nexpected to be implemented by the data source.\n\nUsed in: resource-ref\n-->\n<!ELEMENT res-type (#PCDATA)>\n\n<!--\nThe resource-env-ref element contains a declaration of a web application's\nreference to an administered object associated with a resource\nin the web application's environment.  It consists of an optional\ndescription, the resource environment reference name, and an\nindication of the resource environment reference type expected by\nthe web application code.\n\nUsed in: web-app\n\nExample:\n\n<resource-env-ref>\n    <resource-env-ref-name>jms/StockQueue</resource-env-ref-name>\n    <resource-env-ref-type>javax.jms.Queue</resource-env-ref-type>\n</resource-env-ref>\n-->\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name,\n\t\tresource-env-ref-type)>\n\n<!--\nThe resource-env-ref-name element specifies the name of a resource\nenvironment reference; its value is the environment entry name used in\nthe web application code.  The name is a JNDI name relative to the\njava:comp/env context and must be unique within a web application.\n\nUsed in: resource-env-ref\n-->\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n\n<!--\nThe resource-env-ref-type element specifies the type of a resource\nenvironment reference.  It is the fully qualified name of a Java\nlanguage class or interface.\n\nUsed in: resource-env-ref\n-->\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n\n<!--\nThe resource-ref element contains a declaration of a web application's\nreference to an external resource. It consists of an optional\ndescription, the resource manager connection factory reference name,\nthe indication of the resource manager connection factory type\nexpected by the web application code, the type of authentication\n(Application or Container), and an optional specification of the\nshareability of connections obtained from the resource (Shareable or\nUnshareable).\n\nUsed in: web-app\n\nExample:\n\n    <resource-ref>\n\t<res-ref-name>jdbc/EmployeeAppDB</res-ref-name>\n\t<res-type>javax.sql.DataSource</res-type>\n\t<res-auth>Container</res-auth>\n\t<res-sharing-scope>Shareable</res-sharing-scope>\n    </resource-ref>\n-->\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth,\n\t\tres-sharing-scope?)>\n\n<!--\nThe role-link element is a reference to a defined security role. The\nrole-link element must contain the name of one of the security roles\ndefined in the security-role elements.\n\nUsed in: security-role-ref\n-->\n<!ELEMENT role-link (#PCDATA)>\n\n<!--\nThe role-name element contains the name of a security role.\n\nThe name must conform to the lexical rules for an NMTOKEN.\n\nUsed in: auth-constraint, run-as, security-role, security-role-ref\n-->\n<!ELEMENT role-name (#PCDATA)>\n\n<!--\nThe run-as element specifies the run-as identity to be used for the\nexecution of the web application. It contains an optional description, and\nthe name of a security role.\n\nUsed in: servlet\n-->\n<!ELEMENT run-as (description?, role-name)>\n\n<!--\nThe security-constraint element is used to associate security\nconstraints with one or more web resource collections\n\nUsed in: web-app\n-->\n<!ELEMENT security-constraint (display-name?, web-resource-collection+,\nauth-constraint?, user-data-constraint?)>\n\n<!--\nThe security-role element contains the definition of a security\nrole. The definition consists of an optional description of the\nsecurity role, and the security role name.\n\nUsed in: web-app\n\nExample:\n\n    <security-role>\n\t<description>\n\t    This role includes all employees who are authorized\n\t    to access the employee service application.\n\t</description>\n\t<role-name>employee</role-name>\n    </security-role>\n-->\n<!ELEMENT security-role (description?, role-name)>\n\n<!--\nThe security-role-ref element contains the declaration of a security\nrole reference in the web application's code. The declaration consists\nof an optional description, the security role name used in the code,\nand an optional link to a security role. If the security role is not\nspecified, the Deployer must choose an appropriate security role.\n\nThe value of the role-name element must be the String used as the\nparameter to the EJBContext.isCallerInRole(String roleName) method\nor the HttpServletRequest.isUserInRole(String role) method.\n\nUsed in: servlet\n\n-->\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n\n<!--\nThe servlet element contains the declarative data of a\nservlet. If a jsp-file is specified and the load-on-startup element is\npresent, then the JSP should be precompiled and loaded.\n\nUsed in: web-app\n-->\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, run-as?, security-role-ref*)>\n\n<!--\nThe servlet-class element contains the fully qualified class name\nof the servlet.\n\nUsed in: servlet\n-->\n<!ELEMENT servlet-class (#PCDATA)>\n\n<!--\nThe servlet-mapping element defines a mapping between a servlet\nand a url pattern\n\nUsed in: web-app\n-->\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n\n<!--\nThe servlet-name element contains the canonical name of the\nservlet. Each servlet name is unique within the web application.\n\nUsed in: filter-mapping, servlet, servlet-mapping\n-->\n<!ELEMENT servlet-name (#PCDATA)>\n\n<!--\nThe session-config element defines the session parameters for\nthis web application.\n\nUsed in: web-app\n-->\n<!ELEMENT session-config (session-timeout?)>\n\n<!--\nThe session-timeout element defines the default session timeout\ninterval for all sessions created in this web application. The\nspecified timeout must be expressed in a whole number of minutes.\nIf the timeout is 0 or less, the container ensures the default\nbehaviour of sessions is never to time out.\n\nUsed in: session-config\n-->\n<!ELEMENT session-timeout (#PCDATA)>\n\n<!--\nThe small-icon element contains the name of a file\ncontaining a small (16 x 16) icon image. The file\nname is a relative path within the web application's\nwar file.\n\nThe image may be either in the JPEG or GIF format.\nThe icon can be used by tools.\n\nUsed in: icon\n\nExample:\n\n<small-icon>employee-service-icon16x16.jpg</small-icon>\n-->\n<!ELEMENT small-icon (#PCDATA)>\n\n<!--\nThe taglib element is used to describe a JSP tag library.\n\nUsed in: web-app\n-->\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n\n<!--\nthe taglib-location element contains the location (as a resource\nrelative to the root of the web application) where to find the Tag\nLibary Description file for the tag library.\n\nUsed in: taglib\n-->\n<!ELEMENT taglib-location (#PCDATA)>\n\n<!--\nThe taglib-uri element describes a URI, relative to the location\nof the web.xml document, identifying a Tag Library used in the Web\nApplication.\n\nUsed in: taglib\n-->\n<!ELEMENT taglib-uri (#PCDATA)>\n\n<!--\nThe transport-guarantee element specifies that the communication\nbetween client and server should be NONE, INTEGRAL, or\nCONFIDENTIAL. NONE means that the application does not require any\ntransport guarantees. A value of INTEGRAL means that the application\nrequires that the data sent between the client and server be sent in\nsuch a way that it can't be changed in transit. CONFIDENTIAL means\nthat the application requires that the data be transmitted in a\nfashion that prevents other entities from observing the contents of\nthe transmission. In most cases, the presence of the INTEGRAL or\nCONFIDENTIAL flag will indicate that the use of SSL is required.\n\nUsed in: user-data-constraint\n-->\n<!ELEMENT transport-guarantee (#PCDATA)>\n\n<!--\nThe url-pattern element contains the url pattern of the mapping. Must\nfollow the rules specified in Section 11.2 of the Servlet API\nSpecification.\n\nUsed in: filter-mapping, servlet-mapping, web-resource-collection\n-->\n<!ELEMENT url-pattern (#PCDATA)>\n\n<!--\nThe user-data-constraint element is used to indicate how data\ncommunicated between the client and container should be protected.\n\nUsed in: security-constraint\n-->\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n\n<!--\nThe web-resource-collection element is used to identify a subset\nof the resources and HTTP methods on those resources within a web\napplication to which a security constraint applies. If no HTTP methods\nare specified, then the security constraint applies to all HTTP\nmethods.\n\nUsed in: security-constraint\n-->\n<!ELEMENT web-resource-collection (web-resource-name, description?,\nurl-pattern*, http-method*)>\n\n<!--\nThe web-resource-name contains the name of this web resource\ncollection.\n\nUsed in: web-resource-collection\n-->\n<!ELEMENT web-resource-name (#PCDATA)>\n\n<!--\nThe welcome-file element contains file name to use as a default\nwelcome file, such as index.html\n\nUsed in: welcome-file-list\n-->\n<!ELEMENT welcome-file (#PCDATA)>\n\n<!--\nThe welcome-file-list contains an ordered list of welcome files\nelements.\n\nUsed in: web-app\n-->\n<!ELEMENT welcome-file-list (welcome-file+)>\n\n<!--\nThe ID mechanism is to allow tools that produce additional deployment\ninformation (i.e., information beyond the standard deployment\ndescriptor information) to store the non-standard information in a\nseparate file, and easily refer from these tool-specific files to the\ninformation in the standard deployment descriptor.\n\nTools are not allowed to add the non-standard information into the\nstandard deployment descriptor.\n-->\n\n<!ATTLIST auth-constraint id ID #IMPLIED>\n<!ATTLIST auth-method id ID #IMPLIED>\n<!ATTLIST context-param id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST distributable id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-local-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST error-code id ID #IMPLIED>\n<!ATTLIST error-page id ID #IMPLIED>\n<!ATTLIST exception-type id ID #IMPLIED>\n<!ATTLIST extension id ID #IMPLIED>\n<!ATTLIST filter id ID #IMPLIED>\n<!ATTLIST filter-class id ID #IMPLIED>\n<!ATTLIST filter-mapping id ID #IMPLIED>\n<!ATTLIST filter-name id ID #IMPLIED>\n<!ATTLIST form-error-page id ID #IMPLIED>\n<!ATTLIST form-login-config id ID #IMPLIED>\n<!ATTLIST form-login-page id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST http-method id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST init-param id ID #IMPLIED>\n<!ATTLIST jsp-file id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST listener id ID #IMPLIED>\n<!ATTLIST listener-class id ID #IMPLIED>\n<!ATTLIST load-on-startup id ID #IMPLIED>\n<!ATTLIST local id ID #IMPLIED>\n<!ATTLIST local-home id ID #IMPLIED>\n<!ATTLIST location id ID #IMPLIED>\n<!ATTLIST login-config id ID #IMPLIED>\n<!ATTLIST mime-mapping id ID #IMPLIED>\n<!ATTLIST mime-type id ID #IMPLIED>\n<!ATTLIST param-name id ID #IMPLIED>\n<!ATTLIST param-value id ID #IMPLIED>\n<!ATTLIST realm-name id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST role-link id ID #IMPLIED>\n<!ATTLIST role-name id ID #IMPLIED>\n<!ATTLIST run-as id ID #IMPLIED>\n<!ATTLIST security-constraint id ID #IMPLIED>\n<!ATTLIST security-role id ID #IMPLIED>\n<!ATTLIST security-role-ref id ID #IMPLIED>\n<!ATTLIST servlet id ID #IMPLIED>\n<!ATTLIST servlet-class id ID #IMPLIED>\n<!ATTLIST servlet-mapping id ID #IMPLIED>\n<!ATTLIST servlet-name id ID #IMPLIED>\n<!ATTLIST session-config id ID #IMPLIED>\n<!ATTLIST session-timeout id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED>\n<!ATTLIST taglib id ID #IMPLIED>\n<!ATTLIST taglib-location id ID #IMPLIED>\n<!ATTLIST taglib-uri id ID #IMPLIED>\n<!ATTLIST transport-guarantee id ID #IMPLIED>\n<!ATTLIST url-pattern id ID #IMPLIED>\n<!ATTLIST user-data-constraint id ID #IMPLIED>\n<!ATTLIST web-app id ID #IMPLIED>\n<!ATTLIST web-resource-collection id ID #IMPLIED>\n<!ATTLIST web-resource-name id ID #IMPLIED>\n<!ATTLIST welcome-file id ID #IMPLIED>\n<!ATTLIST welcome-file-list id ID #IMPLIED>";
    }

    private class GrailsPluginChangeChecker
    extends Thread {
        DefaultGrailsPluginManager pluginManager;
        boolean enabled = true;

        GrailsPluginChangeChecker(DefaultGrailsPluginManager pluginManager) {
            this.pluginManager = pluginManager;
            this.setDaemon(true);
        }

        public void run() {
            while (this.enabled) {
                try {
                    this.pluginManager.checkForChanges();
                    GrailsPluginChangeChecker.sleep(1000L);
                }
                catch (Exception e) {
                    GrailsUtil.deepSanitize(e);
                    LOG.error((Object)("Error occured scanning for changes: " + e.getMessage()), (Throwable)e);
                    try {
                        GrailsPluginChangeChecker.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

