/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.support;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.springframework.core.io.Resource;

public class GrailsResourceLoader
implements GroovyResourceLoader {
    private Resource[] resources;
    private List loadedResources = new ArrayList();
    private Map classToResource = new HashMap();
    private Map pathToResource = new HashMap();

    public GrailsResourceLoader(Resource[] resources) {
        this.resources = resources;
        this.createPathToURLMappings(resources);
    }

    private void createPathToURLMappings(Resource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            String resourceURL;
            try {
                resourceURL = resources[i].getURL().toString();
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Unable to load Grails resource: " + e.getMessage(), e);
            }
            String pathWithinRoot = GrailsResourceUtils.getPathFromRoot(resourceURL);
            this.pathToResource.put(pathWithinRoot, resources[i]);
        }
    }

    public List getLoadedResources() {
        return this.loadedResources;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
        this.createPathToURLMappings(resources);
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public URL loadGroovySource(String className) throws MalformedURLException {
        if (className == null) {
            return null;
        }
        String groovyFile = className.replace('.', '/') + ".groovy";
        try {
            Resource foundResource = (Resource)this.pathToResource.get(groovyFile);
            if (foundResource != null) {
                this.loadedResources.add(foundResource);
                this.classToResource.put(className, foundResource);
                return foundResource.getURL();
            }
            return null;
        }
        catch (IOException e) {
            throw new GrailsConfigurationException("I/O exception loaded resource:" + e.getMessage(), e);
        }
    }

    public Resource getResourceForClass(Class theClass) {
        return (Resource)this.classToResource.get(theClass.getName());
    }
}

