/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import groovy.lang.GroovyResourceLoader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.springframework.util.Assert;

public class GrailsAwareInjectionOperation
extends CompilationUnit.PrimaryClassNodeOperation {
    private static final Log LOG = LogFactory.getLog(GrailsAwareInjectionOperation.class);
    private GroovyResourceLoader grailsResourceLoader;
    private ClassInjector[] classInjectors = new ClassInjector[0];

    public GrailsAwareInjectionOperation(GroovyResourceLoader resourceLoader, ClassInjector[] injectors) {
        Assert.notNull((Object)resourceLoader, (String)"The argument [resourceLoader] is required!");
        this.grailsResourceLoader = resourceLoader;
        if (injectors != null) {
            this.classInjectors = injectors;
        }
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        for (int i = 0; i < this.classInjectors.length; ++i) {
            ClassInjector classInjector = this.classInjectors[i];
            try {
                URL url = GrailsResourceUtils.isGrailsPath(source.getName()) ? this.grailsResourceLoader.loadGroovySource(GrailsResourceUtils.getClassName(source.getName())) : this.grailsResourceLoader.loadGroovySource(source.getName());
                if (!classInjector.shouldInject(url)) continue;
                classInjector.performInjection(source, context, classNode);
                continue;
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("Error loading URL during addition of compile time properties: " + e.getMessage()), (Throwable)e);
                throw new CompilationFailedException(3, (ProcessingUnit)source, (Throwable)e);
            }
        }
    }
}

