/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.metaclass.GroovyDynamicMethodsInterceptor;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.validation.metaclass.ConstraintsEvaluatingDynamicProperty;

public class GrailsDomainConfigurationUtil {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set BASIC_TYPES;

    public static Serializable getAssociationIdentifier(Object target, String propertyName, GrailsDomainClass referencedDomainClass) {
        String getterName = GrailsClassUtils.getGetterName(propertyName);
        try {
            Method m = target.getClass().getDeclaredMethod(getterName, EMPTY_CLASS_ARRAY);
            Object value = m.invoke(target, null);
            if (value != null && referencedDomainClass != null) {
                String identifierGetter = GrailsClassUtils.getGetterName(referencedDomainClass.getIdentifier().getName());
                m = value.getClass().getDeclaredMethod(identifierGetter, EMPTY_CLASS_ARRAY);
                return (Serializable)m.invoke(value, null);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return null;
    }

    public static void configureDomainClassRelationships(GrailsClass[] domainClasses, Map domainMap) {
        GrailsDomainClassProperty prop;
        int j;
        GrailsDomainClassProperty[] props;
        GrailsDomainClass domainClass;
        int i;
        for (i = 0; i < domainClasses.length; ++i) {
            domainClass = (GrailsDomainClass)domainClasses[i];
            if (!domainClass.isRoot()) {
                GrailsDomainClass gdc;
                Class superClass = domainClasses[i].getClazz().getSuperclass();
                while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class) && (gdc = (GrailsDomainClass)domainMap.get(superClass.getName())) != null && gdc.getSubClasses() != null) {
                    gdc.getSubClasses().add(domainClasses[i]);
                    superClass = superClass.getSuperclass();
                }
            }
            props = domainClass.getPersistentProperties();
            for (j = 0; j < props.length; ++j) {
                if (props[j] == null || !props[j].isAssociation()) continue;
                prop = props[j];
                GrailsDomainClass referencedGrailsDomainClass = (GrailsDomainClass)domainMap.get(props[j].getReferencedPropertyType().getName());
                prop.setReferencedDomainClass(referencedGrailsDomainClass);
            }
        }
        for (i = 0; i < domainClasses.length; ++i) {
            domainClass = (GrailsDomainClass)domainClasses[i];
            props = domainClass.getPersistentProperties();
            block6: for (j = 0; j < props.length; ++j) {
                GrailsDomainClass referenced;
                if (props[j] == null || !props[j].isAssociation() || (referenced = (prop = props[j]).getReferencedDomainClass()) == null) continue;
                boolean isOwnedBy = referenced.isOwningClass(domainClass.getClazz());
                prop.setOwningSide(isOwnedBy);
                String refPropertyName = null;
                try {
                    refPropertyName = prop.getReferencedPropertyName();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (!StringUtils.isBlank((String)refPropertyName)) {
                    GrailsDomainClassProperty otherSide = referenced.getPropertyByName(refPropertyName);
                    prop.setOtherSide(otherSide);
                    otherSide.setOtherSide(prop);
                    continue;
                }
                GrailsDomainClassProperty[] referencedProperties = referenced.getPersistentProperties();
                for (int k = 0; k < referencedProperties.length; ++k) {
                    GrailsDomainClassProperty referencedProp = referencedProperties[k];
                    if (prop.equals(referencedProp) && prop.isBidirectional() || !GrailsDomainConfigurationUtil.isCandidateForOtherSide(domainClass, prop, referencedProp)) continue;
                    prop.setOtherSide(referencedProp);
                    continue block6;
                }
            }
        }
    }

    private static boolean isCandidateForOtherSide(GrailsDomainClass domainClass, GrailsDomainClassProperty prop, GrailsDomainClassProperty referencedProp) {
        if (prop.equals(referencedProp)) {
            return false;
        }
        if (prop.isOneToMany() && referencedProp.isOneToMany()) {
            return false;
        }
        Class referencedPropertyType = referencedProp.getReferencedPropertyType();
        if (referencedPropertyType == null || !referencedPropertyType.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        Map mappedBy = domainClass.getMappedBy();
        Object propertyMapping = mappedBy.get(prop.getName());
        boolean mappedToDifferentProperty = propertyMapping != null && !propertyMapping.equals(referencedProp.getName());
        mappedBy = referencedProp.getDomainClass().getMappedBy();
        propertyMapping = mappedBy.get(referencedProp.getName());
        boolean mappedFromDifferentProperty = propertyMapping != null && !propertyMapping.equals(prop.getName());
        return !mappedToDifferentProperty && !mappedFromDifferentProperty;
    }

    public static String getMappingFileName(String className) {
        String fileName = className.replaceAll("\\.", "/");
        fileName = fileName + ".hbm.xml";
        return fileName;
    }

    public static Map getAssociationMap(Class domainClass) {
        Map associationMap = (Map)GrailsClassUtils.getPropertyValueOfNewInstance(domainClass, "relatesToMany", Map.class);
        if (associationMap == null && (associationMap = (Map)GrailsClassUtils.getPropertyValueOfNewInstance(domainClass, "hasMany", Map.class)) == null) {
            associationMap = Collections.EMPTY_MAP;
        }
        return associationMap;
    }

    public static Map getMappedByMap(Class domainClass) {
        Map mappedByMap = (Map)GrailsClassUtils.getPropertyValueOfNewInstance(domainClass, "mappedBy", Map.class);
        if (mappedByMap == null) {
            return Collections.EMPTY_MAP;
        }
        return mappedByMap;
    }

    public static boolean isBasicType(GrailsDomainClassProperty prop) {
        if (prop == null) {
            return false;
        }
        Class propType = prop.getType();
        return GrailsDomainConfigurationUtil.isBasicType(propType);
    }

    public static boolean isBasicType(Class propType) {
        if (propType.isArray()) {
            return GrailsDomainConfigurationUtil.isBasicType(propType.getComponentType());
        }
        return BASIC_TYPES.contains(propType.getName());
    }

    public static boolean isNotConfigurational(PropertyDescriptor descriptor) {
        return !descriptor.getName().equals("metaClass") && !descriptor.getName().equals("class") && !descriptor.getName().equals("transients") && !descriptor.getName().equals("relatesToMany") && !descriptor.getName().equals("hasMany") && !descriptor.getName().equals("evanescent") && !descriptor.getName().equals("constraints") && !descriptor.getName().equals("mapWith") && !descriptor.getName().equals("mappedBy") && !descriptor.getName().equals("belongsTo");
    }

    public static Map evaluateConstraints(Object instance, GrailsDomainClassProperty[] properties) throws IntrospectionException {
        Closure constraintsClosure = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(instance, "constraints");
        Class<?> objClass = instance.getClass();
        String fullName = objClass.getName();
        if (constraintsClosure != null && !GrailsClassUtils.isStaticProperty(objClass, "constraints")) {
            throw new GrailsConfigurationException("Domain class [" + fullName + "] has non-static constraints. Constraints must be " + "declared static.");
        }
        GroovyObject go = (GroovyObject)instance;
        GroovyDynamicMethodsInterceptor interceptor = new GroovyDynamicMethodsInterceptor(go);
        interceptor.addDynamicProperty(new ConstraintsEvaluatingDynamicProperty(properties));
        return (Map)go.getProperty("constraints");
    }

    static {
        HashSet<String> basics = new HashSet<String>();
        basics.add(Boolean.TYPE.getName());
        basics.add(Long.TYPE.getName());
        basics.add(Short.TYPE.getName());
        basics.add(Integer.TYPE.getName());
        basics.add(Byte.TYPE.getName());
        basics.add(Float.TYPE.getName());
        basics.add(Double.TYPE.getName());
        basics.add(Character.TYPE.getName());
        basics.add(Boolean.class.getName());
        basics.add(Long.class.getName());
        basics.add(Short.class.getName());
        basics.add(Integer.class.getName());
        basics.add(Byte.class.getName());
        basics.add(Float.class.getName());
        basics.add(Double.class.getName());
        basics.add(Character.class.getName());
        basics.add(String.class.getName());
        basics.add(java.util.Date.class.getName());
        basics.add(Time.class.getName());
        basics.add(Timestamp.class.getName());
        basics.add(Date.class.getName());
        basics.add(BigDecimal.class.getName());
        basics.add(BigInteger.class.getName());
        basics.add(Locale.class.getName());
        basics.add(Calendar.class.getName());
        basics.add(GregorianCalendar.class.getName());
        basics.add(Currency.class.getName());
        basics.add(TimeZone.class.getName());
        basics.add(Object.class.getName());
        basics.add(Class.class.getName());
        basics.add(byte[].class.getName());
        basics.add(Byte[].class.getName());
        basics.add(char[].class.getName());
        basics.add(Character[].class.getName());
        basics.add(Blob.class.getName());
        basics.add(Clob.class.getName());
        basics.add(Serializable.class.getName());
        basics.add(URI.class.getName());
        basics.add(URL.class.getName());
        BASIC_TYPES = Collections.unmodifiableSet(basics);
    }
}

