/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.exceptions.NewInstanceCreationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public abstract class AbstractGrailsClass
implements GrailsClass {
    private Class clazz = null;
    private String fullName = null;
    private String name = null;
    private String packageName = null;
    private BeanWrapper reference = null;
    private String naturalName;
    private String shortName;
    private MetaClass metaClass;

    public AbstractGrailsClass(Class clazz, String trailingName) {
        this.setClazz(clazz);
        this.reference = new BeanWrapperImpl(this.newInstance());
        this.fullName = clazz.getName();
        this.packageName = ClassUtils.getPackageName((Class)clazz);
        this.naturalName = GrailsNameUtils.getNaturalName((String)clazz.getName());
        this.shortName = AbstractGrailsClass.getShortClassname(clazz);
        this.name = GrailsNameUtils.getLogicalName((Class)clazz, (String)trailingName);
    }

    public String getShortName() {
        return this.shortName;
    }

    private void setClazz(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter should not be null");
        }
        this.clazz = clazz;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Object newInstance() {
        try {
            Constructor defaultConstructor = this.getClazz().getDeclaredConstructor(new Class[0]);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable targetException = null;
            targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class [" + this.getClazz().getName() + "]!", targetException);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNaturalName() {
        return this.naturalName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPropertyName() {
        return GrailsNameUtils.getPropertyNameRepresentation((String)this.getShortName());
    }

    public String getLogicalPropertyName() {
        String logicalName = this.getName();
        if (StringUtils.isBlank((String)logicalName)) {
            return GrailsNameUtils.getPropertyNameRepresentation((String)this.getShortName());
        }
        return GrailsNameUtils.getPropertyNameRepresentation((String)logicalName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    private static String getShortClassname(Class clazz) {
        return ClassUtils.getShortClassName((Class)clazz);
    }

    public BeanWrapper getReference() {
        Object obj = this.reference.getWrappedInstance();
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(this.getClazz()));
        }
        return this.reference;
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(String name, Class type) {
        BeanWrapper ref = this.getReference();
        Object value = null;
        value = ref.isReadableProperty(name) ? ref.getPropertyValue(name) : (GrailsClassUtils.isPublicField(ref.getWrappedInstance(), name) ? GrailsClassUtils.getFieldValue(ref.getWrappedInstance(), name) : GrailsClassUtils.getStaticPropertyValue(this.clazz, name));
        if (value != null && GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass())) {
            return value;
        }
        return null;
    }

    public Object getPropertyValue(String name, Class type) {
        BeanWrapper ref = this.getReference();
        Object value = null;
        if (ref.isReadableProperty(name)) {
            value = ref.getPropertyValue(name);
        } else {
            Map properties;
            Object inst = ref.getWrappedInstance();
            if (inst instanceof GroovyObject && (properties = DefaultGroovyMethods.getProperties((Object)inst)).containsKey(name)) {
                value = properties.get(name);
            }
        }
        if (value != null && (type.isAssignableFrom(value.getClass()) || GrailsClassUtils.isMatchBetweenPrimativeAndWrapperTypes(type, value.getClass()))) {
            return value;
        }
        return null;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyOrStaticPropertyOrFieldValue(name, Object.class);
    }

    public boolean hasProperty(String name) {
        return this.getReference().isReadableProperty(name);
    }

    public MetaClass getMetaClass() {
        return GrailsClassUtils.getExpandoMetaClass(this.clazz);
    }

    public String toString() {
        return "Artefact > " + this.getName();
    }
}

