/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class FormattedOutput {
    private File file;
    private JUnitResultFormatter formatter;
    private OutputStream output;

    public FormattedOutput(File file, JUnitResultFormatter formatter) {
        this.file = file;
        this.formatter = formatter;
    }

    public File getFile() {
        return this.file;
    }

    public JUnitResultFormatter getFormatter() {
        return this.formatter;
    }

    public void start(JUnitTest test) {
        try {
            this.output = new BufferedOutputStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.formatter.setOutput(this.output);
        this.formatter.startTestSuite(test);
    }

    public void end(JUnitTest test, String out, String err) {
        if (this.file.getName().endsWith(".txt")) {
            String baseName = this.file.getName().substring(0, this.file.getName().length() - 4);
            this.writeToFile(new File(this.file.getParentFile(), baseName + "-out.txt"), out);
            this.writeToFile(new File(this.file.getParentFile(), baseName + "-err.txt"), err);
        }
        this.formatter.setSystemOutput(out);
        this.formatter.setSystemError(err);
        this.formatter.endTestSuite(test);
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private void writeToFile(File file, String text) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(text);
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

