/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.injection.GrailsInjectionOperation;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GrailsApplicationFactoryBean
implements FactoryBean,
InitializingBean {
    private static Log LOG = LogFactory.getLog(GrailsApplicationFactoryBean.class);
    private GrailsInjectionOperation injectionOperation = null;
    private GrailsApplication grailsApplication = null;
    private GrailsResourceLoader resourceLoader;
    private Resource descriptor;

    public GrailsInjectionOperation getInjectionOperation() {
        return this.injectionOperation;
    }

    public void setInjectionOperation(GrailsInjectionOperation injectionOperation) {
        this.injectionOperation = injectionOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.descriptor != null && this.descriptor.exists()) {
            CompilerConfiguration config = CompilerConfiguration.DEFAULT;
            config.setSourceEncoding("UTF-8");
            GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
            ArrayList<Class> classes = new ArrayList<Class>();
            InputStream inputStream = null;
            try {
                inputStream = this.descriptor.getInputStream();
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList grailsClasses = (NodeList)xpath.evaluate("/grails/resources/resource", new InputSource(inputStream), XPathConstants.NODESET);
                for (int i = 0; i < grailsClasses.getLength(); ++i) {
                    Node node = grailsClasses.item(i);
                    try {
                        classes.add(classLoader.loadClass(node.getTextContent()));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn((Object)("Class with name [" + node.getTextContent() + "] was not found, and hence not loaded. Possible empty class or script definition?"));
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            Class[] loadedClasses = classes.toArray(new Class[classes.size()]);
            this.grailsApplication = new DefaultGrailsApplication(loadedClasses, classLoader);
        } else {
            Assert.notNull((Object)this.resourceLoader, (String)"Property [resourceLoader] must be set!");
            this.grailsApplication = new DefaultGrailsApplication(this.resourceLoader);
        }
        ApplicationHolder.setApplication(this.grailsApplication);
    }

    public Object getObject() throws Exception {
        return this.grailsApplication;
    }

    public Class getObjectType() {
        return GrailsApplication.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setGrailsDescriptor(Resource r) {
        this.descriptor = r;
    }
}

